/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.win.Task;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.loader.NativeLibraryLoader;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
final class WinShellIntegration
implements Disposable {
    public static final boolean isAvailable;
    @NotNull
    private final Bridge bridge;

    @Nullable
    public static WinShellIntegration getInstance() {
        return isAvailable ? (WinShellIntegration)ServiceManager.getService(WinShellIntegration.class) : null;
    }

    @NotNull
    public <R> Future<R> postShellTask(@NotNull ShellTask<? extends R> shellTask) {
        if (shellTask == null) {
            WinShellIntegration.$$$reportNull$$$0(0);
        }
        ShellContext ctx = new ShellContext(this);
        Future<Object> future2 = this.bridge.comExecutor.submit(() -> {
            try {
                Object r = shellTask.run(ctx);
                return r;
            }
            finally {
                ctx.parent = null;
            }
        });
        if (future2 == null) {
            WinShellIntegration.$$$reportNull$$$0(1);
        }
        return future2;
    }

    @NotNull
    public Future<?> postShellTask(@NotNull VoidShellTask shellTask) {
        if (shellTask == null) {
            WinShellIntegration.$$$reportNull$$$0(2);
        }
        ShellContext ctx = new ShellContext(this);
        Future<?> future2 = this.bridge.comExecutor.submit(() -> {
            try {
                shellTask.run(ctx);
            }
            finally {
                ctx.parent = null;
            }
        });
        if (future2 == null) {
            WinShellIntegration.$$$reportNull$$$0(3);
        }
        return future2;
    }

    private WinShellIntegration() {
        if (!isAvailable) {
            throw new AssertionError((Object)"Feature is not available");
        }
        this.bridge = new Bridge();
    }

    @ApiStatus.Internal
    public void dispose() {
        this.bridge.comExecutor.shutdown();
    }

    private void clearRecentTasksList() {
        this.bridge.ensureNativeIsInitialized();
        this.bridge.clearRecentTasksListNative();
    }

    private void setRecentTasksList(@NotNull @NotNull Task @NotNull [] recentTasks) {
        if (recentTasks == null) {
            WinShellIntegration.$$$reportNull$$$0(4);
        }
        this.bridge.ensureNativeIsInitialized();
        this.bridge.setRecentTasksListNative(recentTasks);
    }

    static {
        boolean ideIsLaunchedViaDLL = Boolean.getBoolean("ide.native.launcher");
        isAvailable = SystemInfo.isWin8OrNewer && ideIsLaunchedViaDLL && !Boolean.getBoolean("ide.win.shell.integration.disabled");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellTask";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/win/WinShellIntegration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/win/WinShellIntegration";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "postShellTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "postShellTask";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRecentTasksList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Bridge {
        private final ThreadPoolExecutor comExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Windows Shell integration");
        private boolean nativeIsInitialized = false;

        private Bridge() {
        }

        private void ensureNativeIsInitialized() {
            if (this.nativeIsInitialized) {
                return;
            }
            this.initializeNative();
            this.nativeIsInitialized = true;
        }

        private native void setAppUserModelIdNative(@NotNull String var1);

        private native void initializeNative();

        private native void clearRecentTasksListNative();

        private native void setRecentTasksListNative(@NotNull @NotNull Task @NotNull [] var1);

        static {
            NativeLibraryLoader.loadPlatformLibrary((String)"WinShellIntegrationBridge");
        }
    }

    public static interface VoidShellTask {
        public void run(@NotNull ShellContext var1);
    }

    public static interface ShellTask<R> {
        public R run(@NotNull ShellContext var1);
    }

    public static final class ShellContext {
        private WinShellIntegration parent;

        public void clearRecentTasksList() {
            this.parent.clearRecentTasksList();
        }

        public void setRecentTasksList(@NotNull @NotNull Task @NotNull [] recentTasks) {
            if (recentTasks == null) {
                ShellContext.$$$reportNull$$$0(0);
            }
            this.parent.setRecentTasksList(recentTasks);
        }

        private ShellContext(@NotNull WinShellIntegration parent) {
            if (parent == null) {
                ShellContext.$$$reportNull$$$0(1);
            }
            this.parent = parent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recentTasks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/win/WinShellIntegration$ShellContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRecentTasksList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

