/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.ui.tabs.PerTeamFileColorModelStorageManager;
import com.intellij.ui.tabs.PerUserFileColorModelStorageManager;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorManagerImpl
extends FileColorManager {
    private static final String FC_ENABLED = "FileColorsEnabled";
    private static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    private static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private final NotNullLazyValue<FileColorsModel> myInitializedModel;
    private static final Map<String, Color> ourDefaultColors = Map.of("Blue", JBColor.namedColor((String)"FileColor.Blue", (Color)new JBColor(15398655, 5199211)), "Green", JBColor.namedColor((String)"FileColor.Green", (Color)new JBColor(15727335, 4805706)), "Orange", JBColor.namedColor((String)"FileColor.Orange", (Color)new JBColor(16181724, 8413266)), "Rose", JBColor.namedColor((String)"FileColor.Rose", (Color)new JBColor(15916250, 7230299)), "Violet", JBColor.namedColor((String)"FileColor.Violet", (Color)new JBColor(15130865, 5458519)), "Yellow", JBColor.namedColor((String)"FileColor.Yellow", (Color)new JBColor(0xFFFFE4, 5196609)));

    public FileColorManagerImpl(@NotNull Project project) {
        if (project == null) {
            FileColorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myModel = new FileColorsModel(project);
        this.myInitializedModel = NotNullLazyValue.createValue(() -> {
            project.getService(PerTeamFileColorModelStorageManager.class);
            project.getService(PerUserFileColorModelStorageManager.class);
            return this.myModel;
        });
    }

    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    @ApiStatus.Internal
    public static void setEnabledForTabs(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
    }

    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    @ApiStatus.Internal
    public static boolean _isEnabledForTabs() {
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    @Nullable
    public Color getColor(@NotNull @NonNls String id2) {
        Color color;
        if (id2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(1);
        }
        return (color = ourDefaultColors.get(id2)) == null ? ColorUtil.fromHex((String)id2, null) : color;
    }

    @NotNull
    @Nls
    public String getColorName(@NotNull @NonNls String id2) {
        if (id2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(2);
        }
        String string = ourDefaultColors.containsKey(id2) ? IdeBundle.message((String)("color.name." + id2.toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]) : IdeBundle.message((String)"settings.file.color.custom.name", (Object[])new Object[0]);
        if (string == null) {
            FileColorManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Collection<@NonNls String> getColorIDs() {
        ArrayList<String> sorted = new ArrayList<String>(ourDefaultColors.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    public Collection<@Nls String> getColorNames() {
        ArrayList<String> list2 = new ArrayList<String>(ourDefaultColors.size());
        for (String key : ourDefaultColors.keySet()) {
            list2.add(IdeBundle.message((String)("color.name." + key.toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
        }
        list2.sort(null);
        return list2;
    }

    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return null;
    }

    @Nullable
    public Color getRendererBackground(PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    public void addScopeColor(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(4);
        }
        if (colorName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(5);
        }
        ((FileColorsModel)this.myInitializedModel.getValue()).add(scopeName, colorName, isProjectLevel);
    }

    @Nullable
    public Color getFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = ((FileColorsModel)this.myInitializedModel.getValue()).getColor(file2, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getScopeColor(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(7);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = ((FileColorsModel)this.myInitializedModel.getValue()).getScopeColor(scopeName, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(8);
        }
        return ((FileColorsModel)this.myInitializedModel.getValue()).isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        FileColorsModel fileColorsModel = (FileColorsModel)this.myInitializedModel.getValue();
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(9);
        }
        return fileColorsModel;
    }

    @NotNull
    FileColorsModel getUninitializedModel() {
        FileColorsModel fileColorsModel = this.myModel;
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(10);
        }
        return fileColorsModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        List<FileColorConfiguration> list2 = ((FileColorsModel)this.myInitializedModel.getValue()).getLocalConfigurations();
        if (list2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return ((FileColorsModel)this.myInitializedModel.getValue()).getProjectLevelConfigurations();
    }

    @Nullable
    @NonNls
    public static String getColorID(@NotNull Color color) {
        if (color == null) {
            FileColorManagerImpl.$$$reportNull$$$0(12);
        }
        for (Map.Entry<String, Color> entry : ourDefaultColors.entrySet()) {
            if (!color.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nls
    static String getAlias(@Nls String text2) {
        return StartupUiUtil.isUnderDarcula() && text2.equals(IdeBundle.message((String)"color.name.yellow", (Object[])new Object[0])) ? IdeBundle.message((String)"color.name.brown", (Object[])new Object[0]) : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationLevelConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColorName";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeColor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isShared";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColorID";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

