/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxPopup<T>
extends ListPopupImpl {
    private final Context<T> myContext;

    public ComboBoxPopup(@NotNull Context<T> context, @Nullable T selectedItem, @NotNull Consumer<? super T> onItemSelected2) {
        if (context == null) {
            ComboBoxPopup.$$$reportNull$$$0(0);
        }
        if (onItemSelected2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(1);
        }
        this(context, null, ComboBoxPopup.popupStateFromContext(context, onItemSelected2, selectedItem), null);
    }

    private ComboBoxPopup(@NotNull Context<T> context, @Nullable WizardPopup aParent, @NotNull MyBasePopupState<T> aStep, @Nullable Object parentValue) {
        if (context == null) {
            ComboBoxPopup.$$$reportNull$$$0(2);
        }
        if (aStep == null) {
            ComboBoxPopup.$$$reportNull$$$0(3);
        }
        super(context.getProject(), aParent, (ListPopupStep)aStep, parentValue);
        this.myContext = context;
        this.configurePopup();
    }

    @NotNull
    private static <T> MyBasePopupState<T> popupStateFromContext(final @NotNull Context<T> context, @NotNull Consumer<? super T> onItemSelected2, @Nullable T selectedItem) {
        if (context == null) {
            ComboBoxPopup.$$$reportNull$$$0(4);
        }
        if (onItemSelected2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(5);
        }
        MyBasePopupState step = new MyBasePopupState<T>(onItemSelected2, () -> context.getModel(), () -> context.getRenderer()){

            public void canceled() {
                context.onPopupStepCancelled();
            }
        };
        if (selectedItem != null) {
            step.setDefaultOptionIndex(step.getValues().indexOf(selectedItem));
        }
        MyBasePopupState myBasePopupState = step;
        if (myBasePopupState == null) {
            ComboBoxPopup.$$$reportNull$$$0(6);
        }
        return myBasePopupState;
    }

    public void syncWithModelChange() {
        this.disposeChildren();
        MyBasePopupState step = (MyBasePopupState)((Object)this.getStep());
        List values = step.getValues();
        values.clear();
        values.addAll(ComboBoxPopup.copyItemsFromModel(this.myContext.getModel()));
        JList<T> popupList = this.getList();
        ((ListPopupModel)popupList.getModel()).syncModel();
        JComponent content2 = this.getContent();
        content2.setPreferredSize(null);
        Dimension newSize = content2.getPreferredSize();
        content2.setPreferredSize(newSize);
        this.setSize(newSize);
        this.moveToFitScreen();
    }

    @Override
    @NotNull
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        if (step instanceof MyBasePopupState) {
            return new ComboBoxPopup<T>(this.myContext, parent, (MyBasePopupState)((Object)step), parentValue);
        }
        throw new IllegalArgumentException(step.getClass().toString());
    }

    @Override
    public JList<T> getList() {
        return super.getList();
    }

    protected ListCellRenderer<T> getListElementRenderer() {
        return new MyDelegateRenderer();
    }

    private void configurePopup() {
        this.setMaxRowCount(this.myContext.getMaximumRowCount());
        this.setRequestFocus(false);
        JList<T> list2 = this.getList();
        this.myContext.configureList(list2);
        list2.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
        list2.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
        list2.setBorder(null);
        list2.setFocusable(false);
        list2.setSelectionMode(0);
        Border border = UIManager.getBorder("ComboPopup.border");
        if (border != null) {
            this.getContent().setBorder(border);
        }
    }

    @NotNull
    private static <T> List<T> copyItemsFromModel(@NotNull ListModel<T> model2) {
        if (model2 == null) {
            ComboBoxPopup.$$$reportNull$$$0(7);
        }
        ArrayList<T> items = new ArrayList<T>(model2.getSize());
        int size = model2.getSize();
        for (int i2 = 0; i2 < size; ++i2) {
            items.add(model2.getElementAt(i2));
        }
        ArrayList<T> arrayList = items;
        if (arrayList == null) {
            ComboBoxPopup.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onItemSelected";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/list/ComboBoxPopup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/list/ComboBoxPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "popupStateFromContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyItemsFromModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "popupStateFromContext";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyItemsFromModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBasePopupState<T>
    extends BaseListPopupStep<T> {
        private final JBList<T> myProxyList;
        private final Consumer<? super T> myOnItemSelected;
        @NotNull
        private final Supplier<? extends ListModel<T>> myGetComboboxModel;
        private final Supplier<? extends ListCellRenderer<? super T>> myGetRenderer;

        private MyBasePopupState(@NotNull Consumer<? super T> onItemSelected2, @NotNull Supplier<? extends ListModel<T>> getComboboxModel, @NotNull Supplier<? extends ListCellRenderer<? super T>> getRenderer2) {
            if (onItemSelected2 == null) {
                MyBasePopupState.$$$reportNull$$$0(0);
            }
            if (getComboboxModel == null) {
                MyBasePopupState.$$$reportNull$$$0(1);
            }
            if (getRenderer2 == null) {
                MyBasePopupState.$$$reportNull$$$0(2);
            }
            super(null, ComboBoxPopup.copyItemsFromModel(getComboboxModel.get()));
            this.myProxyList = new JBList();
            this.myOnItemSelected = onItemSelected2;
            this.myGetComboboxModel = getComboboxModel;
            this.myGetRenderer = getRenderer2;
        }

        @Nullable
        public PopupStep onChosen(T selectedValue, boolean finalChoice) {
            ListModel nextModel;
            ListModel<T> model2 = this.myGetComboboxModel.get();
            if (model2 instanceof ComboBoxPopupState && (nextModel = ((ComboBoxPopupState)model2).onChosen(selectedValue)) != null) {
                return new MyBasePopupState<T>(this.myOnItemSelected, () -> nextModel, this.myGetRenderer);
            }
            ApplicationManager.getApplication().invokeLater(() -> this.myOnItemSelected.accept(selectedValue));
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(T selectedValue) {
            ListModel<T> model2 = this.myGetComboboxModel.get();
            if (model2 instanceof ComboBoxPopupState) {
                return ((ComboBoxPopupState)model2).hasSubstep(selectedValue);
            }
            return super.hasSubstep(selectedValue);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(T value2) {
            Component component2 = this.myGetRenderer.get().getListCellRendererComponent((JList<T>)this.myProxyList, value2, -1, false, false);
            String string = component2 instanceof TitledSeparator || component2 instanceof JSeparator ? "" : (component2 instanceof JLabel ? ((JLabel)component2).getText() : (component2 instanceof SimpleColoredComponent ? ((SimpleColoredComponent)component2).getCharSequence(false).toString() : String.valueOf(value2)));
            if (string == null) {
                MyBasePopupState.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isSelectable(T value2) {
            Component component2 = this.myGetRenderer.get().getListCellRendererComponent((JList<T>)this.myProxyList, value2, -1, false, false);
            return !(component2 instanceof TitledSeparator) && !(component2 instanceof JSeparator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onItemSelected";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getComboboxModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/list/ComboBoxPopup$MyBasePopupState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/list/ComboBoxPopup$MyBasePopupState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDelegateRenderer
    implements ListCellRenderer<T> {
        private MyDelegateRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
            Component component2 = ComboBoxPopup.this.myContext.getRenderer().getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
            if (component2 instanceof JComponent && !(component2 instanceof JSeparator) && !(component2 instanceof TitledSeparator)) {
                JComponent jComponent = (JComponent)component2;
                jComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)8));
                ComboBoxPopup.this.myContext.customizeListRendererComponent(jComponent);
            }
            return component2;
        }
    }

    public static interface SelectionListener<T>
    extends EventListener {
        public void setSelectedItem(@NotNull T var1);
    }

    public static interface Context<T> {
        @Nullable
        public Project getProject();

        @NotNull
        public ListModel<T> getModel();

        @NotNull
        public ListCellRenderer<? super T> getRenderer();

        default public int getMaximumRowCount() {
            return 10;
        }

        default public void onPopupStepCancelled() {
        }

        default public void configureList(@NotNull JList<T> list2) {
            if (list2 == null) {
                Context.$$$reportNull$$$0(0);
            }
        }

        default public void customizeListRendererComponent(JComponent component2) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/popup/list/ComboBoxPopup$Context", "configureList"));
        }
    }
}

