/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.messages.JBMacMessages;
import com.intellij.ui.messages.MacMessageHelper;
import com.intellij.ui.messages.MacMessageManagerImplKt;
import com.intellij.ui.messages.MessageInfo;
import java.awt.Window;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010!R\u0011\u0010'\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)\u00a8\u0006+"}, d2={"Lcom/intellij/ui/messages/MessageInfo;", "", "title", "", "message", "buttons", "", "errorStyle", "", "window", "Ljava/awt/Window;", "defaultOptionIndex", "", "doNotAskDialogOption", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ZLjava/awt/Window;ILcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;)V", "getButtons", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getDefaultOptionIndex", "()I", "getDoNotAskDialogOption", "()Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "getErrorStyle", "()Z", "mainHandler", "Lkotlin/Function0;", "", "getMainHandler", "()Lkotlin/jvm/functions/Function0;", "setMainHandler", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Ljava/lang/String;", "nativeWindow", "Lcom/intellij/ui/mac/foundation/ID;", "getNativeWindow", "()Lcom/intellij/ui/mac/foundation/ID;", "getTitle", "visibleWindow", "getVisibleWindow", "()Ljava/awt/Window;", "getWindow", "intellij.platform.ide.impl"})
final class MessageInfo {
    @NotNull
    private final String message;
    @NotNull
    private final Window window;
    @NotNull
    private final Window visibleWindow;
    @NotNull
    private final ID nativeWindow;
    @NotNull
    private Function0<Unit> mainHandler;
    @NotNull
    private final String title;
    @NotNull
    private final String[] buttons;
    private final boolean errorStyle;
    private final int defaultOptionIndex;
    @Nullable
    private final DialogWrapper.DoNotAskOption doNotAskDialogOption;

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final Window getWindow() {
        return this.window;
    }

    @NotNull
    public final Window getVisibleWindow() {
        return this.visibleWindow;
    }

    @NotNull
    public final ID getNativeWindow() {
        return this.nativeWindow;
    }

    @NotNull
    public final Function0<Unit> getMainHandler() {
        return this.mainHandler;
    }

    public final void setMainHandler(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.mainHandler = function0;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String[] getButtons() {
        return this.buttons;
    }

    public final boolean getErrorStyle() {
        return this.errorStyle;
    }

    public final int getDefaultOptionIndex() {
        return this.defaultOptionIndex;
    }

    @Nullable
    public final DialogWrapper.DoNotAskOption getDoNotAskDialogOption() {
        return this.doNotAskDialogOption;
    }

    public MessageInfo(@NotNull String title, @Nullable String message2, @NotNull String[] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        this.title = title;
        this.buttons = buttons;
        this.errorStyle = errorStyle;
        this.defaultOptionIndex = defaultOptionIndex;
        this.doNotAskDialogOption = doNotAskDialogOption;
        this.message = MacMessageHelper.Companion.stripHtmlMessage(message2);
        this.mainHandler = mainHandler.1.INSTANCE;
        Window popupWindow = null;
        StackingPopupDispatcher stackingPopupDispatcher = StackingPopupDispatcher.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)stackingPopupDispatcher, (String)"StackingPopupDispatcher.getInstance()");
        JBPopup popup2 = stackingPopupDispatcher.getFocusedPopup();
        if (popup2 != null) {
            popupWindow = SwingUtilities.getWindowAncestor(popup2.getContent());
        }
        if (popupWindow == null) {
            Window window2 = window;
            if (window2 == null) {
                Window window3 = JBMacMessages.getForemostWindow();
                window2 = window3;
                Intrinsics.checkNotNullExpressionValue((Object)window3, (String)"JBMacMessages.getForemostWindow()");
            }
            this.window = window2;
        } else {
            this.window = popupWindow;
        }
        this.visibleWindow = MacMessageManagerImplKt.access$getVisibleWindow(this.window);
        ID iD = MacUtil.getWindowFromJavaWindow((Window)this.visibleWindow);
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"MacUtil.getWindowFromJav\u2026indow(this.visibleWindow)");
        this.nativeWindow = iD;
    }
}

