/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.messages.JBMacMessages;
import com.intellij.ui.messages.NativeMacMessageManager;
import java.awt.Container;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\fH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enableEscapeToCloseTheMessage", "", "alert", "Lcom/intellij/ui/mac/foundation/ID;", "getActualWindow", "window", "getLocalMacMessages", "Lcom/intellij/ui/mac/MacMessages;", "getVisibleWindow", "Ljava/awt/Window;", "intellij.platform.ide.impl"})
public final class MacMessageManagerImplKt {
    private static final Logger LOG;

    @NotNull
    public static final MacMessages getLocalMacMessages() {
        if (SystemInfo.isJetBrainsJvm) {
            if (SystemInfo.isMacOSBigSur) {
                if (Registry.is((String)"ide.mac.bigsur.alerts.enabled", (boolean)true)) {
                    boolean $i$f$service = false;
                    Class<NativeMacMessageManager> serviceClass$iv = NativeMacMessageManager.class;
                    Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object == null) {
                        throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                    }
                    return (MacMessages)object;
                }
                boolean $i$f$service = false;
                Class<JBMacMessages> serviceClass$iv = JBMacMessages.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                return (MacMessages)object;
            }
            if (!Registry.is((String)"ide.mac.message.sheets.java.emulation.dialogs", (boolean)true)) {
                boolean $i$f$service = false;
                Class<NativeMacMessageManager> serviceClass$iv = NativeMacMessageManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                return (MacMessages)object;
            }
        }
        boolean $i$f$service = false;
        Class<JBMacMessages> serviceClass$iv = JBMacMessages.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (MacMessages)object;
    }

    private static final Window getVisibleWindow(Window window) {
        Container parent;
        if (!window.isVisible() && (parent = window.getParent()) instanceof Window) {
            return MacMessageManagerImplKt.getVisibleWindow((Window)parent);
        }
        return window;
    }

    private static final ID getActualWindow(ID window) {
        if (!Foundation.invoke((ID)window, (String)"isVisible", (Object[])new Object[0]).booleanValue() || ID.NIL.equals((Object)Foundation.invoke((ID)window, (String)"screen", (Object[])new Object[0]))) {
            return null;
        }
        return window;
    }

    private static final void enableEscapeToCloseTheMessage(ID alert) {
        int buttonCount = Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"buttons", (Object[])new Object[0]), (String)"count", (Object[])new Object[0]).intValue();
        if (buttonCount > 1) {
            ID iD = Foundation.invoke((ID)Foundation.invoke((ID)alert, (String)"buttons", (Object[])new Object[0]), (String)"objectAtIndex:", (Object[])new Object[]{buttonCount - 1});
            Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"Foundation.invoke(Founda\u2026Index:\", buttonCount - 1)");
            ID button2 = iD;
            Foundation.invoke((ID)button2, (String)"setKeyEquivalent:", (Object[])new Object[]{Foundation.nsString((String)"\u001b")});
        }
    }

    static {
        Logger logger = Logger.getInstance(MacMessages.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(MacMessages::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Window access$getVisibleWindow(Window window) {
        return MacMessageManagerImplKt.getVisibleWindow(window);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ID access$getActualWindow(ID window) {
        return MacMessageManagerImplKt.getActualWindow(window);
    }

    public static final /* synthetic */ void access$enableEscapeToCloseTheMessage(ID alert) {
        MacMessageManagerImplKt.enableEscapeToCloseTheMessage(alert);
    }
}

