/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.BundleBase;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ModalityHelper;
import com.intellij.ui.mac.MacMessages;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.messages.SheetMessage;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@ApiStatus.Internal
public final class JBMacMessages
extends MacMessages {
    public int showYesNoCancelDialog(@NotNull String title, @NotNull String message2, @NotNull String yesText, @NotNull String noText, @NotNull String cancelText, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        int result2;
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            JBMacMessages.$$$reportNull$$$0(1);
        }
        if (yesText == null) {
            JBMacMessages.$$$reportNull$$$0(2);
        }
        if (noText == null) {
            JBMacMessages.$$$reportNull$$$0(3);
        }
        if (cancelText == null) {
            JBMacMessages.$$$reportNull$$$0(4);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow();
        }
        String defaultButtonCleaned = yesText.replace(BundleBase.MNEMONIC_STRING, "");
        String otherButtonCleaned = cancelText.replace(BundleBase.MNEMONIC_STRING, "");
        String alternateButtonCleaned = noText.replace(BundleBase.MNEMONIC_STRING, "");
        SheetMessage sheetMessage = new SheetMessage(window, title, message2, UIUtil.getQuestionIcon(), new String[]{defaultButtonCleaned, otherButtonCleaned, alternateButtonCleaned}, doNotAskOption, yesText, noText);
        String resultString = sheetMessage.getResult();
        int n = resultString.equals(defaultButtonCleaned) ? 0 : (result2 = resultString.equals(alternateButtonCleaned) ? 1 : 2);
        if (doNotAskOption != null) {
            doNotAskOption.setToBeShown(sheetMessage.toBeShown(), result2);
        }
        return result2;
    }

    public int showMessageDialog(@NotNull String title, String message2, String @NotNull [] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, int focusedOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(5);
        }
        if (buttons == null) {
            JBMacMessages.$$$reportNull$$$0(6);
        }
        if (window == null) {
            window = JBMacMessages.getForemostWindow();
        }
        Icon icon2 = errorStyle ? UIUtil.getErrorIcon() : UIUtil.getInformationIcon();
        String defaultOptionTitle = defaultOptionIndex != -1 ? buttons[defaultOptionIndex] : null;
        String focusedButtonTitle = focusedOptionIndex != -1 ? buttons[focusedOptionIndex] : null;
        SheetMessage sheetMessage = new SheetMessage(window, title, message2, icon2, buttons, doNotAskDialogOption, defaultOptionTitle, focusedButtonTitle);
        String result2 = sheetMessage.getResult();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            if (!result2.equals(buttons[i2])) continue;
            if (doNotAskDialogOption != null) {
                doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), i2);
            }
            return i2;
        }
        return -1;
    }

    public void showOkMessageDialog(@NotNull String title, String message2, @NotNull String okText, @Nullable Window window) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(7);
        }
        if (okText == null) {
            JBMacMessages.$$$reportNull$$$0(8);
        }
        new SheetMessage(window == null ? JBMacMessages.getForemostWindow() : window, title, message2, UIUtil.getInformationIcon(), new String[]{okText}, null, okText, okText);
    }

    @NotNull
    static Window getForemostWindow() {
        Dialog result2;
        Window window = null;
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
        if (focusOwner != null) {
            window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (window == null && (focusOwner = ideFocusManager.getLastFocusedFor(ideFocusManager.getLastFocusedIdeWindow())) != null) {
            window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (window == null) {
            window = WindowManager.getInstance().findVisibleFrame();
        }
        while (window != null && ModalityHelper.isModalBlocked(window) && (result2 = ModalityHelper.getModalBlockerFor(window)) != null) {
            window = result2;
        }
        while (window != null && MacUtil.getWindowTitle((Window)window) == null) {
            window = window.getOwner();
        }
        while (window instanceof JDialog && Registry.is((String)"skip.untitled.windows.for.mac.messages", (boolean)false) && !((JDialog)window).isModal()) {
            window = window.getOwner();
        }
        while (window != null && window.getParent() != null && WindowManager.getInstance().isNotSuggestAsParent(window)) {
            window = window.getOwner();
        }
        if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
            throw new IllegalStateException("Cannot find any window");
        }
        Window window2 = window;
        if (window2 == null) {
            JBMacMessages.$$$reportNull$$$0(9);
        }
        return window2;
    }

    public boolean showYesNoDialog(@NotNull String title, @NotNull String message2, @NotNull String yesText, @NotNull String noText, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            JBMacMessages.$$$reportNull$$$0(11);
        }
        if (yesText == null) {
            JBMacMessages.$$$reportNull$$$0(12);
        }
        if (noText == null) {
            JBMacMessages.$$$reportNull$$$0(13);
        }
        SheetMessage sheetMessage = new SheetMessage(window == null ? JBMacMessages.getForemostWindow() : window, title, message2, UIUtil.getQuestionIcon(), new String[]{yesText, noText}, doNotAskDialogOption, yesText, noText);
        boolean result2 = sheetMessage.getResult().equals(yesText);
        if (doNotAskDialogOption != null && (result2 || doNotAskDialogOption.shouldSaveOptionsOnCancel())) {
            doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), result2 ? 0 : 1);
        }
        return result2;
    }

    public void showErrorDialog(@NotNull String title, String message2, @NotNull String okButton, @Nullable Window window) {
        if (title == null) {
            JBMacMessages.$$$reportNull$$$0(14);
        }
        if (okButton == null) {
            JBMacMessages.$$$reportNull$$$0(15);
        }
        new SheetMessage(window == null ? JBMacMessages.getForemostWindow() : window, title, message2, UIUtil.getErrorIcon(), new String[]{okButton}, null, null, okButton);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yesText";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/messages/JBMacMessages";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/messages/JBMacMessages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getForemostWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoCancelDialog";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showMessageDialog";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showOkMessageDialog";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

