/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TouchBar;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class TBItemPopover
extends TBItem {
    private final Icon myIcon;
    private final String myText;
    private final int myWidthPix;
    private TouchBar myExpandTB;
    private TouchBar myTapAndHoldTB;

    TBItemPopover(@Nullable ItemListener listener2, Icon icon2, String text2, int widthInPix, TouchBar expandTB, TouchBar tapAndHoldTB) {
        super("popover", listener2);
        this.myIcon = icon2 != null ? IconLoader.getDarkIcon((Icon)icon2, (boolean)true) : null;
        this.myText = text2;
        this.myWidthPix = widthInPix;
        this.myExpandTB = expandTB;
        this.myTapAndHoldTB = tapAndHoldTB;
    }

    @Override
    void releaseNativePeer() {
        if (this.myExpandTB != null) {
            this.myExpandTB.release();
        }
        if (this.myTapAndHoldTB != null) {
            this.myTapAndHoldTB.release();
        }
        this.myExpandTB = null;
        this.myTapAndHoldTB = null;
        super.releaseNativePeer();
    }

    @Override
    protected ID _createNativePeer() {
        return NST.createPopover(this.getUid(), this.myWidthPix, this.myText, this.myIcon, TBItemPopover.getNativePeer(this.myExpandTB), TBItemPopover.getNativePeer(this.myTapAndHoldTB));
    }

    private static ID getNativePeer(TouchBar tb) {
        return tb == null ? ID.NIL : tb.getNativePeer();
    }
}

