/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.impl.SystemDock;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public final class MacDockDelegate
implements SystemDock.Delegate {
    private static final Logger LOG = Logger.getInstance(MacDockDelegate.class);
    private static boolean initialized = false;
    private static final SystemDock.Delegate instance = new MacDockDelegate();
    private static final PopupMenu dockMenu = new PopupMenu("DockMenu");
    private static final Menu recentProjectsMenu = new Menu("Recent Projects");

    private MacDockDelegate() {
    }

    private static void initDockMenu() {
        dockMenu.add(recentProjectsMenu);
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Object application = appClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            appClass.getMethod("setDockMenu", PopupMenu.class).invoke(application, dockMenu);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void updateRecentProjectsMenu() {
        RecentProjectsManager projectsManager = RecentProjectsManager.getInstance();
        if (projectsManager == null) {
            return;
        }
        List<AnAction> recentProjectActions = RecentProjectListActionProvider.getInstance().getActions(false);
        recentProjectsMenu.removeAll();
        for (final AnAction action2 : recentProjectActions) {
            MenuItem menuItem = new MenuItem(((ReopenProjectAction)action2).getProjectName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"DockMenu", (DataContext)DataManager.getInstance().getDataContext(null)));
                }
            });
            recentProjectsMenu.add(menuItem);
        }
    }

    public static synchronized SystemDock.Delegate getInstance() {
        if (!initialized) {
            MacDockDelegate.initDockMenu();
            initialized = true;
        }
        return instance;
    }
}

