/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.colorpicker.ColorAdjustPanel;
import com.intellij.ui.colorpicker.ColorListenerInfo;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerComponentProvider;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.ColorValuePanel;
import com.intellij.ui.colorpicker.GraphicalColorPipetteProvider;
import com.intellij.ui.colorpicker.LightCalloutPopup;
import com.intellij.ui.colorpicker.MyFocusTraversalPolicy;
import com.intellij.ui.colorpicker.OperationPanel;
import com.intellij.ui.colorpicker.SaturationBrightnessComponent;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\tJ2\u0010%\u001a\u00020\u00002\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020(\u0018\u00010'2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020(\u0018\u00010'J\u0006\u0010*\u001a\u00020\u0000J\u0006\u0010+\u001a\u00020\u0000J\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u00100\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0006\u00101\u001a\u00020\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/ui/colorpicker/ColorPickerBuilder;", "", "showAlpha", "", "showAlphaAsPercent", "(ZZ)V", "actionMap", "", "Ljavax/swing/KeyStroke;", "Ljavax/swing/Action;", "colorListeners", "", "Lcom/intellij/ui/colorpicker/ColorListenerInfo;", "componentsToBuild", "Ljavax/swing/JComponent;", "focusCycleRoot", "focusedComponentIndex", "", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "originalColor", "Ljava/awt/Color;", "requestFocusWhenDisplay", "addColorAdjustPanel", "colorPipetteProvider", "Lcom/intellij/ui/colorpicker/ColorPipetteProvider;", "addColorListener", "colorListener", "Lcom/intellij/ui/picker/ColorListener;", "invokeOnEveryColorChange", "addColorValuePanel", "addCustomComponent", "provider", "Lcom/intellij/ui/colorpicker/ColorPickerComponentProvider;", "addKeyAction", "keyStroke", "action", "addOperationPanel", "okOperation", "Lkotlin/Function1;", "", "cancelOperation", "addSaturationBrightnessComponent", "addSeparator", "build", "Lcom/intellij/ui/colorpicker/LightCalloutPopup;", "focusWhenDisplay", "setFocusCycleRoot", "setOriginalColor", "withFocus", "intellij.platform.ide.impl"})
public final class ColorPickerBuilder {
    private final List<JComponent> componentsToBuild;
    private final ColorPickerModel model;
    private Color originalColor;
    private boolean requestFocusWhenDisplay;
    private boolean focusCycleRoot;
    private int focusedComponentIndex;
    private final Map<KeyStroke, Action> actionMap;
    private final List<ColorListenerInfo> colorListeners;
    private final boolean showAlpha;
    private final boolean showAlphaAsPercent;

    @NotNull
    public final ColorPickerBuilder setOriginalColor(@Nullable Color originalColor) {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.originalColor = originalColor;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addSaturationBrightnessComponent() {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.componentsToBuild.add(new SaturationBrightnessComponent($this$apply.model));
        return colorPickerBuilder;
    }

    @JvmOverloads
    @NotNull
    public final ColorPickerBuilder addColorAdjustPanel(@NotNull ColorPipetteProvider colorPipetteProvider) {
        Intrinsics.checkNotNullParameter((Object)colorPipetteProvider, (String)"colorPipetteProvider");
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.componentsToBuild.add(new ColorAdjustPanel($this$apply.model, colorPipetteProvider, $this$apply.showAlpha));
        return colorPickerBuilder;
    }

    public static /* synthetic */ ColorPickerBuilder addColorAdjustPanel$default(ColorPickerBuilder colorPickerBuilder, ColorPipetteProvider colorPipetteProvider, int n, Object object) {
        if ((n & 1) != 0) {
            colorPipetteProvider = new GraphicalColorPipetteProvider();
        }
        return colorPickerBuilder.addColorAdjustPanel(colorPipetteProvider);
    }

    @JvmOverloads
    @NotNull
    public final ColorPickerBuilder addColorAdjustPanel() {
        return ColorPickerBuilder.addColorAdjustPanel$default(this, null, 1, null);
    }

    @NotNull
    public final ColorPickerBuilder addColorValuePanel() {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.componentsToBuild.add(new ColorValuePanel($this$apply.model, $this$apply.showAlpha, $this$apply.showAlphaAsPercent));
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addOperationPanel(@Nullable Function1<? super Color, Unit> okOperation, @Nullable Function1<? super Color, Unit> cancelOperation) {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.componentsToBuild.add(new OperationPanel($this$apply.model, okOperation, cancelOperation));
        if (cancelOperation != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"KeyStroke.getKeyStroke(K\u2026Event.VK_ESCAPE, 0, true)");
            $this$apply.addKeyAction(keyStroke, new AbstractAction($this$apply, okOperation, cancelOperation){
                final /* synthetic */ ColorPickerBuilder $this_apply;
                final /* synthetic */ Function1 $okOperation$inlined;
                final /* synthetic */ Function1 $cancelOperation$inlined;
                {
                    this.$this_apply = $receiver;
                    this.$okOperation$inlined = function1;
                    this.$cancelOperation$inlined = function12;
                }

                public void actionPerformed(@Nullable ActionEvent e) {
                    this.$cancelOperation$inlined.invoke((Object)ColorPickerBuilder.access$getModel$p(this.$this_apply).getColor());
                }
            });
        }
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addCustomComponent(@NotNull ColorPickerComponentProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.componentsToBuild.add(provider2.createComponent($this$apply.model));
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addSeparator() {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        JSeparator separator = new JSeparator(0);
        separator.setBorder((Border)JBUI.Borders.empty());
        separator.setPreferredSize((Dimension)JBUI.size((int)300, (int)5));
        $this$apply.componentsToBuild.add(separator);
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder focusWhenDisplay(boolean focusWhenDisplay) {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.requestFocusWhenDisplay = focusWhenDisplay;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder setFocusCycleRoot(boolean focusCycleRoot) {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.focusCycleRoot = focusCycleRoot;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder withFocus() {
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.focusedComponentIndex = $this$apply.componentsToBuild.size() - 1;
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addKeyAction(@NotNull KeyStroke keyStroke, @NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.actionMap.put(keyStroke, action2);
        return colorPickerBuilder;
    }

    @NotNull
    public final ColorPickerBuilder addColorListener(@NotNull ColorListener colorListener) {
        Intrinsics.checkNotNullParameter((Object)colorListener, (String)"colorListener");
        return this.addColorListener(colorListener, true);
    }

    @NotNull
    public final ColorPickerBuilder addColorListener(@NotNull ColorListener colorListener, boolean invokeOnEveryColorChange) {
        Intrinsics.checkNotNullParameter((Object)colorListener, (String)"colorListener");
        ColorPickerBuilder colorPickerBuilder = this;
        boolean bl = false;
        boolean bl2 = false;
        ColorPickerBuilder $this$apply = colorPickerBuilder;
        boolean bl3 = false;
        $this$apply.colorListeners.add(new ColorListenerInfo(colorListener, invokeOnEveryColorChange));
        return colorPickerBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LightCalloutPopup build() {
        void defaultFocusComponent;
        void $this$mapTo$iv$iv;
        Integer n;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.componentsToBuild.isEmpty()) {
            throw (Throwable)new IllegalStateException("The Color Picker should have at least one picking component.");
        }
        Iterable $this$map$iv = this.componentsToBuild;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JComponent jComponent = (JComponent)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            n = it.getPreferredSize().width;
            collection.add(n);
        }
        Comparable comparable = CollectionsKt.max((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)comparable);
        int width = ((Number)((Object)comparable)).intValue();
        Iterable $this$map$iv2 = this.componentsToBuild;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JComponent bl = (JComponent)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            n = it.getPreferredSize().height;
            collection.add(n);
        }
        int height = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv2));
        $this$map$iv2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)$this$map$iv2).element = (JComponent)CollectionsKt.getOrNull(this.componentsToBuild, (int)this.focusedComponentIndex);
        if ((JComponent)defaultFocusComponent.element instanceof ColorValuePanel) {
            defaultFocusComponent.element = ((ColorValuePanel)((JComponent)defaultFocusComponent.element)).getHexField();
        }
        JPanel panel2 = new JPanel(this, (Ref.ObjectRef)defaultFocusComponent){
            final /* synthetic */ ColorPickerBuilder this$0;
            final /* synthetic */ Ref.ObjectRef $defaultFocusComponent;

            public boolean requestFocusInWindow() {
                JComponent jComponent = (JComponent)this.$defaultFocusComponent.element;
                return jComponent != null ? jComponent.requestFocusInWindow() : false;
            }

            public void addNotify() {
                super.addNotify();
                if (ColorPickerBuilder.access$getRequestFocusWhenDisplay$p(this.this$0)) {
                    this.requestFocusInWindow();
                }
            }
            {
                this.this$0 = this$0;
                this.$defaultFocusComponent = $captured_local_variable$1;
            }
        };
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.setBorder((Border)ColorPickerBuilderKt.access$getPICKER_BORDER$p());
        panel2.setPreferredSize(new Dimension(width, height));
        panel2.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        Color c = this.originalColor;
        if (c != null) {
            this.model.setColor(c, null);
        }
        for (JComponent component2 : this.componentsToBuild) {
            panel2.add(component2);
        }
        panel2.setFocusCycleRoot(this.focusCycleRoot);
        panel2.setFocusTraversalPolicyProvider(true);
        panel2.setFocusTraversalPolicy(new MyFocusTraversalPolicy((JComponent)defaultFocusComponent.element));
        Object $this$forEach$iv = this.actionMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean item$iv$iv = false;
        Object it = iterator2.entrySet().iterator();
        while (it.hasNext()) {
            void keyStroke;
            Map.Entry element$iv;
            Map.Entry $dstr$keyStroke$action = element$iv = it.next();
            boolean bl = false;
            Map.Entry entry = $dstr$keyStroke$action;
            boolean bl3 = false;
            KeyStroke keyStroke2 = (KeyStroke)entry.getKey();
            entry = $dstr$keyStroke$action;
            bl3 = false;
            Action action2 = (Action)entry.getValue();
            DumbAwareAction.create((Consumer)((Consumer)new Consumer<AnActionEvent>(action2){
                final /* synthetic */ Action $action;

                public final void consume(@Nullable AnActionEvent e) {
                    AnActionEvent anActionEvent = e;
                    this.$action.actionPerformed(new ActionEvent(anActionEvent != null ? anActionEvent.getInputEvent() : null, 0, ""));
                }
                {
                    this.$action = action2;
                }
            })).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet((KeyStroke)keyStroke), (JComponent)panel2);
        }
        $this$forEach$iv = this.colorListeners;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            it = (ColorListenerInfo)element$iv;
            boolean bl = false;
            this.model.addListener(((ColorListenerInfo)it).getColorListener(), ((ColorListenerInfo)it).getInvokeOnEveryColorChange());
        }
        return new LightCalloutPopup(panel2, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ColorPickerBuilder this$0;

            public final void invoke() {
                ColorPickerBuilder.access$getModel$p(this.this$0).onClose();
            }
            {
                this.this$0 = colorPickerBuilder;
                super(0);
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ColorPickerBuilder this$0;

            public final void invoke() {
                ColorPickerBuilder.access$getModel$p(this.this$0).onCancel();
            }
            {
                this.this$0 = colorPickerBuilder;
                super(0);
            }
        }, null, 8, null);
    }

    public ColorPickerBuilder(boolean showAlpha, boolean showAlphaAsPercent) {
        this.showAlpha = showAlpha;
        this.showAlphaAsPercent = showAlphaAsPercent;
        boolean bl = false;
        this.componentsToBuild = new ArrayList();
        this.model = new ColorPickerModel(null, 1, null);
        this.focusedComponentIndex = -1;
        bl = false;
        this.actionMap = new LinkedHashMap();
        bl = false;
        this.colorListeners = new ArrayList();
    }

    public /* synthetic */ ColorPickerBuilder(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        this(bl, bl2);
    }

    public ColorPickerBuilder() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ ColorPickerModel access$getModel$p(ColorPickerBuilder $this) {
        return $this.model;
    }

    public static final /* synthetic */ boolean access$getRequestFocusWhenDisplay$p(ColorPickerBuilder $this) {
        return $this.requestFocusWhenDisplay;
    }

    public static final /* synthetic */ void access$setRequestFocusWhenDisplay$p(ColorPickerBuilder $this, boolean bl) {
        $this.requestFocusWhenDisplay = bl;
    }
}

