/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Conditions;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class TreeTableSpeedSearch
extends SpeedSearchBase<TreeTable> {
    private static final Convertor<TreePath, String> TO_STRING = object -> {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
        return node.toString();
    };
    private final Convertor<? super TreePath, String> myToStringConvertor;
    protected boolean myCanExpand;

    public TreeTableSpeedSearch(TreeTable tree, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree);
        this.myToStringConvertor = toStringConvertor;
    }

    public TreeTableSpeedSearch(TreeTable tree) {
        this(tree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING);
    }

    public void setCanExpand(boolean canExpand) {
        this.myCanExpand = canExpand;
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return !((TreeTable)this.getComponent()).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        TreePath treePath = (TreePath)element2;
        TreeTableTree tree = ((TreeTable)this.myComponent).getTree();
        if (this.myCanExpand) {
            tree.expandPath(treePath.getParentPath());
        }
        int row = tree.getRowForPath(treePath);
        TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{((TreeTable)this.myComponent).convertRowIndexToView(row)});
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return this.allPaths().indexOf(Conditions.equalTo((Object)((TreeTable)this.myComponent).getTree().getSelectionPath()));
        }
        int[] selectionRows = ((TreeTable)this.myComponent).getTree().getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    @NotNull
    protected final ListIterator<Object> getElementIterator(int startingViewIndex) {
        ListIterator<Object> listIterator = ((ArrayList)this.allPaths().addAllTo(new ArrayList())).listIterator(startingViewIndex);
        if (listIterator == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(0);
        }
        return listIterator;
    }

    @Override
    protected final int getElementCount() {
        return this.allPaths().size();
    }

    @NotNull
    protected JBIterable<TreePath> allPaths() {
        JBIterable<TreePath> jBIterable = TreeSpeedSearch.allPaths((JTree)((TreeTable)this.getComponent()).getTree(), this.myCanExpand);
        if (jBIterable == null) {
            TreeTableSpeedSearch.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Override
    protected String getElementText(Object element2) {
        TreePath path = (TreePath)element2;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TreeTableSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allPaths";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

