/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.UIManager;

public final class TextIcon
implements Icon {
    private final Insets myInsets = new Insets(0, 0, 0, 0);
    private Integer myRound;
    private Color myBackground;
    private Color myForeground;
    private Font myFont;
    private String myText;
    private Rectangle myTextBounds;
    private FontRenderContext myContext;

    private Rectangle getTextBounds() {
        if (this.myTextBounds == null && this.myFont != null && this.myText != null && !this.myText.isEmpty()) {
            Object fmHint;
            Object aaHint = UIManager.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint == null) {
                aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
            if ((fmHint = UIManager.get(RenderingHints.KEY_FRACTIONALMETRICS)) == null) {
                fmHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
            }
            this.myContext = new FontRenderContext(null, aaHint, fmHint);
            this.myTextBounds = TextIcon.getPixelBounds(this.myFont, this.myText, this.myContext);
        }
        return this.myTextBounds;
    }

    public TextIcon(String text2, Color foreground, Color background, int margin) {
        this.setInsets(margin, margin, margin, margin);
        this.setRound(margin * 4);
        this.setBackground(background);
        this.setForeground(foreground);
        this.setText(text2);
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.myInsets.set(top, left, bottom, right);
    }

    public void setInsets(Insets insets) {
        this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setRound(int round) {
        this.myRound = round;
    }

    public void setBackground(Color background) {
        this.myBackground = background;
    }

    public void setForeground(Color foreground) {
        this.myForeground = foreground;
    }

    public void setText(String text2) {
        this.myTextBounds = null;
        this.myText = text2;
    }

    public void setFont(Font font) {
        this.myFont = font;
        this.myTextBounds = null;
    }

    @Override
    public int getIconWidth() {
        Rectangle bounds2 = this.getTextBounds();
        return bounds2 == null ? 0 : this.myInsets.left + bounds2.width + this.myInsets.right;
    }

    @Override
    public int getIconHeight() {
        Rectangle bounds2 = this.getTextBounds();
        return bounds2 == null ? 0 : this.myInsets.top + bounds2.height + this.myInsets.bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.myBackground != null && g instanceof Graphics2D) {
            g.setColor(this.myBackground);
            RectanglePainter.FILL.paint((Graphics2D)g, x, y, this.getIconWidth(), this.getIconHeight(), (Object)this.myRound);
        }
        Rectangle bounds2 = this.getTextBounds();
        if (this.myForeground != null && bounds2 != null) {
            Graphics2D g2d = (Graphics2D)g.create(this.myInsets.left + x, this.myInsets.top + y, bounds2.width, bounds2.height);
            try {
                Object textLcdContrast = UIManager.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
                if (textLcdContrast == null) {
                    textLcdContrast = UIUtil.getLcdContrastValue();
                }
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.myContext.getAntiAliasingHint());
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, textLcdContrast);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.myContext.getFractionalMetricsHint());
                g2d.setColor(this.myForeground);
                g2d.setFont(this.myFont);
                g2d.drawString(this.myText, -bounds2.x, -bounds2.y);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextIcon icon2 = (TextIcon)o;
        return this.myInsets.equals(icon2.myInsets) && Objects.equals(this.myRound, icon2.myRound) && Objects.equals(this.myBackground, icon2.myBackground) && Objects.equals(this.myForeground, icon2.myForeground) && Objects.equals(this.myFont, icon2.myFont) && Objects.equals(this.myText, icon2.myText) && Objects.equals(this.myTextBounds, icon2.myTextBounds);
    }

    public int hashCode() {
        return Objects.hash(this.myInsets, this.myRound, this.myBackground, this.myForeground, this.myFont, this.myText, this.myTextBounds);
    }

    private static Rectangle getPixelBounds(Font font, String text2, FontRenderContext context) {
        return font.hasLayoutAttributes() ? new TextLayout(text2, font, context).getPixelBounds(context, 0.0f, 0.0f) : font.createGlyphVector(context, text2).getPixelBounds(context, 0.0f, 0.0f);
    }
}

