/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public abstract class TableSpeedSearchBase<Comp extends JTable>
extends SpeedSearchBase<Comp> {
    private static final Key<Cell> SELECTION_BEFORE_KEY = Key.create((String)"SpeedSearch.selectionBeforeSearch");
    private boolean myFilteringMode;

    public TableSpeedSearchBase(Comp component2) {
        super(component2);
    }

    public void setFilteringMode(boolean filteringMode) {
        this.myFilteringMode = filteringMode;
    }

    @Override
    protected void onSearchFieldUpdated(final String pattern) {
        if (!this.myFilteringMode) {
            return;
        }
        RowSorter<? extends TableModel> sorter0 = ((JTable)this.myComponent).getRowSorter();
        if (!(sorter0 instanceof TableRowSorter)) {
            return;
        }
        TableRowSorter sorter = (TableRowSorter)sorter0;
        if (StringUtil.isNotEmpty((String)pattern)) {
            if (sorter.getRowFilter() == null) {
                UIUtil.putClientProperty((JComponent)this.myComponent, SELECTION_BEFORE_KEY, (Object)new Cell(((JTable)this.myComponent).getSelectedRow(), ((JTable)this.myComponent).getSelectedColumn()));
            }
            sorter.setRowFilter(new RowFilter<TableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                    return TableSpeedSearchBase.this.isMatchingRow(entry.getIdentifier(), pattern);
                }
            });
        } else {
            UIUtil.putClientProperty((JComponent)this.myComponent, SELECTION_BEFORE_KEY, null);
            sorter.setRowFilter(null);
        }
    }

    @Override
    protected boolean isStickySearch() {
        return this.myFilteringMode;
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        if (!this.myFilteringMode) {
            return;
        }
        this.onSearchFieldUpdated("");
        Cell prev2 = (Cell)UIUtil.getClientProperty((Object)this.myComponent, SELECTION_BEFORE_KEY);
        int viewRow = ((JTable)this.myComponent).getSelectedRow();
        if (viewRow <= -1) {
            if (prev2 != null && prev2.row > -1) {
                ((JTable)this.myComponent).setRowSelectionInterval(prev2.row, prev2.row);
                ((JTable)this.myComponent).setColumnSelectionInterval(prev2.column, prev2.column);
            } else if (((JTable)this.myComponent).getRowCount() > 0) {
                ((JTable)this.myComponent).setRowSelectionInterval(0, 0);
                ((JTable)this.myComponent).setColumnSelectionInterval(0, 0);
            }
        }
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    protected boolean isMatchingRow(int modelRow, String pattern) {
        return true;
    }
}

