/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.Cell;
import com.intellij.ui.TableSpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.Convertor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TableSpeedSearch
extends TableSpeedSearchBase<JTable> {
    private static final PairFunction<Object, Cell, String> TO_STRING = (o, cell2) -> o == null || o instanceof Boolean ? "" : o.toString();
    private final PairFunction<Object, ? super Cell, String> myToStringConvertor;

    public TableSpeedSearch(JTable table) {
        this(table, TO_STRING);
    }

    public TableSpeedSearch(JTable table, Convertor<Object, String> toStringConvertor) {
        this(table, (PairFunction<Object, ? super Cell, String>)((PairFunction)(o, c) -> (String)toStringConvertor.convert(o)));
    }

    public TableSpeedSearch(JTable table, PairFunction<Object, ? super Cell, String> toStringConvertor) {
        super(table);
        this.myToStringConvertor = toStringConvertor;
        table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        new MySelectAllAction(table, this).registerCustomShortcutSet(table, null);
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        boolean tableIsNotEmpty = ((JTable)this.myComponent).getRowCount() != 0 && ((JTable)this.myComponent).getColumnCount() != 0;
        return tableIsNotEmpty && !((JTable)this.myComponent).isEditing() && super.isSpeedSearchEnabled();
    }

    @Override
    @NotNull
    protected ListIterator<Object> getElementIterator(int startingViewIndex) {
        final int count = this.getElementCount();
        ListIterator<Object> listIterator = new AbstractList<Object>(){

            @Override
            public Object get(int index2) {
                return index2;
            }

            @Override
            public int size() {
                return count;
            }
        }.listIterator(startingViewIndex);
        if (listIterator == null) {
            TableSpeedSearch.$$$reportNull$$$0(0);
        }
        return listIterator;
    }

    @Override
    protected int getElementCount() {
        return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        if (element2 instanceof Integer) {
            int index2 = (Integer)element2;
            int row = index2 / ((JTable)this.myComponent).getColumnCount();
            int col = index2 % ((JTable)this.myComponent).getColumnCount();
            ((JTable)this.myComponent).getSelectionModel().setSelectionInterval(row, row);
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().setSelectionInterval(col, col);
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
        } else {
            ((JTable)this.myComponent).getSelectionModel().clearSelection();
            ((JTable)this.myComponent).getColumnModel().getSelectionModel().clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        int row = ((JTable)this.myComponent).getSelectedRow();
        int col = ((JTable)this.myComponent).getSelectedColumn();
        return row > -1 && col > -1 ? row * ((JTable)this.myComponent).getColumnCount() + col : -1;
    }

    @Override
    protected String getElementText(Object element2) {
        int index2 = (Integer)element2;
        int row = index2 / ((JTable)this.myComponent).getColumnCount();
        int col = index2 % ((JTable)this.myComponent).getColumnCount();
        Object value2 = ((JTable)this.myComponent).getValueAt(row, col);
        return (String)this.myToStringConvertor.fun(value2, (Object)new Cell(row, col));
    }

    @NotNull
    private IntList findAllFilteredRows(String s) {
        IntArrayList rows = new IntArrayList();
        String _s = s.trim();
        block0: for (int row = 0; row < ((JTable)this.myComponent).getRowCount(); ++row) {
            for (int col = 0; col < ((JTable)this.myComponent).getColumnCount(); ++col) {
                int index2 = row * ((JTable)this.myComponent).getColumnCount() + col;
                if (!this.isMatchingElement(index2, _s)) continue;
                rows.add(row);
                continue block0;
            }
        }
        IntArrayList intArrayList = rows;
        if (intArrayList == null) {
            TableSpeedSearch.$$$reportNull$$$0(1);
        }
        return intArrayList;
    }

    @Override
    protected boolean isMatchingRow(int modelRow, String pattern) {
        int columns = ((JTable)this.myComponent).getColumnCount();
        for (int col = 0; col < columns; ++col) {
            Object value2 = ((JTable)this.myComponent).getModel().getValueAt(modelRow, col);
            String str = (String)this.myToStringConvertor.fun(value2, (Object)new Cell(modelRow, col));
            if (str == null || !this.compare(str, pattern)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TableSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredRows";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableSpeedSearch mySearch;

        MySelectAllAction(@NotNull JTable table, @NotNull TableSpeedSearch search2) {
            if (table == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.mySearch = search2;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTable.getRowSelectionAllowed() && this.myTable.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            ListSelectionModel sm = this.myTable.getSelectionModel();
            String query2 = this.mySearch.getEnteredPrefix();
            if (query2 == null) {
                return;
            }
            IntList filtered2 = this.mySearch.findAllFilteredRows(query2);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered2.toIntArray(), this.myTable.getSelectedRows());
            if (alreadySelected) {
                int anchor2 = sm.getAnchorSelectionIndex();
                sm.setSelectionInterval(anchor2, anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query2);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query2);
                if (currentElement instanceof Integer) {
                    int index2 = (Integer)currentElement;
                    anchor3 = index2 / this.myTable.getColumnCount();
                }
                if (anchor3 == -1) {
                    anchor3 = filtered2.getInt(0);
                }
                sm.clearSelection();
                for (int i2 = 0; i2 < filtered2.size(); ++i2) {
                    int value2 = filtered2.getInt(i2);
                    sm.addSelectionInterval(value2, value2);
                }
                sm.setAnchorSelectionIndex(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/TableSpeedSearch$MySelectAllAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

