/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class TableCellState {
    private boolean mySelected;
    private Color myForeground;
    private Color myBackground;
    private Font myFont;
    private Border myCellBorder;

    public void collectState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
        this.clear();
        this.mySelected = isSelected;
        this.myFont = table.getFont();
        this.myForeground = RenderingUtil.getForeground((JTable)table, (boolean)isSelected);
        this.myBackground = RenderingUtil.getBackground((JTable)table, (boolean)isSelected);
        this.myCellBorder = this.getBorder(isSelected, hasFocus);
    }

    @Nullable
    protected Border getBorder(boolean isSelected, boolean hasFocus) {
        if (hasFocus) {
            Border border;
            if (isSelected && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                return border;
            }
            return UIManager.getBorder("Table.focusCellHighlightBorder");
        }
        return UIManager.getBorder("Table.cellNoFocusBorder");
    }

    public void updateRenderer(JComponent renderer) {
        renderer.setForeground(this.myForeground);
        renderer.setBackground(this.myBackground);
        renderer.setFont(this.myFont);
        renderer.setBorder(this.myCellBorder);
    }

    protected void clear() {
        this.mySelected = false;
        this.myForeground = null;
        this.myBackground = null;
        this.myFont = null;
        this.myCellBorder = null;
    }

    public SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
        if (!this.mySelected) {
            return attributes;
        }
        return new SimpleTextAttributes(attributes.getStyle(), this.myForeground);
    }
}

