/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ProgressSlidePainter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Splash
extends Window {
    private static final float JBUI_INIT_SCALE = JBUIScale.scale((float)1.0f);
    private final int myWidth;
    private final int myHeight;
    private final int progressHeight;
    private final int progressY;
    private double progress;
    private final Color progressColor;
    private int progressLastPosition;
    private final Icon progressTail;
    @Nullable
    private final ProgressSlidePainter progressSlidePainter;
    private final Image image;

    public Splash(@NotNull ApplicationInfoEx info) {
        if (info == null) {
            Splash.$$$reportNull$$$0(0);
        }
        super((Frame)null);
        this.progressLastPosition = 0;
        this.progressSlidePainter = info.getProgressSlides().isEmpty() ? null : new ProgressSlidePainter(info);
        this.progressHeight = Splash.uiScale(info.getProgressHeight());
        this.progressY = Splash.uiScale(info.getProgressY());
        this.progressTail = Splash.getProgressTailIcon(info);
        this.setFocusableWindowState(false);
        this.image = Splash.loadImage(info.getSplashImageUrl(), info);
        this.myWidth = this.image.getWidth(null);
        this.myHeight = this.image.getHeight(null);
        long rgba = info.getProgressColor();
        this.progressColor = rgba == -1L ? null : new Color((int)rgba, rgba > 0xFFFFFFL);
        this.setAutoRequestFocus(false);
        this.setSize(new Dimension(this.myWidth, this.myHeight));
        Splash.setLocationInTheCenterOfScreen(this);
    }

    @Nullable
    private static Icon getProgressTailIcon(@NotNull ApplicationInfoEx info) {
        String progressTailIconName;
        if (info == null) {
            Splash.$$$reportNull$$$0(1);
        }
        if ((progressTailIconName = info.getProgressTailIcon()) == null) {
            return null;
        }
        try {
            String path = Objects.requireNonNull(Splash.class.getResource(progressTailIconName)).toString();
            Image image = Splash.doLoadImage(path);
            return image == null ? null : new JBImageIcon(image);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void initAndShow(boolean visible) {
        if (this.progressSlidePainter != null) {
            this.progressSlidePainter.startPreloading();
        }
        StartUpMeasurer.addInstantEvent((String)"splash shown");
        Activity activity = StartUpMeasurer.startActivity((String)"splash set visible");
        this.setVisible(visible);
        activity.end();
        if (visible) {
            this.paint(this.getGraphics());
            this.toFront();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    private static Image loadImage(@NotNull String path, @NotNull ApplicationInfoEx appInfo) {
        Image result2;
        float scale;
        if (path == null) {
            Splash.$$$reportNull$$$0(2);
        }
        if (appInfo == null) {
            Splash.$$$reportNull$$$0(3);
        }
        if (Splash.isCacheNeeded(scale = JBUIScale.sysScale())) {
            Image image = Splash.loadImageFromCache(path, scale, appInfo);
            if (image != null) {
                Image image2 = image;
                if (image2 == null) {
                    Splash.$$$reportNull$$$0(4);
                }
                return image2;
            }
            Splash.cacheAsync(path, appInfo);
        }
        if ((result2 = Splash.doLoadImage(path)) == null) {
            throw new IllegalStateException("Cannot find image: " + path);
        }
        Image image = result2;
        if (image == null) {
            Splash.$$$reportNull$$$0(5);
        }
        return image;
    }

    private static void cacheAsync(@NotNull String url, @NotNull ApplicationInfoEx appInfo) {
        if (url == null) {
            Splash.$$$reportNull$$$0(6);
        }
        if (appInfo == null) {
            Splash.$$$reportNull$$$0(7);
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            Path cacheFile = Splash.getCacheFile(url, JBUIScale.sysScale(), appInfo);
            if (cacheFile == null) {
                return;
            }
            Image image = Splash.doLoadImage(url);
            if (image != null) {
                Splash.saveImage(cacheFile, FileUtilRt.getExtension((String)url), image);
            }
        });
    }

    private static boolean isCacheNeeded(float scale) {
        return scale != 1.0f && scale != 2.0f;
    }

    @Nullable
    static Image doLoadImage(@NotNull String path) {
        if (path == null) {
            Splash.$$$reportNull$$$0(8);
        }
        return ImageLoader.loadImageForStartUp((String)path, (ClassLoader)Splash.class.getClassLoader(), (int)1, (ScaleContext)ScaleContext.create(), (!path.endsWith(".svg") ? 1 : 0) != 0);
    }

    @Override
    public void paint(Graphics g) {
        if (this.progress < 0.1 || this.progressSlidePainter == null) {
            StartupUiUtil.drawImage((Graphics)g, (Image)this.image, (int)0, (int)0, null);
        } else {
            this.paintProgress(g);
        }
    }

    private static void setLocationInTheCenterOfScreen(@NotNull Window window) {
        if (window == null) {
            Splash.$$$reportNull$$$0(9);
        }
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        Rectangle bounds2 = graphicsConfiguration.getBounds();
        if (SystemInfoRt.isWindows) {
            JBInsets.removeFrom((Rectangle)bounds2, (Insets)ScreenUtil.getScreenInsets((GraphicsConfiguration)graphicsConfiguration));
        }
        window.setLocation(StartupUiUtil.getCenterPoint((Rectangle)bounds2, (Dimension)window.getSize()));
    }

    public void showProgress(double progress2) {
        if (this.progressColor == null) {
            return;
        }
        if (progress2 - this.progress > 0.01 || progress2 > 0.99) {
            this.progress = progress2;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.paintProgress(graphics);
            }
        }
    }

    private void paintProgress(@Nullable Graphics g) {
        Color progressColor;
        if (g == null) {
            return;
        }
        if (this.progressSlidePainter != null) {
            this.progressSlidePainter.paintSlides(g, this.progress);
        }
        if ((progressColor = this.progressColor) == null) {
            return;
        }
        int progressWidth = (int)((double)this.myWidth * this.progress);
        int currentWidth = progressWidth - this.progressLastPosition;
        if (currentWidth == 0) {
            return;
        }
        g.setColor(progressColor);
        int y = this.progressSlidePainter == null ? this.progressY : this.myHeight - this.progressHeight;
        g.fillRect(this.progressLastPosition, y, currentWidth, this.progressHeight);
        if (this.progressTail != null) {
            int tx = (int)((float)currentWidth - (float)this.progressTail.getIconWidth() / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            int ty = (int)((float)this.progressY - (float)(this.progressTail.getIconHeight() - this.progressHeight) / JBUI_INIT_SCALE / 2.0f * JBUI_INIT_SCALE);
            this.progressTail.paintIcon(this, g, tx, ty);
        }
        this.progressLastPosition = progressWidth;
    }

    private static int uiScale(int i2) {
        return (int)((float)i2 * JBUI_INIT_SCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveImage(@NotNull Path file2, String extension2, @NotNull Image image) {
        if (file2 == null) {
            Splash.$$$reportNull$$$0(10);
        }
        if (image == null) {
            Splash.$$$reportNull$$$0(11);
        }
        try {
            Path tmp = file2.resolve(file2 + ".tmp" + System.currentTimeMillis());
            Files.createDirectories(tmp.getParent(), new FileAttribute[0]);
            try {
                ImageIO.write((RenderedImage)ImageUtil.toBufferedImage((Image)image), extension2, tmp.toFile());
                try {
                    Files.move(tmp, file2, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(tmp, file2, new CopyOption[0]);
                }
            }
            finally {
                Files.deleteIfExists(tmp);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    private static Image loadImageFromCache(@NotNull String path, float scale, @NotNull ApplicationInfoEx appInfo) {
        Path file2;
        if (path == null) {
            Splash.$$$reportNull$$$0(12);
        }
        if (appInfo == null) {
            Splash.$$$reportNull$$$0(13);
        }
        if ((file2 = Splash.getCacheFile(path, scale, appInfo)) == null) {
            return null;
        }
        try {
            if (!Files.isRegularFile(file2, new LinkOption[0])) {
                return null;
            }
            BufferedImage image = ImageIO.read(file2.toFile());
            if (StartupUiUtil.isJreHiDPI()) {
                int w = ((Image)image).getWidth(ImageLoader.ourComponent);
                int h = ((Image)image).getHeight(ImageLoader.ourComponent);
                image = new JBHiDPIScaledImage((Image)image, (double)w / (double)scale, (double)h / (double)scale, 2);
            }
            return image;
        }
        catch (IOException e) {
            Logger.getInstance(Splash.class).warn("Failed to load splash image", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Path getCacheFile(@NotNull String path, float scale, @NotNull ApplicationInfoEx appInfo) {
        if (path == null) {
            Splash.$$$reportNull$$$0(14);
        }
        if (appInfo == null) {
            Splash.$$$reportNull$$$0(15);
        }
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-256", Security.getProvider("SUN"));
            d.update(path.getBytes(StandardCharsets.UTF_8));
            d.update((byte)(appInfo.isEAP() ? 1 : 0));
            String encodedDigest = Base64.getUrlEncoder().encodeToString(d.digest());
            int dotIndex = path.lastIndexOf(46);
            return Paths.get(PathManager.getSystemPath(), "splashSlides", encodedDigest + "." + scale + "." + (dotIndex < 0 ? "" : path.substring(dotIndex)));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/Splash";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/Splash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProgressTailIcon";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cacheAsync";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLoadImage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLocationInTheCenterOfScreen";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveImage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadImageFromCache";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCacheFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

