/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<@Nls String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    @NlsSafe
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NotNull @NlsContexts.Label String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(1);
        }
        this();
        this.append(fragment, attributes);
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(3);
        }
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void insert(int index2, @NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(5);
        }
        this.myTexts.add(index2, fragment);
        this.myCachedToString = null;
        this.myAttributes.add(index2, attributes);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component2) {
        if (component2 == null) {
            SimpleColoredText.$$$reportNull$$$0(6);
        }
        int size = this.myTexts.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String text2 = this.myTexts.get(i2);
            SimpleTextAttributes attribute = this.myAttributes.get(i2);
            component2.append(text2, attribute);
        }
    }

    @Nls
    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = String.join((CharSequence)"", this.myTexts);
        }
        return this.myCachedToString;
    }

    public ArrayList<@Nls String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes, boolean override) {
        SimpleColoredText result2 = new SimpleColoredText();
        for (int i2 = 0; i2 < this.myTexts.size(); ++i2) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i2), attributes) : SimpleTextAttributes.merge(attributes, this.myAttributes.get(i2));
            result2.append(this.myTexts.get(i2), overridden);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/SimpleColoredText";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendToComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

