/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicensingFacade {
    public String licensedTo;
    public Supplier<List<String>> restrictions;
    public boolean isEvaluation;
    public Date expirationDate;
    public Date perpetualFallbackDate;
    public Map<String, Date> expirationDates;
    public Map<String, String> confirmationStamps;
    public String metadata;
    public static volatile LicensingFacade INSTANCE;

    @Nullable
    public static LicensingFacade getInstance() {
        return INSTANCE;
    }

    @Nullable
    public String getLicensedToMessage() {
        return this.licensedTo;
    }

    @NotNull
    public List<String> getLicenseRestrictionsMessages() {
        List<String> list2 = this.restrictions == null ? Collections.emptyList() : Collections.unmodifiableList(this.restrictions.get());
        if (list2 == null) {
            LicensingFacade.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public boolean isEvaluationLicense() {
        return this.isEvaluation;
    }

    public boolean isApplicableForProduct(@NotNull Date releaseDate) {
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(1);
        }
        return this.isPerpetualForProduct(releaseDate) || this.expirationDate == null || releaseDate.before(this.expirationDate);
    }

    public boolean isPerpetualForProduct(@NotNull Date releaseDate) {
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(2);
        }
        return this.perpetualFallbackDate != null && releaseDate.before(this.perpetualFallbackDate);
    }

    @Nullable
    public Date getLicenseExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public Date getExpirationDate(String productCode) {
        return this.expirationDates == null ? null : this.expirationDates.get(productCode);
    }

    @Nullable
    public String getConfirmationStamp(String productCode) {
        return this.confirmationStamps == null ? null : this.confirmationStamps.get(productCode);
    }

    public boolean isEA2Product(@NotNull String productCodeOrPluginId) {
        if (productCodeOrPluginId == null) {
            LicensingFacade.$$$reportNull$$$0(3);
        }
        return ArrayUtil.contains((String)productCodeOrPluginId, (String[])new String[]{"DPN", "DC", "DPA", "PDB", "PWS", "PGO", "PPS", "PPC", "PRB", "PSW", "Pythonid"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LicensingFacade";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productCodeOrPluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLicenseRestrictionsMessages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LicensingFacade";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableForProduct";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPerpetualForProduct";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEA2Product";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

