/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.GotItPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotItMessage {
    @NotNull
    private final @NlsContexts.PopupContent String myTitle;
    @NotNull
    private final @NlsContexts.PopupContent String myMessage;
    private Disposable myDisposable;
    private Runnable myCallback;
    private HyperlinkListener myHyperlinkListener;
    private boolean myShowCallout;

    private GotItMessage(@NlsContexts.PopupContent @NotNull String title, @NlsContexts.PopupContent @NotNull String message2) {
        if (title == null) {
            GotItMessage.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            GotItMessage.$$$reportNull$$$0(1);
        }
        this.myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
        this.myShowCallout = true;
        this.myTitle = title;
        this.myMessage = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"font-family: \" + UIUtil.getLabelFont().getFontName() + \"; font-size: \" +\n      JBUIScale.scale(12) + \"pt;").attr("align", "center").addRaw(StringUtil.replace((String)message2, (String)"\n", (String)"<br>"))).wrapWithHtmlBody().toString();
    }

    public static GotItMessage createMessage(@NotNull @NlsContexts.PopupContent String title, @NotNull @NlsContexts.PopupContent String message2) {
        if (title == null) {
            GotItMessage.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            GotItMessage.$$$reportNull$$$0(3);
        }
        return new GotItMessage(title, message2);
    }

    public GotItMessage setDisposable(Disposable disposable2) {
        this.myDisposable = disposable2;
        return this;
    }

    public GotItMessage setCallback(@Nullable Runnable callback2) {
        this.myCallback = callback2;
        return this;
    }

    public GotItMessage setHyperlinkListener(@Nullable HyperlinkListener hyperlinkListener) {
        this.myHyperlinkListener = hyperlinkListener;
        return this;
    }

    public GotItMessage setShowCallout(boolean showCallout) {
        this.myShowCallout = showCallout;
        return this;
    }

    public void show(@NotNull RelativePoint point, @NotNull Balloon.Position position) {
        if (point == null) {
            GotItMessage.$$$reportNull$$$0(4);
        }
        if (position == null) {
            GotItMessage.$$$reportNull$$$0(5);
        }
        this.show((PositionTracker<Balloon>)new PositionTracker.Static(point), position);
    }

    public void show(@NotNull PositionTracker<Balloon> tracker2, @NotNull Balloon.Position position) {
        if (tracker2 == null) {
            GotItMessage.$$$reportNull$$$0(6);
        }
        if (position == null) {
            GotItMessage.$$$reportNull$$$0(7);
        }
        if (this.myDisposable != null && Disposer.isDisposed((Disposable)this.myDisposable)) {
            return;
        }
        GotItPanel panel2 = new GotItPanel();
        panel2.myTitle.setText(this.myTitle);
        panel2.myMessage.setText(this.myMessage);
        if (this.myHyperlinkListener != null) {
            panel2.myMessage.addHyperlinkListener(this.myHyperlinkListener);
        }
        panel2.myButton.setCursor(Cursor.getPredefinedCursor(12));
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel2.myRoot);
        if (this.myDisposable != null) {
            builder2.setDisposable(this.myDisposable);
        }
        final Balloon balloon2 = builder2.setFillColor(UIUtil.getListBackground()).setHideOnClickOutside(false).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setShowCallout(this.myShowCallout).setBlockClicksThroughBalloon(true).createBalloon();
        panel2.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                balloon2.hide();
                if (GotItMessage.this.myCallback != null) {
                    GotItMessage.this.myCallback.run();
                }
            }
        });
        balloon2.show(tracker2, position);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/GotItMessage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMessage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

