/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ProjectTopics;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EditorNotificationsImpl
extends EditorNotifications {
    public static final ProjectExtensionPointName<EditorNotifications.Provider<?>> EP_PROJECT = new ProjectExtensionPointName("com.intellij.editorNotificationProvider");
    private static final Key<Boolean> PENDING_UPDATE = Key.create((String)"pending.notification.update");
    private final MergingUpdateQueue myUpdateMerger;
    @NotNull
    private final Project myProject;

    public EditorNotificationsImpl(@NotNull Project project) {
        if (project == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(0);
        }
        this.myUpdateMerger = new MergingUpdateQueue("EditorNotifications update merger", 100, true, null, (Disposable)project).usePassThroughInUnitTestMode();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorNotificationsImpl.this.updateNotifications(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                VirtualFile file2 = event.getNewFile();
                FileEditor editor = event.getNewEditor();
                if (file2 != null && editor != null && Boolean.TRUE.equals(editor.getUserData(PENDING_UPDATE))) {
                    editor.putUserData(PENDING_UPDATE, null);
                    EditorNotificationsImpl.this.updateEditors(file2, Collections.singletonList(editor));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void exitDumbMode() {
                EditorNotificationsImpl.this.updateAllNotifications();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/EditorNotificationsImpl$3", "rootsChanged"));
            }
        });
        EP_PROJECT.getPoint((AreaInstance)project).addExtensionPointListener(new ExtensionPointListener<EditorNotifications.Provider<?>>(){

            public void extensionAdded(@NotNull EditorNotifications.Provider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                EditorNotificationsImpl.this.updateAllNotifications();
            }

            public void extensionRemoved(@NotNull EditorNotifications.Provider extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(3);
                }
                EditorNotificationsImpl.this.updateNotifications(extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, null);
    }

    public void updateNotifications(@NotNull EditorNotifications.Provider<?> provider2) {
        if (provider2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(1);
        }
        Key key = provider2.getKey();
        for (VirtualFile file2 : FileEditorManager.getInstance((Project)this.myProject).getOpenFilesWithRemotes()) {
            List<FileEditor> editors2 = this.getEditors(file2);
            for (FileEditor editor : editors2) {
                this.updateNotification(editor, (Key<? extends JComponent>)key, null, PluginInfoDetectorKt.getPluginInfo(provider2.getClass()));
            }
        }
    }

    public void updateNotifications(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(2);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            List editors2 = ContainerUtil.filter(this.getEditors(file2), fileEditor -> {
                boolean visible = EditorActivityManager.getInstance().isVisible(fileEditor);
                if (!visible) {
                    fileEditor.putUserData(PENDING_UPDATE, (Object)Boolean.TRUE);
                }
                return visible;
            });
            if (!editors2.isEmpty()) {
                this.updateEditors(file2, editors2);
            }
        });
    }

    @NotNull
    private List<FileEditor> getEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.filter((Object[])FileEditorManager.getInstance((Project)this.myProject).getAllEditors(file2), editor -> !(editor instanceof TextEditor) || AsyncEditorLoader.isEditorLoaded(((TextEditor)editor).getEditor()));
        if (list2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private void updateEditors(@NotNull VirtualFile file2, List<FileEditor> editors2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(5);
        }
        ReadAction.nonBlocking(() -> this.calcNotificationUpdates(file2, editors2)).expireWith((Disposable)this.myProject).expireWhen(() -> !file2.isValid()).coalesceBy(new Object[]{this, file2}).finishOnUiThread(ModalityState.any(), updates2 -> {
            for (Runnable update2 : updates2) {
                update2.run();
            }
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @NotNull
    private List<Runnable> calcNotificationUpdates(@NotNull VirtualFile file2, @NotNull List<? extends FileEditor> editors2) {
        if (file2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(6);
        }
        if (editors2 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(7);
        }
        List providers = DumbService.getDumbAwareExtensions((Project)this.myProject, EP_PROJECT);
        SmartList updates2 = null;
        for (FileEditor fileEditor : editors2) {
            for (EditorNotifications.Provider provider2 : providers) {
                if (this.myProject.isDisposed()) {
                    List<Runnable> list2 = Collections.emptyList();
                    if (list2 == null) {
                        EditorNotificationsImpl.$$$reportNull$$$0(8);
                    }
                    return list2;
                }
                JComponent component2 = provider2.createNotificationPanel(file2, fileEditor, this.myProject);
                if (component2 instanceof EditorNotificationPanel) {
                    ((EditorNotificationPanel)component2).setProviderKey(provider2.getKey());
                    ((EditorNotificationPanel)component2).setProject(this.myProject);
                }
                if (updates2 == null) {
                    updates2 = new SmartList();
                }
                updates2.add(() -> this.updateNotification(editor, (Key<? extends JComponent>)provider2.getKey(), component2, PluginInfoDetectorKt.getPluginInfo(provider2.getClass())));
            }
        }
        List<Runnable> list3 = updates2 == null ? Collections.emptyList() : updates2;
        if (list3 == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(9);
        }
        return list3;
    }

    private void updateNotification(@NotNull FileEditor editor, @NotNull Key<? extends JComponent> key, @Nullable JComponent component2, PluginInfo pluginInfo) {
        JComponent old;
        if (editor == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(10);
        }
        if (key == null) {
            EditorNotificationsImpl.$$$reportNull$$$0(11);
        }
        if ((old = (JComponent)editor.getUserData(key)) != null) {
            FileEditorManager.getInstance((Project)this.myProject).removeTopComponent(editor, old);
        }
        if (component2 != null) {
            FeatureUsageData data2 = new FeatureUsageData().addData("key", key.toString()).addPluginInfo(pluginInfo);
            FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "shown", data2);
            FileEditorManager.getInstance((Project)this.myProject).addTopComponent(editor, component2);
            Key<? extends JComponent> _key = key;
            editor.putUserData(_key, (Object)component2);
        } else {
            editor.putUserData(key, null);
        }
    }

    public void logNotificationActionInvocation(@Nullable Key<?> providerKey, @Nullable Class<?> runnableClass) {
        if (providerKey == null || runnableClass == null) {
            return;
        }
        FeatureUsageData data2 = new FeatureUsageData().addData("key", providerKey.toString()).addData("class_name", runnableClass.getName()).addPluginInfo(PluginInfoDetectorKt.getPluginInfo(runnableClass));
        FUCounterUsageLogger.getInstance().logEvent(this.myProject, "editor.notification.panel", "actionInvoked", data2);
    }

    public void updateAllNotifications() {
        if (this.myProject.isDefault()) {
            throw new UnsupportedOperationException("Editor notifications aren't supported for default project");
        }
        final FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        if (fileEditorManager == null) {
            throw new IllegalStateException("No FileEditorManager for " + this.myProject);
        }
        this.myUpdateMerger.queue(new Update("update"){

            public void run() {
                for (VirtualFile file2 : fileEditorManager.getOpenFilesWithRemotes()) {
                    EditorNotificationsImpl.this.updateNotifications(file2);
                }
            }
        });
    }

    @TestOnly
    public static void completeAsyncTasks() {
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorNotificationsImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNotificationUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateEditors";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcNotificationUpdates";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefactoringListenerProvider
    implements RefactoringElementListenerProvider {
        @Nullable
        public RefactoringElementListener getListener(final @NotNull PsiElement element2) {
            if (element2 == null) {
                RefactoringListenerProvider.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        VirtualFile vFile;
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (newElement instanceof PsiFile && (vFile = newElement.getContainingFile().getVirtualFile()) != null) {
                            EditorNotifications.getInstance((Project)element2.getProject()).updateNotifications(vFile);
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        this.elementRenamedOrMoved(newElement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ui/EditorNotificationsImpl$RefactoringListenerProvider", "getListener"));
        }
    }
}

