/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.ConsentSettingsUi;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextAware;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

public final class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static List<Image> ourIcons = null;
    private static volatile boolean ourMacDocIconSet = false;
    private static final int MIN_ICON_SIZE = 32;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(AppUIUtil.class);
        if (logger == null) {
            AppUIUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static void updateWindowIcon(@NotNull Window window) {
        if (window == null) {
            AppUIUtil.$$$reportNull$$$0(1);
        }
        if (AppUIUtil.isWindowIconAlreadyExternallySet()) {
            return;
        }
        List<Image> images = ourIcons;
        if (images == null) {
            Image element2;
            Image image;
            ourIcons = images = new ArrayList<Image>(3);
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            String svgIconUrl = appInfo.getApplicationSvgIconUrl();
            String smallSvgIconUrl = appInfo.getSmallApplicationSvgIconUrl();
            ScaleContext scaleContext = ScaleContext.create((Component)window);
            if (SystemInfoRt.isUnix && (image = AppUIUtil.loadApplicationIconImage(svgIconUrl, scaleContext, 128, appInfo.getBigIconUrl())) != null) {
                images.add(image);
            }
            if ((element2 = AppUIUtil.loadApplicationIconImage(smallSvgIconUrl, scaleContext, 32, appInfo.getIconUrl())) != null) {
                images.add(element2);
            }
            if (SystemInfoRt.isWindows) {
                images.add(AppUIUtil.loadApplicationIconImage(smallSvgIconUrl, scaleContext, 16, appInfo.getSmallIconUrl()));
            }
            for (int i2 = 0; i2 < images.size(); ++i2) {
                Image image2 = images.get(i2);
                if (!(image2 instanceof JBHiDPIScaledImage)) continue;
                images.set(i2, ((JBHiDPIScaledImage)image2).getDelegate());
            }
        }
        if (!images.isEmpty()) {
            if (!SystemInfoRt.isMac) {
                window.setIconImages(images);
            } else if (!ourMacDocIconSet) {
                AppIcon.MacAppIcon.setDockIcon(ImageUtil.toBufferedImage((Image)images.get(0)));
                ourMacDocIconSet = true;
            }
        }
    }

    public static boolean isWindowIconAlreadyExternallySet() {
        if (SystemInfoRt.isMac) {
            return ourMacDocIconSet || !PlatformUtils.isCodeWithMeGuest() && !PluginManagerCore.isRunningFromSources();
        }
        return SystemInfoRt.isWindows && Boolean.getBoolean("ide.native.launcher") && SystemInfo.isJetBrainsJvm;
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext scaleContext) {
        if (scaleContext == null) {
            AppUIUtil.$$$reportNull$$$0(2);
        }
        return AppUIUtil.loadSmallApplicationIcon(scaleContext, 16);
    }

    @NotNull
    public static Icon loadSmallApplicationIcon(@NotNull ScaleContext scaleContext, int size) {
        if (scaleContext == null) {
            AppUIUtil.$$$reportNull$$$0(3);
        }
        return AppUIUtil.loadSmallApplicationIcon(scaleContext, size, !ApplicationInfoImpl.getShadowInstance().isEAP());
    }

    @NotNull
    public static Icon loadSmallApplicationIconForRelease(@NotNull ScaleContext scaleContext, int size) {
        if (scaleContext == null) {
            AppUIUtil.$$$reportNull$$$0(4);
        }
        return AppUIUtil.loadSmallApplicationIcon(scaleContext, size, true);
    }

    @NotNull
    private static Icon loadSmallApplicationIcon(@NotNull ScaleContext scaleContext, int size, boolean isReleaseIcon) {
        Icon icon2;
        if (scaleContext == null) {
            AppUIUtil.$$$reportNull$$$0(5);
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String smallIconUrl = appInfo.getSmallApplicationSvgIconUrl();
        if (isReleaseIcon && appInfo.isEAP() && appInfo instanceof ApplicationInfoImpl) {
            smallIconUrl = ((ApplicationInfoImpl)appInfo).getSmallApplicationSvgIconUrl(false);
        }
        Icon icon3 = icon2 = smallIconUrl == null ? null : AppUIUtil.loadApplicationIcon(smallIconUrl, scaleContext, size);
        if (icon2 != null) {
            Icon icon4 = icon2;
            if (icon4 == null) {
                AppUIUtil.$$$reportNull$$$0(6);
            }
            return icon4;
        }
        String fallbackSmallIconUrl = appInfo.getSmallIconUrl();
        Image image = ImageLoader.loadFromResource((String)fallbackSmallIconUrl, AppUIUtil.class);
        assert (image != null) : "Can't load '" + fallbackSmallIconUrl + "'";
        icon2 = new JBImageIcon(image);
        return AppUIUtil.scaleIconToSize(icon2, size);
    }

    @Nullable
    public static Icon loadApplicationIcon(@NotNull ScaleContext ctx, int size) {
        String url;
        if (ctx == null) {
            AppUIUtil.$$$reportNull$$$0(7);
        }
        return (url = ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl()) == null ? null : AppUIUtil.loadApplicationIcon(url, ctx, size);
    }

    @Contract(value="_, _, _, !null -> !null")
    @Nullable
    private static Image loadApplicationIconImage(@Nullable String svgPath, ScaleContext scaleContext, int size, @Nullable String fallbackPath) {
        Icon icon2;
        Icon icon3 = icon2 = svgPath == null ? null : AppUIUtil.loadApplicationIcon(svgPath, scaleContext, size);
        if (icon2 != null) {
            return IconLoader.toImage((Icon)icon2, (ScaleContext)scaleContext);
        }
        if (fallbackPath != null) {
            return ImageLoader.loadFromResource((String)fallbackPath, AppUIUtil.class);
        }
        return null;
    }

    @Nullable
    private static Icon loadApplicationIcon(@NotNull String svgPath, ScaleContext scaleContext, int size) {
        Icon icon2;
        if (svgPath == null) {
            AppUIUtil.$$$reportNull$$$0(8);
        }
        if ((icon2 = IconLoader.findIcon((String)svgPath, (ClassLoader)AppUIUtil.class.getClassLoader())) == null) {
            AppUIUtil.getLogger().info("Cannot load SVG application icon from " + svgPath);
            return null;
        }
        if (icon2 instanceof ScaleContextAware) {
            ((ScaleContextAware)icon2).updateScaleContext((UserScaleContext)scaleContext);
        }
        return AppUIUtil.scaleIconToSize(icon2, size);
    }

    @NotNull
    private static Icon scaleIconToSize(Icon icon2, int size) {
        int width = icon2.getIconWidth();
        if (width == size) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                AppUIUtil.$$$reportNull$$$0(9);
            }
            return icon3;
        }
        float scale = (float)size / (float)width;
        Icon icon4 = icon2 = IconUtil.scale(icon2, null, scale);
        if (icon4 == null) {
            AppUIUtil.$$$reportNull$$$0(10);
        }
        return icon4;
    }

    public static void invokeLaterIfProjectAlive(@NotNull Project project, @NotNull Runnable runnable2) {
        Application application;
        if (project == null) {
            AppUIUtil.$$$reportNull$$$0(11);
        }
        if (runnable2 == null) {
            AppUIUtil.$$$reportNull$$$0(12);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            if (project.isOpen() && !project.isDisposed()) {
                runnable2.run();
            }
        } else {
            application.invokeLater(runnable2, __ -> !project.isOpen() || project.isDisposed());
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    @Deprecated
    public static void invokeOnEdt(@NotNull Runnable runnable2, @Nullable Condition<?> expired) {
        Application application;
        if (runnable2 == null) {
            AppUIUtil.$$$reportNull$$$0(13);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass(@NotNull Toolkit toolkit) {
        if (toolkit == null) {
            AppUIUtil.$$$reportNull$$$0(14);
        }
        if (SystemInfoRt.isWindows || SystemInfoRt.isMac) {
            return;
        }
        try {
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFrameClass() {
        Object wmClass;
        String name = Strings.toLowerCase((String)ApplicationNamesInfo.getInstance().getFullProductNameWithEdition()).replace(' ', '-').replace("intellij-idea", "idea").replace("android-studio", "studio").replace("-community-edition", "-ce").replace("-ultimate-edition", "").replace("-professional-edition", "");
        Object object = wmClass = name.startsWith(VENDOR_PREFIX) ? name : VENDOR_PREFIX + name;
        if (PluginManagerCore.isRunningFromSources()) {
            wmClass = (String)wmClass + "-debug";
        }
        return wmClass;
    }

    @Nullable
    public static String findIcon() {
        URL url;
        String[] childFiles;
        String iconsPath = PathManager.getBinPath();
        for (String child2 : childFiles = (String[])ObjectUtils.notNull((Object)new File(iconsPath).list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)) {
            if (!child2.endsWith(".svg")) continue;
            return iconsPath + "/" + child2;
        }
        String svgIconUrl = ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl();
        if (svgIconUrl != null && (url = ApplicationInfoEx.class.getResource(svgIconUrl)) != null && "file".equals(url.getProtocol())) {
            return URLUtil.urlToFile((URL)url).getAbsolutePath();
        }
        int best = 31;
        String iconPath = null;
        for (String child3 : childFiles) {
            String path;
            ImageIcon icon2;
            int size;
            if (!child3.endsWith(".png") || (size = (icon2 = new ImageIcon(path = iconsPath + "/" + child3)).getIconHeight()) <= best || size != icon2.getIconWidth()) continue;
            best = size;
            iconPath = path;
        }
        return iconPath;
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Logger log) {
        if (log == null) {
            AppUIUtil.$$$reportNull$$$0(15);
        }
        return AppUIUtil.showConsentsAgreementIfNeeded((Runnable command) -> {
            if (EventQueue.isDispatchThread()) {
                command.run();
            } else {
                try {
                    EventQueue.invokeAndWait(command);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    log.warn((Throwable)e);
                }
            }
        });
    }

    public static boolean needToShowConsentsAgreement() {
        return (Boolean)ConsentOptions.getInstance().getConsents().second;
    }

    public static boolean showConsentsAgreementIfNeeded(@NotNull Executor edtExecutor2) {
        if (edtExecutor2 == null) {
            AppUIUtil.$$$reportNull$$$0(16);
        }
        Pair<List<Consent>, Boolean> consentsToShow = ConsentOptions.getInstance().getConsents();
        Ref result2 = new Ref((Object)Boolean.FALSE);
        if (((Boolean)consentsToShow.second).booleanValue()) {
            edtExecutor2.execute(() -> result2.set((Object)AppUIUtil.confirmConsentOptions((List)consentsToShow.first)));
        }
        return (Boolean)result2.get();
    }

    public static void updateForDarcula(boolean isDarcula) {
        JBColor.setDark((boolean)isDarcula);
        IconLoader.setUseDarkIcons((boolean)isDarcula);
    }

    public static boolean confirmConsentOptions(final @NotNull List<Consent> consents) {
        List<Consent> result2;
        if (consents == null) {
            AppUIUtil.$$$reportNull$$$0(17);
        }
        if (consents.isEmpty()) {
            return false;
        }
        final ConsentSettingsUi ui = new ConsentSettingsUi(false);
        DialogWrapper dialog2 = new DialogWrapper(true){

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            @Nullable
            protected JComponent createSouthPanel() {
                JComponent southPanel = super.createSouthPanel();
                if (southPanel != null) {
                    southPanel.setBorder(1.createDefaultBorder());
                }
                return southPanel;
            }

            protected JComponent createCenterPanel() {
                return ui.getComponent();
            }

            protected Action @NotNull [] createActions() {
                if (consents.size() > 1) {
                    Action[] actions = super.createActions();
                    this.setOKButtonText(IdeBundle.message((String)"button.save", (Object[])new Object[0]));
                    this.setCancelButtonText(IdeBundle.message((String)"button.skip", (Object[])new Object[0]));
                    if (actions == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actions;
                }
                this.setOKButtonText(((Consent)consents.iterator().next()).getName());
                Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"button.don.t.send", (Object[])new Object[0])){

                    protected void doAction(ActionEvent e) {
                        this.close(2);
                    }
                }};
                if (actionArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return actionArray;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setAutoAdjustable(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppUIUtil$1", "createActions"));
            }
        };
        ui.reset(consents);
        dialog2.setModal(true);
        dialog2.setTitle(IdeBundle.message((String)"dialog.title.data.sharing", (Object[])new Object[0]));
        dialog2.pack();
        if (consents.size() < 2) {
            dialog2.setSize(dialog2.getWindow().getWidth(), dialog2.getWindow().getHeight() + JBUIScale.scale((int)75));
        }
        dialog2.show();
        int exitCode = dialog2.getExitCode();
        if (exitCode == 1) {
            return false;
        }
        if (consents.size() == 1) {
            result2 = Collections.singletonList(consents.iterator().next().derive(exitCode == 0));
        } else {
            result2 = new ArrayList<Consent>();
            ui.apply(result2);
        }
        AppUIUtil.saveConsents(result2);
        return true;
    }

    public static List<Consent> loadConsentsForEditing() {
        Consent statConsent;
        ConsentOptions options2 = ConsentOptions.getInstance();
        ArrayList<Consent> result2 = (ArrayList<Consent>)options2.getConsents().first;
        if (options2.isEAP() && (statConsent = options2.getUsageStatsConsent()) != null) {
            ArrayList<Consent> consents = result2;
            result2 = new ArrayList<Consent>();
            result2.add(statConsent.derive(UsageStatisticsPersistenceComponent.getInstance().isAllowed()));
            result2.addAll(consents);
        }
        return result2;
    }

    public static void saveConsents(List<Consent> consents) {
        Consent defaultStatsConsent;
        ConsentOptions options2 = ConsentOptions.getInstance();
        Application app = ApplicationManager.getApplication();
        List<Consent> toSave = consents;
        if (app != null && options2.isEAP() && (defaultStatsConsent = options2.getUsageStatsConsent()) != null) {
            toSave = new ArrayList<Consent>();
            for (Consent consent : consents) {
                if (defaultStatsConsent.getId().equals(consent.getId())) {
                    UsageStatisticsPersistenceComponent.getInstance().setAllowed(consent.isAccepted());
                    continue;
                }
                toSave.add(consent);
            }
        }
        if (!toSave.isEmpty()) {
            options2.setConsents(toSave);
        }
    }

    public static void targetToDevice(@NotNull Component comp, @Nullable Component target2) {
        if (comp == null) {
            AppUIUtil.$$$reportNull$$$0(18);
        }
        if (comp.isShowing()) {
            return;
        }
        GraphicsConfiguration gc = target2 != null ? target2.getGraphicsConfiguration() : null;
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration(comp, gc);
    }

    public static boolean isInFullscreen(@Nullable Window window) {
        return window instanceof IdeFrame && ((IdeFrame)window).isInFullScreen();
    }

    public static Object adjustFractionalMetrics(Object defaultValue) {
        if (!SystemInfoRt.isMac || GraphicsEnvironment.isHeadless()) {
            return defaultValue;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return JBUIScale.sysScale((GraphicsConfiguration)gc) == 1.0f ? RenderingHints.VALUE_FRACTIONALMETRICS_OFF : defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AppUIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svgPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtExecutor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AppUIUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSmallApplicationIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleIconToSize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateWindowIcon";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadSmallApplicationIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadSmallApplicationIconForRelease";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadApplicationIcon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfProjectAlive";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnEdt";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateFrameClass";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showConsentsAgreementIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "confirmConsentOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "targetToDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

