/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.util.messages.MessageBusConnection;
import com.jediterm.terminal.emulator.ColorPalette;
import java.awt.Color;
import java.awt.Font;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TerminalUiSettingsManager
implements Disposable {
    private final MyColorsSchemeDelegate myColorsScheme;
    private JBTerminalSchemeColorPalette myColorPalette;
    private final List<JBTerminalPanel> myTerminalPanels = new CopyOnWriteArrayList<JBTerminalPanel>();

    TerminalUiSettingsManager() {
        this.myColorsScheme = new MyColorsSchemeDelegate();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            int newSize;
            int oldSize = this.myColorsScheme.getConsoleFontSize();
            if (oldSize != (newSize = this.myColorsScheme.detectConsoleFontSize())) {
                this.setConsoleFontSize(newSize);
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(@Nullable EditorColorsScheme scheme2) {
                TerminalUiSettingsManager.this.myColorsScheme.updateGlobalScheme(scheme2);
                TerminalUiSettingsManager.this.myColorPalette = null;
                TerminalUiSettingsManager.this.setConsoleFontSize(TerminalUiSettingsManager.this.myColorsScheme.detectConsoleFontSize());
            }
        });
    }

    void setConsoleFontSize(int fontSize) {
        this.myColorsScheme.setConsoleFontSize(fontSize);
        this.fireFontChanged();
    }

    @NotNull
    static TerminalUiSettingsManager getInstance() {
        TerminalUiSettingsManager terminalUiSettingsManager = (TerminalUiSettingsManager)ServiceManager.getService(TerminalUiSettingsManager.class);
        if (terminalUiSettingsManager == null) {
            TerminalUiSettingsManager.$$$reportNull$$$0(0);
        }
        return terminalUiSettingsManager;
    }

    void addListener(@NotNull JBTerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            TerminalUiSettingsManager.$$$reportNull$$$0(1);
        }
        this.myTerminalPanels.add(terminalPanel);
        Disposer.register((Disposable)terminalPanel, () -> this.myTerminalPanels.remove(terminalPanel));
    }

    private void fireFontChanged() {
        for (JBTerminalPanel panel2 : this.myTerminalPanels) {
            panel2.fontChanged();
        }
    }

    @NotNull
    EditorColorsScheme getEditorColorsScheme() {
        MyColorsSchemeDelegate myColorsSchemeDelegate = this.myColorsScheme;
        if (myColorsSchemeDelegate == null) {
            TerminalUiSettingsManager.$$$reportNull$$$0(2);
        }
        return myColorsSchemeDelegate;
    }

    @NotNull
    ColorPalette getTerminalColorPalette() {
        JBTerminalSchemeColorPalette colorPalette = this.myColorPalette;
        if (colorPalette == null) {
            this.myColorPalette = colorPalette = new JBTerminalSchemeColorPalette(this.myColorsScheme);
        }
        JBTerminalSchemeColorPalette jBTerminalSchemeColorPalette = colorPalette;
        if (jBTerminalSchemeColorPalette == null) {
            TerminalUiSettingsManager.$$$reportNull$$$0(3);
        }
        return jBTerminalSchemeColorPalette;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalUiSettingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalUiSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorColorsScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalColorPalette";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyColorsSchemeDelegate
    implements EditorColorsScheme {
        private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;
        private int myConsoleFontSize;

        private MyColorsSchemeDelegate() {
            this.updateGlobalScheme(null);
            this.myConsoleFontSize = this.detectConsoleFontSize();
            this.initFonts();
        }

        @NotNull
        private EditorColorsScheme getGlobal() {
            EditorColorsScheme editorColorsScheme = this.myGlobalScheme;
            if (editorColorsScheme == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(0);
            }
            return editorColorsScheme;
        }

        @NotNull
        public String getName() {
            String string = this.getGlobal().getName();
            if (string == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(1);
            }
            return string;
        }

        private void initFonts() {
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(consoleFontName, consoleFontSize);
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(consoleFontName, 0, consoleFontSize);
            Font boldFont = new Font(consoleFontName, 1, consoleFontSize);
            Font italicFont = new Font(consoleFontName, 2, consoleFontSize);
            Font boldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        public void setName(String name) {
            this.getGlobal().setName(name);
        }

        @NotNull
        public String getDisplayName() {
            String string = this.getGlobal().getDisplayName();
            if (string == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(2);
            }
            return string;
        }

        public TextAttributes getAttributes(TextAttributesKey key) {
            if (this.myOwnAttributes.containsKey(key)) {
                return this.myOwnAttributes.get(key);
            }
            return this.getGlobal().getAttributes(key);
        }

        public void setAttributes(@NotNull TextAttributesKey key, TextAttributes attributes) {
            if (key == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(3);
            }
            this.myOwnAttributes.put(key, attributes);
        }

        @NotNull
        public Color getDefaultBackground() {
            Color color = this.getGlobal().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
            Color color2 = color != null ? color : this.getGlobal().getDefaultBackground();
            if (color2 == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(4);
            }
            return color2;
        }

        @NotNull
        public Color getDefaultForeground() {
            Color foregroundColor = this.getGlobal().getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
            Color color = foregroundColor != null ? foregroundColor : this.getGlobal().getDefaultForeground();
            if (color == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(5);
            }
            return color;
        }

        public Color getColor(ColorKey key) {
            if (this.myOwnColors.containsKey(key)) {
                return this.myOwnColors.get(key);
            }
            return this.getGlobal().getColor(key);
        }

        public void setColor(ColorKey key, Color color) {
            this.myOwnColors.put(key, color);
        }

        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = this.myGlobalScheme.getFontPreferences();
            if (fontPreferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(6);
            }
            return fontPreferences;
        }

        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(7);
            }
            throw new IllegalStateException();
        }

        public int getEditorFontSize() {
            return this.getGlobal().getEditorFontSize();
        }

        public void setEditorFontSize(int fontSize) {
        }

        public String getEditorFontName() {
            return this.getGlobal().getEditorFontName();
        }

        public void setEditorFontName(String fontName) {
            throw new IllegalStateException();
        }

        @NotNull
        public Font getFont(EditorFontType key) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key)) != null) {
                Font font2 = font;
                if (font2 == null) {
                    MyColorsSchemeDelegate.$$$reportNull$$$0(8);
                }
                return font2;
            }
            Font font3 = this.getGlobal().getFont(key);
            if (font3 == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(9);
            }
            return font3;
        }

        public void setFont(EditorFontType key, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key, font);
        }

        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void readExternal(Element element2) {
        }

        private void updateGlobalScheme(@Nullable EditorColorsScheme scheme2) {
            this.myFontsMap = null;
            this.myGlobalScheme = scheme2 != null ? scheme2 : EditorColorsManager.getInstance().getGlobalScheme();
        }

        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
            if (fontPreferencesImpl == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(10);
            }
            return fontPreferencesImpl;
        }

        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(11);
            }
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.initFonts();
        }

        public String getConsoleFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getConsoleFontName();
            }
            return this.myFaceName;
        }

        public void setConsoleFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        private int detectConsoleFontSize() {
            if (UISettings.getInstance().getPresentationMode()) {
                return UISettings.getInstance().getPresentationModeFontSize();
            }
            return this.getGlobal().getConsoleFontSize();
        }

        public int getConsoleFontSize() {
            return this.myConsoleFontSize;
        }

        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.initFonts();
        }

        public float getConsoleLineSpacing() {
            return this.getGlobal().getConsoleLineSpacing();
        }

        public void setConsoleLineSpacing(float lineSpacing) {
            this.getGlobal().setConsoleLineSpacing(lineSpacing);
        }

        @NotNull
        public Properties getMetaProperties() {
            Properties properties = this.myGlobalScheme.getMetaProperties();
            if (properties == null) {
                MyColorsSchemeDelegate.$$$reportNull$$$0(12);
            }
            return properties;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/terminal/TerminalUiSettingsManager$MyColorsSchemeDelegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGlobal";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/terminal/TerminalUiSettingsManager$MyColorsSchemeDelegate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultBackground";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultForeground";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFontPreferences";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFont";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsoleFontPreferences";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setAttributes";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setFontPreferences";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setConsoleFontPreferences";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

