/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.PtyBasedProcess;
import com.intellij.util.ObjectUtils;
import com.jediterm.terminal.Questioner;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandlerTtyConnector
implements TtyConnector {
    private static final Logger LOG = Logger.getInstance(ProcessHandlerTtyConnector.class);
    private final ProcessHandler myProcessHandler;
    private final Process myPtyProcess;
    private final Charset myCharset;

    public ProcessHandlerTtyConnector(@NotNull ProcessHandler processHandler2, @NotNull Charset charset) {
        if (processHandler2 == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(0);
        }
        if (charset == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(1);
        }
        this.myProcessHandler = processHandler2;
        this.myPtyProcess = ProcessHandlerTtyConnector.getPtyProcess(processHandler2);
        this.myCharset = charset;
    }

    @Nullable
    private static Process getPtyProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(2);
        }
        if (!(processHandler2 instanceof BaseProcessHandler)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ProcessHandler doesn't support terminal window resizing: " + processHandler2.getClass());
            }
            return null;
        }
        Process process2 = ((BaseProcessHandler)processHandler2).getProcess();
        if (!(process2 instanceof PtyProcess) && !(process2 instanceof PtyBasedProcess) && LOG.isDebugEnabled()) {
            LOG.debug("Process doesn't support terminal window resizing: " + process2.getClass());
        }
        return process2;
    }

    public boolean init(Questioner q) {
        return true;
    }

    public void close() {
        this.myProcessHandler.destroyProcess();
    }

    public void resize(@NotNull Dimension termSize) {
        if (termSize == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(3);
        }
        if (this.myPtyProcess instanceof PtyProcess) {
            PtyProcess ptyProcess = (PtyProcess)this.myPtyProcess;
            if (ptyProcess.isRunning()) {
                ptyProcess.setWinSize(new WinSize(termSize.width, termSize.height));
            }
        } else if (this.myPtyProcess instanceof PtyBasedProcess) {
            ((PtyBasedProcess)((Object)this.myPtyProcess)).setWindowSize(termSize.width, termSize.height);
        }
    }

    public String getName() {
        return "TtyConnector:" + this.myProcessHandler.toString();
    }

    public int read(char[] buf, int offset, int length) throws IOException {
        throw new IllegalStateException("all reads should be performed by ProcessHandler");
    }

    public void write(byte[] bytes) throws IOException {
        this.writeBytes(bytes);
    }

    public boolean isConnected() {
        return false;
    }

    public void write(String string) throws IOException {
        this.writeBytes(string.getBytes(this.myCharset));
    }

    public int waitFor() throws InterruptedException {
        return this.myPtyProcess.waitFor();
    }

    private void writeBytes(byte[] bytes) throws IOException {
        OutputStream input = this.myProcessHandler.getProcessInput();
        if (input != null) {
            input.write(bytes);
            input.flush();
        }
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 == null) {
            ProcessHandlerTtyConnector.$$$reportNull$$$0(4);
        }
        return processHandler2;
    }

    @Nullable
    public PtyProcess getPtyProcess() {
        return (PtyProcess)ObjectUtils.tryCast((Object)this.myPtyProcess, PtyProcess.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "termSize";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/ProcessHandlerTtyConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/ProcessHandlerTtyConnector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPtyProcess";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resize";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

