/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.context.ContextInfo;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
public final class WorkingContextManager {
    private static final Logger LOG = Logger.getInstance(WorkingContextManager.class);
    @NonNls
    private static final String TASKS_FOLDER = "tasks";
    private final Project myProject;
    @NonNls
    private static final String TASKS_ZIP_POSTFIX = ".tasks.zip";
    @NonNls
    private static final String TASK_XML_POSTFIX = ".task.xml";
    private static final String CONTEXT_ZIP_POSTFIX = ".contexts.zip";
    private static final Comparator<JBZipEntry> ENTRY_COMPARATOR = (o1, o2) -> Long.signum(o2.getTime() - o1.getTime());
    private boolean ENABLED;

    public static WorkingContextManager getInstance(@NotNull Project project) {
        if (project == null) {
            WorkingContextManager.$$$reportNull$$$0(0);
        }
        return (WorkingContextManager)project.getService(WorkingContextManager.class);
    }

    public WorkingContextManager(@NotNull Project project) {
        if (project == null) {
            WorkingContextManager.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.ENABLED = !ApplicationManager.getApplication().isUnitTestMode();
    }

    @TestOnly
    public void enableUntil(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            WorkingContextManager.$$$reportNull$$$0(2);
        }
        this.ENABLED = true;
        Disposer.register((Disposable)disposable2, () -> {
            this.ENABLED = false;
        });
    }

    public void loadContext(@NotNull Element fromElement) {
        if (fromElement == null) {
            WorkingContextManager.$$$reportNull$$$0(3);
        }
        for (WorkingContextProvider provider2 : WorkingContextProvider.EP_NAME.getExtensionList()) {
            try {
                Element child2 = fromElement.getChild(provider2.getId());
                if (child2 == null) continue;
                provider2.loadContext(this.myProject, child2);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void saveContext(Element toElement) {
        for (WorkingContextProvider provider2 : WorkingContextProvider.EP_NAME.getExtensionList()) {
            try {
                Element child2 = new Element(provider2.getId());
                provider2.saveContext(this.myProject, child2);
                toElement.addContent(child2);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void clearContext() {
        for (WorkingContextProvider provider2 : WorkingContextProvider.EP_NAME.getExtensionList()) {
            provider2.clearContext(this.myProject);
        }
    }

    public void saveContext(Task task2) {
        String entryName = task2.getId() + TASK_XML_POSTFIX;
        this.saveContext(entryName, TASKS_ZIP_POSTFIX, task2.getSummary());
    }

    public void saveContext(@Nullable String entryName, @Nullable String comment) {
        this.saveContext(entryName, CONTEXT_ZIP_POSTFIX, comment);
    }

    public boolean hasContext(String entryName) {
        return this.doEntryAction(CONTEXT_ZIP_POSTFIX, entryName, (ThrowableConsumer<JBZipEntry, Exception>)((ThrowableConsumer)entry -> {}));
    }

    private synchronized void saveContext(@Nullable String entryName, String zipPostfix, @Nullable String comment) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            if (entryName == null) {
                int i2 = archive.getEntries().size();
                while (archive.getEntry("/" + (String)(entryName = "context" + i2++)) != null) {
                }
            }
            JBZipEntry entry = archive.getOrCreateEntry("/" + (String)entryName);
            if (comment != null) {
                entry.setComment(StringUtil.first((String)comment, (int)200, (boolean)true));
            }
            Element element2 = new Element("context");
            this.saveContext(element2);
            String s = new XMLOutputter().outputString(element2);
            entry.setData(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private JBZipFile getTasksArchive(String postfix) {
        File file2 = this.getArchiveFile(postfix);
        try {
            return new JBZipFile(file2);
        }
        catch (IOException e) {
            file2.delete();
            JBZipFile zipFile = null;
            try {
                zipFile = new JBZipFile(file2);
                Notifications.Bus.notify((Notification)new Notification("Tasks", TaskBundle.message("notification.title.context.data.corrupted", new Object[0]), TaskBundle.message("notification.content.context.information.history", this.myProject.getName()), NotificationType.ERROR), (Project)this.myProject);
            }
            catch (IOException e1) {
                LOG.error("Can't repair form context data corruption", (Throwable)e1);
            }
            return zipFile;
        }
    }

    private File getArchiveFile(String postfix) {
        File tasksFolder = PathManager.getConfigDir().resolve(TASKS_FOLDER).toFile();
        if (!tasksFolder.exists()) {
            tasksFolder.mkdirs();
        }
        String projectName = FileUtil.sanitizeFileName((String)this.myProject.getName());
        return new File(tasksFolder, projectName + postfix);
    }

    public void restoreContext(@NotNull Task task2) {
        if (task2 == null) {
            WorkingContextManager.$$$reportNull$$$0(4);
        }
        this.loadContext(TASKS_ZIP_POSTFIX, task2.getId() + TASK_XML_POSTFIX);
    }

    private boolean loadContext(String zipPostfix, String entryName) {
        return this.doEntryAction(zipPostfix, entryName, (ThrowableConsumer<JBZipEntry, Exception>)((ThrowableConsumer)entry -> {
            String s = new String(entry.getData(), StandardCharsets.UTF_8);
            this.loadContext(JDOMUtil.load((CharSequence)s));
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean doEntryAction(String zipPostfix, String entryName, ThrowableConsumer<JBZipEntry, Exception> action2) {
        if (!this.ENABLED) {
            return false;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            JBZipEntry entry = archive.getEntry((String)(StringUtil.startsWithChar((CharSequence)entryName, (char)'/') ? entryName : "/" + entryName));
            if (entry == null) return false;
            action2.consume((Object)entry);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public List<ContextInfo> getContextHistory() {
        return this.getContextHistory(CONTEXT_ZIP_POSTFIX);
    }

    private synchronized List<ContextInfo> getContextHistory(String zipPostfix) {
        List list2;
        block9: {
            if (!this.ENABLED) {
                return Collections.emptyList();
            }
            JBZipFile archive = this.getTasksArchive(zipPostfix);
            try {
                List entries2 = archive.getEntries();
                list2 = ContainerUtil.mapNotNull((Collection)entries2, entry -> entry.getName().startsWith("/context") ? new ContextInfo(entry.getName(), entry.getTime(), entry.getComment()) : null);
                if (archive == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return Collections.emptyList();
                }
            }
            archive.close();
        }
        return list2;
    }

    public boolean loadContext(String name) {
        return this.loadContext(CONTEXT_ZIP_POSTFIX, name);
    }

    public void removeContext(String name) {
        this.removeContext(name, CONTEXT_ZIP_POSTFIX);
    }

    public void removeContext(Task task2) {
        this.removeContext(task2.getId(), TASKS_ZIP_POSTFIX);
    }

    private void removeContext(String name, String postfix) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(postfix);){
            JBZipEntry entry = archive.getEntry(name);
            if (entry != null) {
                archive.eraseEntry(entry);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void pack(int max, int delta) {
        this.pack(max, delta, CONTEXT_ZIP_POSTFIX);
        this.pack(max, delta, TASKS_ZIP_POSTFIX);
    }

    private synchronized void pack(int max, int delta, String zipPostfix) {
        if (!this.ENABLED) {
            return;
        }
        try (JBZipFile archive = this.getTasksArchive(zipPostfix);){
            List entries2 = archive.getEntries();
            if (entries2.size() > max + delta) {
                JBZipEntry[] array2 = entries2.toArray(new JBZipEntry[0]);
                Arrays.sort(array2, ENTRY_COMPARATOR);
                for (int i2 = array2.length - 1; i2 >= max; --i2) {
                    archive.eraseEntry(array2[i2]);
                }
                archive.gc();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @TestOnly
    public File getContextFile() {
        return this.getArchiveFile(CONTEXT_ZIP_POSTFIX);
    }

    @TestOnly
    public File getTaskFile() {
        return this.getArchiveFile(TASKS_ZIP_POSTFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tasks/context/WorkingContextManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "enableUntil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

