/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceNode
extends AbstractTreeNode<SliceUsage>
implements DuplicateNodeRenderer.DuplicatableNode<SliceNode>,
MyColoredTreeCellRenderer {
    protected List<SliceNode> myCachedChildren;
    boolean dupNodeCalculated;
    protected SliceNode duplicate;
    public final DuplicateMap targetEqualUsages;
    protected boolean changed;
    private int index;

    protected SliceNode(@NotNull Project project, @NotNull SliceUsage sliceUsage, @NotNull DuplicateMap targetEqualUsages) {
        if (project == null) {
            SliceNode.$$$reportNull$$$0(0);
        }
        if (sliceUsage == null) {
            SliceNode.$$$reportNull$$$0(1);
        }
        if (targetEqualUsages == null) {
            SliceNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)sliceUsage);
        this.targetEqualUsages = targetEqualUsages;
    }

    @NotNull
    public SliceNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceNode newNode = new SliceNode(this.getProject(), newUsage, this.targetEqualUsages);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        SliceNode sliceNode = newNode;
        if (sliceNode == null) {
            SliceNode.$$$reportNull$$$0(3);
        }
        return sliceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SliceNode> getChildren() {
        List list2;
        if (this.isUpToDate()) {
            List<Object> list3 = this.myCachedChildren == null ? Collections.emptyList() : this.myCachedChildren;
            if (list3 == null) {
                SliceNode.$$$reportNull$$$0(4);
            }
            return list3;
        }
        try {
            List nodes;
            ProgressIndicator current2 = ProgressManager.getInstance().getProgressIndicator();
            if (current2 == null) {
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                Ref nodesRef = Ref.create();
                ProgressManager.getInstance().runProcess(() -> nodesRef.set(this.doGetChildren()), (ProgressIndicator)indicator);
                nodes = (List)nodesRef.get();
            } else {
                nodes = this.doGetChildren();
            }
            List list4 = nodes;
            synchronized (list4) {
                this.myCachedChildren = nodes;
            }
            list2 = nodes;
        }
        catch (ProcessCanceledException pce) {
            this.changed = true;
            throw pce;
        }
        if (list2 == null) {
            SliceNode.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private List<SliceNode> doGetChildren() {
        ArrayList<SliceNode> children2 = new ArrayList<SliceNode>();
        ProgressIndicator progress2 = ProgressManager.getInstance().getProgressIndicator();
        Processor processor2 = sliceUsage -> {
            progress2.checkCanceled();
            SliceNode node = new SliceNode(this.myProject, (SliceUsage)((Object)sliceUsage), this.targetEqualUsages);
            List list2 = children2;
            synchronized (list2) {
                node.index = children2.size();
                children2.add(node);
            }
            return true;
        };
        ApplicationManagerEx.getApplicationEx().executeByImpatientReader(() -> ((SliceUsage)((Object)((Object)this.getValue()))).processChildren((Processor<? super SliceUsage>)processor2));
        return children2;
    }

    SliceNode getNext(List parentChildren) {
        return this.index == parentChildren.size() - 1 ? null : (SliceNode)parentChildren.get(this.index + 1);
    }

    SliceNode getPrev(List parentChildren) {
        return this.index == 0 ? null : (SliceNode)parentChildren.get(this.index - 1);
    }

    public List<SliceNode> getCachedChildren() {
        return this.myCachedChildren;
    }

    private boolean isUpToDate() {
        return this.myCachedChildren != null || !this.isValid();
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new PresentationData(){

            public Object @NotNull [] getEqualityObjects() {
                Object[] objectArray = ArrayUtil.append((Object[])super.getEqualityObjects(), (Object)SliceNode.this.changed);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode$1", "getEqualityObjects"));
            }
        };
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            SliceNode.$$$reportNull$$$0(6);
        }
        presentation2.setChanged(presentation2.isChanged() || this.changed);
        this.changed = false;
    }

    public void calculateDupNode() {
        if (!this.dupNodeCalculated) {
            if (!(this.getValue() instanceof SliceTooComplexDFAUsage)) {
                this.duplicate = this.targetEqualUsages.putNodeCheckDupe(this);
            }
            this.dupNodeCalculated = true;
        }
    }

    @Override
    public SliceNode getDuplicate() {
        return this.duplicate;
    }

    public void navigate(boolean requestFocus) {
        SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
        sliceUsage.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((SliceUsage)((Object)this.getValue())).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((SliceUsage)((Object)this.getValue())).canNavigateToSource();
    }

    public boolean isValid() {
        return (Boolean)ReadAction.compute(() -> ((SliceUsage)((Object)((Object)this.getValue()))).isValid());
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (renderer == null) {
            SliceNode.$$$reportNull$$$0(7);
        }
        if (tree == null) {
            SliceNode.$$$reportNull$$$0(8);
        }
        renderer.setIcon(this.getPresentation().getIcon(expanded));
        if (this.isValid()) {
            SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
            renderer.customizeCellRendererFor(sliceUsage);
            renderer.setToolTipText(sliceUsage.getPresentation().getTooltipText());
        } else {
            renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", UsageTreeColors.INVALID_ATTRIBUTES);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    @Nullable
    public SliceLanguageSupportProvider getProvider() {
        AbstractTreeNode element2 = this.getElement();
        if (element2 == null) {
            return null;
        }
        SliceUsage usage = (SliceUsage)((Object)element2.getValue());
        if (usage == null) {
            return null;
        }
        PsiElement psiElement = usage.getElement();
        if (psiElement == null) {
            return null;
        }
        return LanguageSlicing.getProvider(psiElement);
    }

    public String getNodeText() {
        return ((SliceUsage)((Object)this.getValue())).getPresentation().getPlainText().trim();
    }

    public String toString() {
        return (String)ReadAction.compute(() -> this.getValue() == null ? "<null>" : ((SliceUsage)((Object)((Object)this.getValue()))).toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sliceUsage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEqualUsages";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

