/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.BaseComponentAdapter;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BA\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ7\u0010\u0011\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\tH\u0014J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0014J\b\u0010\u001b\u001a\u00020\u0005H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/serviceContainer/MyComponentAdapter;", "Lcom/intellij/serviceContainer/BaseComponentAdapter;", "componentKey", "Ljava/lang/Class;", "implementationClassName", "", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "implementationClass", "isWorkspaceComponent", "", "(Ljava/lang/Class;Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Lcom/intellij/serviceContainer/ComponentManagerImpl;Ljava/lang/Class;Z)V", "getImplementationClassName", "()Ljava/lang/String;", "()Z", "doCreateInstance", "T", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/serviceContainer/ComponentManagerImpl;Ljava/lang/Class;Lcom/intellij/openapi/progress/ProgressIndicator;)Ljava/lang/Object;", "getActivityCategory", "Lcom/intellij/diagnostic/ActivityCategory;", "getComponentKey", "isImplementationEqualsToInterface", "toString", "intellij.platform.serviceContainer"})
public final class MyComponentAdapter
extends BaseComponentAdapter {
    private final Class<?> componentKey;
    @NotNull
    private final String implementationClassName;
    private final boolean isWorkspaceComponent;

    @NotNull
    public Class<?> getComponentKey() {
        return this.componentKey;
    }

    @Override
    protected boolean isImplementationEqualsToInterface() {
        return Intrinsics.areEqual((Object)this.componentKey.getName(), (Object)this.getImplementationClassName());
    }

    @Override
    @Nullable
    protected ActivityCategory getActivityCategory(@NotNull ComponentManagerImpl componentManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentManager), (String)"componentManager");
        if (componentManager.activityNamePrefix() == null) {
            return null;
        }
        DefaultPicoContainer parent = componentManager.getPicoContainer$intellij_platform_serviceContainer().getParent();
        return parent == null ? ActivityCategory.APP_COMPONENT : (parent.getParent() == null ? ActivityCategory.PROJECT_COMPONENT : ActivityCategory.MODULE_COMPONENT);
    }

    @Override
    @NotNull
    protected <T> T doCreateInstance(@NotNull ComponentManagerImpl componentManager, @NotNull Class<T> implementationClass, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentManager), (String)"componentManager");
        Intrinsics.checkNotNullParameter(implementationClass, (String)"implementationClass");
        try {
            T instance = componentManager.instantiateClassWithConstructorInjection(implementationClass, this.componentKey, this.getPluginId());
            if (instance instanceof Disposable) {
                Disposer.register((Disposable)componentManager.getServiceParentDisposable$intellij_platform_serviceContainer(), (Disposable)((Disposable)instance));
            }
            componentManager.initializeComponent$intellij_platform_serviceContainer(instance, null, this.getPluginId());
            if (instance instanceof BaseComponent) {
                ((BaseComponent)instance).initComponent();
                if (!(instance instanceof Disposable)) {
                    Disposer.register((Disposable)componentManager.getServiceParentDisposable$intellij_platform_serviceContainer(), (Disposable)new Disposable(instance){
                        final /* synthetic */ Object $instance;

                        public void dispose() {
                            ((BaseComponent)this.$instance).disposeComponent();
                        }
                        {
                            this.$instance = $captured_local_variable$0;
                        }
                    });
                }
            }
            componentManager.componentCreated$intellij_platform_serviceContainer(indicator);
            return instance;
        }
        catch (Throwable t) {
            String string = this.componentKey.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"componentKey.name");
            componentManager.handleInitComponentError$intellij_platform_serviceContainer(t, string, this.getPluginId());
            throw t;
        }
    }

    @NotNull
    public String toString() {
        return "ComponentAdapter(key=" + this.getComponentKey() + ", implementation=" + this.getComponentImplementation() + ", plugin=" + this.getPluginId() + ')';
    }

    @Override
    @NotNull
    protected String getImplementationClassName() {
        return this.implementationClassName;
    }

    public final boolean isWorkspaceComponent() {
        return this.isWorkspaceComponent;
    }

    public MyComponentAdapter(@NotNull Class<?> componentKey, @NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManagerImpl componentManager, @Nullable Class<?> implementationClass, boolean isWorkspaceComponent) {
        Intrinsics.checkNotNullParameter(componentKey, (String)"componentKey");
        Intrinsics.checkNotNullParameter((Object)implementationClassName, (String)"implementationClassName");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)componentManager), (String)"componentManager");
        super(componentManager, pluginDescriptor, null, implementationClass);
        this.componentKey = componentKey;
        this.implementationClassName = implementationClassName;
        this.isWorkspaceComponent = isWorkspaceComponent;
    }

    public /* synthetic */ MyComponentAdapter(Class clazz, String string, PluginDescriptor pluginDescriptor, ComponentManagerImpl componentManagerImpl, Class clazz2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(clazz, string, pluginDescriptor, componentManagerImpl, clazz2, bl);
    }
}

