/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.serviceContainer.ComponentManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001c\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0000\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createPluginExceptionIfNeeded", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "error", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "doLoadClass", "Ljava/lang/Class;", "name", "", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "handleComponentError", "", "t", "componentClassName", "isGettingServiceAllowedDuringPluginUnloading", "", "descriptor", "intellij.platform.serviceContainer"})
public final class ComponentManagerImplKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final RuntimeException createPluginExceptionIfNeeded(Throwable error, PluginId pluginId) {
        return error instanceof PluginException ? (RuntimeException)error : (RuntimeException)new PluginException(error, pluginId);
    }

    public static final void handleComponentError(@NotNull Throwable t, @Nullable String componentClassName, @Nullable PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t instanceof StartupAbortedException) {
            throw t;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            throw t;
        }
        PluginId effectivePluginId = pluginId;
        if ((effectivePluginId == null || Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)effectivePluginId)) && componentClassName != null) {
            effectivePluginId = PluginManagerCore.getPluginByClassName(componentClassName);
        }
        if (effectivePluginId != null && Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)effectivePluginId) ^ true) {
            throw (Throwable)new StartupAbortedException("Fatal error initializing plugin " + effectivePluginId, (Throwable)new PluginException(t, effectivePluginId));
        }
        throw (Throwable)new StartupAbortedException("Fatal error initializing '" + componentClassName + '\'', t);
    }

    public static final boolean isGettingServiceAllowedDuringPluginUnloading(@NotNull PluginDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return descriptor2.isRequireRestart() || Intrinsics.areEqual((Object)descriptor2.getPluginId(), (Object)PluginManagerCore.CORE_ID) || Intrinsics.areEqual((Object)descriptor2.getPluginId(), (Object)PluginManagerCore.JAVA_PLUGIN_ID);
    }

    private static final Class<?> doLoadClass(String name, PluginDescriptor pluginDescriptor) {
        ClassLoader classLoader;
        ClassLoader classLoader2 = pluginDescriptor.getPluginClassLoader();
        if (classLoader2 == null) {
            classLoader2 = classLoader = ComponentManagerImpl.class.getClassLoader();
        }
        if (classLoader instanceof PluginAwareClassLoader) {
            Class clazz = ((PluginAwareClassLoader)classLoader).tryLoadingClass(name, true);
            if (clazz == null) {
                throw (Throwable)new ClassNotFoundException(name + ' ' + classLoader);
            }
            return clazz;
        }
        Class<?> clazz = classLoader.loadClass(name);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(name)");
        return clazz;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Class access$doLoadClass(String name, PluginDescriptor pluginDescriptor) {
        return ComponentManagerImplKt.doLoadClass(name, pluginDescriptor);
    }

    public static final /* synthetic */ RuntimeException access$createPluginExceptionIfNeeded(Throwable error, PluginId pluginId) {
        return ComponentManagerImplKt.createPluginExceptionIfNeeded(error, pluginId);
    }
}

