/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization.stateProperties;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.JsonSchemaType;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.StoredPropertyBase;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u0017\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u0015\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\"J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010#H\u0016J\b\u0010$\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/serialization/stateProperties/CollectionStoredProperty;", "E", "", "C", "", "Lcom/intellij/openapi/components/StoredPropertyBase;", "value", "defaultValue", "", "(Ljava/util/Collection;Ljava/lang/String;)V", "jsonType", "Lcom/intellij/openapi/components/JsonSchemaType;", "getJsonType", "()Lcom/intellij/openapi/components/JsonSchemaType;", "getValue", "()Ljava/util/Collection;", "Ljava/util/Collection;", "__getValue", "doSetValue", "", "old", "new", "(Ljava/util/Collection;Ljava/util/Collection;)Z", "equals", "other", "thisRef", "Lcom/intellij/openapi/components/BaseState;", "(Lcom/intellij/openapi/components/BaseState;)Ljava/util/Collection;", "hashCode", "", "isEqualToDefault", "setValue", "", "newValue", "(Lcom/intellij/openapi/components/BaseState;Ljava/util/Collection;)V", "Lcom/intellij/openapi/components/StoredProperty;", "toString", "intellij.platform.objectSerializer"})
public class CollectionStoredProperty<E, C extends Collection<E>>
extends StoredPropertyBase<C> {
    @NotNull
    private final C value;
    private final String defaultValue;

    @NotNull
    public JsonSchemaType getJsonType() {
        return JsonSchemaType.ARRAY;
    }

    public boolean isEqualToDefault() {
        return this.defaultValue == null ? this.value.isEmpty() : this.value.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((Iterable)((Iterable)this.value)), (Object)this.defaultValue);
    }

    @NotNull
    public C getValue(@NotNull BaseState thisRef) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        return this.value;
    }

    public void setValue(@NotNull BaseState thisRef, @NotNull C newValue2) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(newValue2, (String)"newValue");
        if (this.doSetValue(this.value, newValue2)) {
            thisRef.intIncrementModificationCount();
        }
    }

    private final boolean doSetValue(C old, C c) {
        if (Intrinsics.areEqual(old, c)) {
            return false;
        }
        old.clear();
        old.addAll(c);
        return true;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CollectionStoredProperty && Intrinsics.areEqual(this.value, ((CollectionStoredProperty)((Object)other)).value) && Intrinsics.areEqual((Object)this.defaultValue, (Object)((CollectionStoredProperty)((Object)other)).defaultValue);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getName() + " = " + (this.isEqualToDefault() ? "" : CollectionsKt.joinToString$default((Iterable)((Iterable)this.value), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
    }

    public boolean setValue(@NotNull StoredProperty<C> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.doSetValue(this.value, ((CollectionStoredProperty)other).value);
    }

    @NotNull
    public final C __getValue() {
        return this.value;
    }

    @NotNull
    protected final C getValue() {
        return this.value;
    }

    public CollectionStoredProperty(@NotNull C value2, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.value = value2;
        this.defaultValue = defaultValue;
    }
}

