/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.impl.bin.Block;
import com.amazon.ion.impl.bin.BlockAllocator;
import com.amazon.ion.impl.bin.BlockAllocatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R*\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0011\u0010\t\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider;", "Lcom/amazon/ion/impl/bin/BlockAllocatorProvider;", "()V", "allocators", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/Queue;", "Lcom/intellij/serialization/PooledBlockAllocatorProvider$PooledBlockAllocator;", "getAllocators$annotations", "byteSize", "getByteSize", "()I", "removeExcess", "", "vendAllocator", "Lcom/amazon/ion/impl/bin/BlockAllocator;", "blockSize", "Companion", "PooledBlockAllocator", "intellij.platform.objectSerializer"})
public final class PooledBlockAllocatorProvider
extends BlockAllocatorProvider {
    private final ConcurrentHashMap<Integer, Queue<PooledBlockAllocator>> allocators = new ConcurrentHashMap();
    public static final int POOL_THRESHOLD = 524288;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private static /* synthetic */ void getAllocators$annotations() {
    }

    @TestOnly
    public final int getByteSize() {
        int totalByteSize = 0;
        Collection<Queue<PooledBlockAllocator>> collection = this.allocators.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"allocators.values");
        for (PooledBlockAllocator allocator : CollectionsKt.flatten((Iterable)collection)) {
            totalByteSize += allocator.getByteSize();
        }
        return totalByteSize;
    }

    @NotNull
    public BlockAllocator vendAllocator(int blockSize) {
        if (blockSize <= 0) {
            throw (Throwable)new IllegalArgumentException("Invalid block size: " + blockSize);
        }
        Object object = this.allocators.get(blockSize);
        if (object == null || (object = object.poll()) == null) {
            object = new PooledBlockAllocator(blockSize);
        }
        Object result2 = object;
        this.removeExcess();
        return (BlockAllocator)result2;
    }

    private final void removeExcess() {
        int totalByteSize = 0;
        Iterator<Queue<PooledBlockAllocator>> queuesIterator = this.allocators.values().iterator();
        boolean isExcess = false;
        while (queuesIterator.hasNext()) {
            Queue<PooledBlockAllocator> nextQueue;
            Intrinsics.checkNotNullExpressionValue(queuesIterator.next(), (String)"queuesIterator.next()");
            Iterator iterator2 = nextQueue.iterator();
            while (iterator2.hasNext()) {
                PooledBlockAllocator allocator = (PooledBlockAllocator)((Object)iterator2.next());
                if (isExcess) {
                    iterator2.remove();
                    continue;
                }
                if ((totalByteSize += allocator.getByteSize()) <= 524288) continue;
                iterator2.remove();
                isExcess = true;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider$PooledBlockAllocator;", "Lcom/amazon/ion/impl/bin/BlockAllocator;", "blockSize", "", "(Lcom/intellij/serialization/PooledBlockAllocatorProvider;I)V", "blockCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "byteSize", "getByteSize", "()I", "freeBlocks", "Ljava/util/ArrayList;", "Lcom/amazon/ion/impl/bin/Block;", "allocateBlock", "close", "", "getBlockSize", "intellij.platform.objectSerializer"})
    private final class PooledBlockAllocator
    extends BlockAllocator {
        private final ArrayList<Block> freeBlocks;
        private final AtomicInteger blockCounter;
        private final int blockSize;

        public final int getByteSize() {
            return this.blockCounter.get() * this.blockSize;
        }

        @NotNull
        public Block allocateBlock() {
            int lastIndex = CollectionsKt.getLastIndex((List)this.freeBlocks);
            if (lastIndex != -1) {
                Block block = this.freeBlocks.remove(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)block, (String)"freeBlocks.removeAt(lastIndex)");
                return block;
            }
            this.blockCounter.incrementAndGet();
            return new Block(this, new byte[this.blockSize]){
                final /* synthetic */ PooledBlockAllocator this$0;

                public void close() {
                    this.reset();
                    PooledBlockAllocator.access$getFreeBlocks$p(this.this$0).add(this);
                }
                {
                    this.this$0 = this$0;
                    super($super_call_param$1);
                }
            };
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        /*
         * WARNING - void declaration
         */
        public void close() {
            void $this$getOrPut$iv;
            if (this.blockSize * this.freeBlocks.size() > 524288) {
                this.freeBlocks.clear();
                this.blockCounter.set(0);
                return;
            }
            ConcurrentMap concurrentMap = PooledBlockAllocatorProvider.this.allocators;
            Integer key$iv = this.blockSize;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl = false;
                ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
                boolean bl2 = false;
                boolean bl3 = false;
                ConcurrentLinkedQueue default$iv = concurrentLinkedQueue;
                boolean bl4 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((Queue)object).add(this);
            PooledBlockAllocatorProvider.this.removeExcess();
        }

        public PooledBlockAllocator(int blockSize) {
            this.blockSize = blockSize;
            this.freeBlocks = new ArrayList();
            this.blockCounter = new AtomicInteger();
        }

        public static final /* synthetic */ ArrayList access$getFreeBlocks$p(PooledBlockAllocator $this) {
            return $this.freeBlocks;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/serialization/PooledBlockAllocatorProvider$Companion;", "", "()V", "POOL_THRESHOLD", "", "intellij.platform.objectSerializer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

