/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serialization;

import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.intellij.serialization.BaseCollectionBinding;
import com.intellij.serialization.BindingInitializationContext;
import com.intellij.serialization.MutableAccessor;
import com.intellij.serialization.ReadContext;
import com.intellij.serialization.WriteContext;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\fJ \u0010\u0007\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\nH\u0016J'\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0013H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/serialization/ArrayBinding;", "Lcom/intellij/serialization/BaseCollectionBinding;", "itemClass", "Ljava/lang/Class;", "context", "Lcom/intellij/serialization/BindingInitializationContext;", "(Ljava/lang/Class;Lcom/intellij/serialization/BindingInitializationContext;)V", "deserialize", "", "", "Lcom/intellij/serialization/ReadContext;", "hostObject", "(Lcom/intellij/serialization/ReadContext;Ljava/lang/Object;)[Ljava/lang/Object;", "", "property", "Lcom/intellij/serialization/MutableAccessor;", "readArray", "serialize", "obj", "Lcom/intellij/serialization/WriteContext;", "intellij.platform.objectSerializer"})
public final class ArrayBinding
extends BaseCollectionBinding {
    private final Class<?> itemClass;

    @NotNull
    public Object[] deserialize(@NotNull ReadContext context, @Nullable Object hostObject) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.readArray(context, hostObject);
    }

    @Override
    public void deserialize(@NotNull Object hostObject, @NotNull MutableAccessor property, @NotNull ReadContext context) {
        Intrinsics.checkNotNullParameter((Object)hostObject, (String)"hostObject");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IonType type = context.getReader().getType();
        if (type == IonType.NULL) {
            property.set(hostObject, null);
        } else if (type != IonType.INT) {
            property.set(hostObject, (Object)this.readArray(context, hostObject));
        }
    }

    @Override
    public void serialize(@NotNull Object obj2, @NotNull WriteContext context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] array2 = (Object[])obj2;
        IonWriter writer = context.getWriter();
        if (context.getFilter().getSkipEmptyArray()) {
            Object[] objectArray = array2;
            boolean bl = false;
            if (objectArray.length == 0) {
                writer.writeInt(0L);
                return;
            }
        }
        writer.stepIn(IonType.LIST);
        Consumer<Object> consumer2 = this.createItemConsumer(context);
        Object[] $this$forEach$iv = array2;
        boolean $i$f$forEach = false;
        Object[] objectArray = $this$forEach$iv;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            Object element$iv;
            Object it = element$iv = objectArray[j];
            boolean bl = false;
            consumer2.accept(it);
        }
        writer.stepOut();
    }

    private final Object[] readArray(ReadContext context, Object hostObject) {
        ArrayList list2 = new ArrayList();
        this.readInto(hostObject, list2, context);
        Object[] result2 = ArrayUtil.newArray(this.itemClass, (int)list2.size());
        list2.toArray(result2);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }

    public ArrayBinding(@NotNull Class<?> itemClass, @NotNull BindingInitializationContext context) {
        Intrinsics.checkNotNullParameter(itemClass, (String)"itemClass");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(itemClass, context);
        this.itemClass = itemClass;
    }
}

