/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LoggingHandlerImpl
extends LoggingHandlerBase
implements LoggingHandler {
    private final ConsoleView myConsole;
    private boolean myClosed;

    public LoggingHandlerImpl(String presentableName, @NotNull Project project) {
        if (project == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(0);
        }
        this(presentableName, project, false);
    }

    public LoggingHandlerImpl(String presentableName, @NotNull Project project, boolean isViewer) {
        if (project == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(1);
        }
        super(presentableName);
        this.myClosed = false;
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder2.setViewer(isViewer);
        this.myConsole = builder2.getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    @Override
    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(2);
        }
        return consoleView;
    }

    public void print(@NotNull String s) {
        if (s == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(3);
        }
        this.printText(s, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    protected void printText(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(5);
        }
        this.myConsole.print(text2, contentType);
    }

    public void printHyperlink(@NotNull String url) {
        if (url == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(6);
        }
        this.printHyperlink(url, (HyperlinkInfo)new BrowserHyperlinkInfo(url));
    }

    public void printHyperlink(@NotNull String text2, HyperlinkInfo info) {
        if (text2 == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(7);
        }
        this.myConsole.printHyperlink(text2, info);
    }

    public void printlnSystemMessage(@NotNull String s) {
        if (s == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(8);
        }
        this.printText(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void attachToProcess(@NotNull ProcessHandler handler2) {
        if (handler2 == null) {
            LoggingHandlerImpl.$$$reportNull$$$0(9);
        }
        this.myConsole.attachToProcess(handler2);
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void clear() {
        this.myConsole.clear();
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public void close() {
        this.myClosed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printlnSystemMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Colored
    extends LoggingHandlerImpl {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;

        public Colored(String presentableName, @NotNull Project project) {
            if (project == null) {
                Colored.$$$reportNull$$$0(0);
            }
            super(presentableName, project);
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        }

        public Colored(String presentableName, @NotNull Project project, boolean isViewer) {
            if (project == null) {
                Colored.$$$reportNull$$$0(1);
            }
            super(presentableName, project, isViewer);
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
        }

        @Override
        public void print(@NotNull String s) {
            if (s == null) {
                Colored.$$$reportNull$$$0(2);
            }
            this.myAnsiEscapeDecoder.escapeText(s, ProcessOutputTypes.STDOUT, this::printTextWithOutputKey);
        }

        private void printTextWithOutputKey(@NotNull String text2, Key outputType) {
            if (text2 == null) {
                Colored.$$$reportNull$$$0(3);
            }
            this.printText(text2, ConsoleViewContentType.getConsoleViewType((Key)outputType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl$Colored";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "printTextWithOutputKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

