/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010\u0019\u001a\u00020\rJ\u0014\u0010\u001a\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/refactoring/suggested/NewIdentifierWatcher;", "", "maxIdentifiers", "", "(I)V", "lastDocument", "Lcom/intellij/openapi/editor/Document;", "getLastDocument", "()Lcom/intellij/openapi/editor/Document;", "newIdentifierMarkers", "Ljava/util/ArrayDeque;", "Lcom/intellij/refactoring/suggested/NewIdentifierWatcher$Ref;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "language", "Lcom/intellij/lang/Language;", "isNewIdentifierInserted", "", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "lastNewIdentifierRanges", "", "Lcom/intellij/openapi/util/TextRange;", "reset", "isIdentifierLike", "text", "", "Ref", "intellij.platform.lang.impl"})
public final class NewIdentifierWatcher {
    private final ArrayDeque<Ref> newIdentifierMarkers;
    private final int maxIdentifiers;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Document getLastDocument() {
        Ref ref = (Ref)CollectionsKt.firstOrNull((Iterable)this.newIdentifierMarkers);
        Ref ref2 = ref;
        if (ref == null) return null;
        RangeMarker rangeMarker = ref2.getMarker();
        ref2 = rangeMarker;
        if (rangeMarker == null) return null;
        Ref ref3 = ref2;
        boolean bl = false;
        boolean bl2 = false;
        Ref it = ref3;
        boolean bl3 = false;
        if (!it.isValid()) return null;
        Ref ref4 = ref3;
        ref2 = ref4;
        if (ref4 == null) return null;
        Document document = ref2.getDocument();
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> lastNewIdentifierRanges() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.newIdentifierMarkers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TextRange textRange;
            void it;
            Ref ref = (Ref)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)UtilsKt.getRange((RangeMarker)it.getMarker()));
            collection.add(textRange);
        }
        return (List)destination$iv$iv;
    }

    public final void documentChanged(@NotNull DocumentEvent event, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence chars = charSequence;
        if (Intrinsics.areEqual((Object)document2, (Object)this.getLastDocument()) ^ true) {
            this.reset();
        }
        SuggestedRefactoringSupport suggestedRefactoringSupport = SuggestedRefactoringSupport.Companion.forLanguage(language);
        if (suggestedRefactoringSupport == null) {
            return;
        }
        SuggestedRefactoringSupport refactoringSupport = suggestedRefactoringSupport;
        Iterator<Ref> iterator2 = this.newIdentifierMarkers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"newIdentifierMarkers.iterator()");
        Iterator<Ref> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            int end;
            int start2;
            Ref ref = iterator3.next();
            TextRange range2 = UtilsKt.getRange((RangeMarker)ref.getMarker());
            if (range2 == null) {
                iterator3.remove();
                continue;
            }
            for (start2 = range2.getStartOffset(); start2 > 0 && refactoringSupport.isIdentifierPart(chars.charAt(start2 - 1)); --start2) {
            }
            for (end = range2.getEndOffset(); end < document2.getTextLength() && refactoringSupport.isIdentifierPart(chars.charAt(end)); ++end) {
            }
            if (start2 == range2.getStartOffset() && end == range2.getEndOffset()) continue;
            ref.getMarker().dispose();
            RangeMarker rangeMarker = document2.createRangeMarker(start2, end);
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMarker(start, end)");
            ref.setMarker(rangeMarker);
        }
        if (this.isNewIdentifierInserted(event, refactoringSupport)) {
            RangeMarker marker;
            if (this.newIdentifierMarkers.size() == this.maxIdentifiers) {
                marker = this.newIdentifierMarkers.removeFirst().getMarker();
                marker.dispose();
            }
            RangeMarker rangeMarker = document2.createRangeMarker(UtilsKt.getNewRange((DocumentEvent)event));
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMarker(event.newRange)");
            marker = rangeMarker;
            this.newIdentifierMarkers.addLast(new Ref(marker));
        } else {
            boolean bl;
            block16: {
                boolean bl2;
                boolean $i$f$any;
                Object $this$any$iv;
                block15: {
                    $this$any$iv = this.newIdentifierMarkers;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator4 = $this$any$iv.iterator();
                        while (iterator4.hasNext()) {
                            Object element$iv = iterator4.next();
                            Ref it = (Ref)element$iv;
                            boolean bl3 = false;
                            TextRange textRange = UtilsKt.getRange((RangeMarker)it.getMarker());
                            Intrinsics.checkNotNull((Object)textRange);
                            if (!textRange.contains(UtilsKt.getNewRange((DocumentEvent)event))) continue;
                            bl2 = true;
                            break block15;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return;
                }
                CharSequence charSequence2 = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"event.newFragment");
                $this$any$iv = charSequence2;
                $i$f$any = false;
                Object object = $this$any$iv;
                for (int j = 0; j < object.length(); ++j) {
                    char element$iv;
                    char it = element$iv = object.charAt(j);
                    boolean bl4 = false;
                    if (!refactoringSupport.isIdentifierStart(it)) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
            if (bl) {
                this.reset();
            }
        }
    }

    public final void reset() {
        Iterable $this$forEach$iv = this.newIdentifierMarkers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Ref it = (Ref)element$iv;
            boolean bl = false;
            it.getMarker().dispose();
        }
        this.newIdentifierMarkers.clear();
    }

    private final boolean isNewIdentifierInserted(DocumentEvent event, SuggestedRefactoringSupport refactoringSupport) {
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.newFragment");
        if (!this.isIdentifierLike(refactoringSupport, charSequence)) {
            return false;
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
        CharSequence charSequence2 = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"event.document.charsSequence");
        CharSequence chars = charSequence2;
        int start2 = event.getOffset();
        int end = event.getOffset() + event.getNewLength();
        if (start2 > 0 && refactoringSupport.isIdentifierPart(chars.charAt(start2 - 1))) {
            return false;
        }
        Document document2 = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"event.document");
        return end >= document2.getTextLength() || !refactoringSupport.isIdentifierPart(chars.charAt(end));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIdentifierLike(SuggestedRefactoringSupport $this$isIdentifierLike, CharSequence text2) {
        CharSequence charSequence = text2;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!$this$isIdentifierLike.isIdentifierStart(text2.charAt(0))) return false;
        CharSequence $this$all$iv = text2;
        boolean $i$f$all = false;
        CharSequence charSequence2 = $this$all$iv;
        int n = 0;
        while (n < charSequence2.length()) {
            char element$iv;
            char it = element$iv = charSequence2.charAt(n);
            boolean bl3 = false;
            if (!$this$isIdentifierLike.isIdentifierPart(it)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public NewIdentifierWatcher(int maxIdentifiers) {
        this.maxIdentifiers = maxIdentifiers;
        boolean bl = this.maxIdentifiers > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.newIdentifierMarkers = new ArrayDeque();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lcom/intellij/refactoring/suggested/NewIdentifierWatcher$Ref;", "", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/intellij/openapi/editor/RangeMarker;)V", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "setMarker", "intellij.platform.lang.impl"})
    private static final class Ref {
        @NotNull
        private RangeMarker marker;

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        public final void setMarker(@NotNull RangeMarker rangeMarker) {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"<set-?>");
            this.marker = rangeMarker;
        }

        public Ref(@NotNull RangeMarker marker) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.marker = marker;
        }
    }
}

