/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.rename.AutomaticRenamingDialog;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.RenameChooser;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableInplaceRenamer
extends InplaceRefactoring {
    public static final LanguageExtension<ResolveSnapshotProvider> INSTANCE = new LanguageExtension("com.intellij.rename.inplace.resolveSnapshotProvider");
    private ResolveSnapshotProvider.ResolveSnapshot mySnapshot;
    private TextRange mySelectedRange;
    protected Language myLanguage;

    public VariableInplaceRenamer(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor) {
        if (elementToRename == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(1);
        }
        this(elementToRename, editor, elementToRename.getProject());
    }

    public VariableInplaceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (project == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(3);
        }
        this(elementToRename, editor, project, elementToRename != null ? elementToRename.getName() : null, elementToRename != null ? elementToRename.getName() : null);
    }

    public VariableInplaceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull Project project, @Nullable String initialName, @Nullable String oldName) {
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(4);
        }
        if (project == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(5);
        }
        super(editor, elementToRename, project, initialName, oldName);
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler2, PsiElement element2) {
        return super.startsOnTheSameElement(handler2, element2) && handler2 instanceof VariableInplaceRenameHandler;
    }

    public boolean performInplaceRename() {
        return this.performInplaceRefactoring(null);
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(6);
        }
        String stringToSearch = this.myElementToRename.getName();
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (!StringUtil.isEmptyOrSpaces((String)stringToSearch)) {
            TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myElementToRename, (SearchScope)GlobalSearchScope.projectScope((Project)this.myElementToRename.getProject()), stringToSearch, true, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(psiElement, textRange) -> {
                if (psiElement.getContainingFile() == currentFile) {
                    stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
                }
                return true;
            }));
        }
    }

    @Override
    protected boolean buildTemplateAndStart(final Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, final PsiElement scope, final PsiFile containingFile) {
        if (this.appendAdditionalElement(refs, stringUsages)) {
            return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
        }
        RenameChooser renameChooser = new RenameChooser(this.myEditor){

            @Override
            protected void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> stringUsages) {
                if (!VariableInplaceRenamer.super.buildTemplateAndStart(refs, stringUsages, scope, containingFile)) {
                    VariableInplaceRenameHandler.performDialogRename((PsiElement)VariableInplaceRenamer.this.myElementToRename, VariableInplaceRenamer.this.myEditor, DataManager.getInstance().getDataContext((Component)VariableInplaceRenamer.this.myEditor.getContentComponent()), VariableInplaceRenamer.this.myInitialName);
                }
            }
        };
        renameChooser.showChooser(refs, stringUsages);
        return true;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        return stringUsages.isEmpty() || StartMarkAction.canStart(this.myEditor) != null;
    }

    protected boolean shouldCreateSnapshot() {
        return true;
    }

    protected String getRefactoringId() {
        return "refactoring.rename";
    }

    @Override
    protected void beforeTemplateStart() {
        SelectionModel selectionModel;
        super.beforeTemplateStart();
        this.myLanguage = this.myScope.getLanguage();
        if (this.shouldCreateSnapshot()) {
            ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)INSTANCE.forLanguage(this.myLanguage);
            this.mySnapshot = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
        }
        this.mySelectedRange = (selectionModel = this.myEditor.getSelectionModel()).hasSelection() ? new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) : null;
    }

    @Override
    protected void restoreSelection() {
        if (this.mySelectedRange != null) {
            VariableInplaceRenamer.restoreSelection(this.myEditor, this.mySelectedRange);
        } else if (!this.shouldSelectAll()) {
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    static void restoreSelection(@NotNull Editor editor, @NotNull TextRange selectedRange) {
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(7);
        }
        if (selectedRange == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(8);
        }
        if (VariableInplaceRenamer.handleSelectionIntersection(editor, selectedRange)) {
            return;
        }
        editor.getSelectionModel().setSelection(selectedRange.getStartOffset(), selectedRange.getEndOffset());
    }

    private static boolean handleSelectionIntersection(@NotNull Editor editor, @NotNull TextRange selectedRange) {
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(9);
        }
        if (selectedRange == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(10);
        }
        if (editor instanceof EditorWindow) {
            EditorWindow editorWindow = (EditorWindow)editor;
            Editor hostEditor = editorWindow.getDelegate();
            PsiFile injected = editorWindow.getInjectedFile();
            TextRange hostSelectedRange = InjectedLanguageManager.getInstance((Project)hostEditor.getProject()).injectedToHost((PsiElement)injected, selectedRange);
            return VariableInplaceRenamer.doHandleSelectionIntersection(hostEditor, hostSelectedRange);
        }
        return VariableInplaceRenamer.doHandleSelectionIntersection(editor, selectedRange);
    }

    private static boolean doHandleSelectionIntersection(@NotNull Editor editor, @NotNull TextRange selectedRange) {
        TemplateState state;
        if (editor == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(11);
        }
        if (selectedRange == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(12);
        }
        if ((state = TemplateManagerImpl.getTemplateState(editor)) == null) {
            return false;
        }
        for (int i2 = 0; i2 < state.getSegmentsCount(); ++i2) {
            TextRange segmentRange = state.getSegmentRange(i2);
            TextRange intersection = segmentRange.intersection(selectedRange);
            if (intersection == null) continue;
            editor.getSelectionModel().setSelection(intersection.getStartOffset(), intersection.getEndOffset());
            return true;
        }
        return false;
    }

    @Override
    protected int restoreCaretOffset(int offset) {
        return VariableInplaceRenamer.restoreCaretOffset(this.myCaretRangeMarker, offset);
    }

    static int restoreCaretOffset(@NotNull RangeMarker caretRangeMarker, int offset) {
        if (caretRangeMarker == null) {
            VariableInplaceRenamer.$$$reportNull$$$0(13);
        }
        if (caretRangeMarker.isValid()) {
            if (caretRangeMarker.getStartOffset() <= offset && caretRangeMarker.getEndOffset() >= offset) {
                return offset;
            }
            return caretRangeMarker.getEndOffset();
        }
        return offset;
    }

    @Override
    protected boolean shouldSelectAll() {
        if (this.myEditor.getSettings().isPreselectRename()) {
            return true;
        }
        Boolean selectAll2 = (Boolean)this.myEditor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        return selectAll2 != null && selectAll2 != false;
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new VariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
    }

    protected void performOnInvalidIdentifier(String newName2, LinkedHashSet<String> nameSuggestions) {
        PsiNamedElement variable = this.getVariable();
        if (variable != null) {
            int offset = variable.getTextOffset();
            this.restoreCaretOffset(offset);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            JBPopupFactory.getInstance().createConfirmation(LangBundle.message((String)"popup.title.inserted.identifier.valid", (Object[])new Object[0]), IdeBundle.message((String)"label.continue.editing", (Object[])new Object[0]), CommonBundle.getCancelButtonText(), () -> this.createInplaceRenamerToRestart(variable, this.myEditor, newName2).performInplaceRefactoring(nameSuggestions), 0).showInBestPositionFor(this.myEditor);
        }
    }

    protected void renameSynthetic(String newName2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoringRename(String newName2, StartMarkAction markAction) {
        AutomaticRenamer renamer;
        ArrayList usages;
        PsiNamedElement elementToRename;
        String refactoringId;
        block26: {
            block27: {
                refactoringId = this.getRefactoringId();
                elementToRename = this.getVariable();
                if (refactoringId != null) {
                    RefactoringEventData beforeData = new RefactoringEventData();
                    beforeData.addElement((PsiElement)elementToRename);
                    beforeData.addStringProperties(new String[]{this.myOldName});
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, beforeData);
                }
                if (this.isIdentifier(newName2, this.myLanguage)) break block26;
                if (refactoringId == null) break block27;
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)this.getVariable());
                afterData.addStringProperties(new String[]{newName2});
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
            }
            try {
                ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
            return;
        }
        try {
            if (elementToRename != null) {
                WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(() -> this.renameSynthetic(newName2));
            }
            for (AutomaticRenamerFactory renamerFactory : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
                AutomaticRenamingDialog renamingDialog;
                if (elementToRename == null || !renamerFactory.isApplicable((PsiElement)elementToRename)) continue;
                usages = new ArrayList();
                renamer = renamerFactory.createRenamer((PsiElement)elementToRename, newName2, new ArrayList<UsageInfo>());
                if (!renamer.hasAnythingToRename() || !ApplicationManager.getApplication().isUnitTestMode() && !(renamingDialog = new AutomaticRenamingDialog(this.myProject, renamer)).showAndGet()) continue;
                Runnable runnable2 = () -> ApplicationManager.getApplication().runReadAction(() -> renamer.findUsages(usages, false, false));
                if (ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable2, RefactoringBundle.message((String)"searching.for.variables"), true, this.myProject)) break block29;
                if (refactoringId == null) break block30;
            }
        }
        catch (Throwable throwable) {
            if (refactoringId != null) {
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement((PsiElement)this.getVariable());
                afterData.addStringProperties(new String[]{newName2});
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
            }
            try {
                ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
            throw throwable;
        }
        {
            block32: {
                block33: {
                    RefactoringEventData afterData;
                    block29: {
                        block30: {
                            afterData = new RefactoringEventData();
                            afterData.addElement((PsiElement)this.getVariable());
                            afterData.addStringProperties(new String[]{newName2});
                            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
                        }
                        try {
                            ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
                        }
                        finally {
                            FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
                        }
                        return;
                    }
                    if (CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement[])PsiUtilCore.toPsiElementArray(renamer.getElements()))) break block32;
                    if (refactoringId == null) break block33;
                    afterData = new RefactoringEventData();
                    afterData.addElement((PsiElement)this.getVariable());
                    afterData.addStringProperties(new String[]{newName2});
                    ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
                }
                try {
                    ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
                }
                finally {
                    FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
                }
                return;
            }
            ThrowableRunnable performAutomaticRename = () -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
                MultiMap<PsiElement, UsageInfo> classified = RenameProcessor.classifyUsages(renamer.getElements(), usages);
                for (PsiNamedElement element2 : renamer.getElements()) {
                    String newElementName = renamer.getNewName(element2);
                    if (newElementName == null) continue;
                    Collection infos = classified.get((Object)element2);
                    RenameUtil.doRename((PsiElement)element2, newElementName, infos.toArray(UsageInfo.EMPTY_ARRAY), this.myProject, RefactoringElementListener.DEAF);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(performAutomaticRename);
                continue;
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.writeCommandAction((Project)this.myProject).withName(this.getCommandName()).run(performAutomaticRename));
            continue;
        }
        if (refactoringId != null) {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement((PsiElement)this.getVariable());
            afterData.addStringProperties(new String[]{newName2});
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
        }
        try {
            ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
        }
        finally {
            FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
        }
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"renaming.command.name", (Object[])new Object[]{this.myInitialName});
    }

    @Override
    protected boolean performRefactoring() {
        boolean bind2 = false;
        if (this.myInsertedName != null) {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            if (commandProcessor.getCurrentCommand() != null && this.getVariable() != null) {
                commandProcessor.setCurrentCommandName(this.getCommandName());
            }
            bind2 = true;
            if (!this.isIdentifier(this.myInsertedName, this.myLanguage)) {
                this.performOnInvalidIdentifier(this.myInsertedName, this.myNameSuggestions);
            } else if (this.mySnapshot != null) {
                ApplicationManager.getApplication().runWriteAction(() -> this.mySnapshot.apply(this.myInsertedName));
            }
            this.performRefactoringRename(this.myInsertedName, this.myMarkAction);
        }
        return bind2;
    }

    @Override
    public void finish(boolean success2) {
        super.finish(success2);
        if (success2) {
            this.revertStateOnFinish();
        } else {
            ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
        }
    }

    protected void revertStateOnFinish() {
        if (this.myInsertedName == null || !this.isIdentifier(this.myInsertedName, this.myLanguage)) {
            this.revertState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRange";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretRangeMarker";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/inplace/VariableInplaceRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElementsToRename";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreSelection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSelectionIntersection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "doHandleSelectionIntersection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreCaretOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

