/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.TemplateInlayUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberInplaceRenamer
extends VariableInplaceRenamer {
    private final PsiElement mySubstituted;
    private RangeMarker mySubstitutedRange;

    public MemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, @Nullable PsiElement substituted, @NotNull Editor editor) {
        if (elementToRename == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(1);
        }
        this(elementToRename, substituted, editor, elementToRename.getName(), elementToRename.getName());
    }

    public MemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, @Nullable PsiElement substituted, @NotNull Editor editor, @Nullable String initialName, @Nullable String oldName) {
        if (elementToRename == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(3);
        }
        super(elementToRename, editor, elementToRename.getProject(), initialName, oldName);
        this.mySubstituted = substituted;
        if (this.mySubstituted != null && this.mySubstituted != this.myElementToRename && this.mySubstituted.getTextRange() != null) {
            PsiFile containingFile = this.mySubstituted.getContainingFile();
            if (!this.notSameFile(containingFile.getVirtualFile(), containingFile)) {
                this.mySubstitutedRange = this.myEditor.getDocument().createRangeMarker(this.mySubstituted.getTextRange());
                this.mySubstitutedRange.setGreedyToLeft(true);
                this.mySubstitutedRange.setGreedyToRight(true);
            }
        } else {
            this.mySubstitutedRange = null;
        }
        this.showDialogAdvertisement("RenameElement");
    }

    @Override
    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new MemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
    }

    @Override
    protected boolean acceptReference(PsiReference reference2) {
        PsiElement element2 = reference2.getElement();
        TextRange textRange = this.getRangeToRename(reference2);
        String referenceText = textRange.substring(element2.getText());
        return Comparing.strEqual((String)referenceText, (String)this.myElementToRename.getName());
    }

    @Override
    protected PsiElement checkLocalScope() {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (currentFile != null) {
            return currentFile;
        }
        return super.checkLocalScope();
    }

    @Override
    protected PsiElement getNameIdentifier() {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (currentFile == this.myElementToRename.getContainingFile()) {
            return super.getNameIdentifier();
        }
        if (currentFile != null) {
            PsiReference reference2;
            PsiElement referenceExpression;
            int offset = this.myEditor.getCaretModel().getOffset();
            offset = TargetElementUtil.adjustOffset(currentFile, this.myEditor.getDocument(), offset);
            PsiElement elementAt = currentFile.findElementAt(offset);
            if (elementAt != null && (referenceExpression = elementAt.getParent()) != null && (reference2 = referenceExpression.getReference()) != null && reference2.resolve() == this.myElementToRename) {
                return elementAt;
            }
            return null;
        }
        return null;
    }

    @Override
    protected void showDialogAdvertisement(@NonNls String actionId) {
        if (Registry.is((String)"enable.rename.options.inplace", (boolean)true)) {
            this.initPopupOptionsAdvertisement();
        } else {
            super.showDialogAdvertisement(actionId);
        }
    }

    @Override
    protected boolean isIdentifier(String newName2, Language language) {
        PsiNamedElement namedElement = this.getVariable();
        return namedElement != null ? RenameUtil.isValidName(this.myProject, (PsiElement)namedElement, newName2) : super.isIdentifier(newName2, language);
    }

    @Override
    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        PsiElement substituted;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(super.collectRefs(referencesSearchScope));
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null && substituted != variable) {
            references.addAll(ReferencesSearch.search((PsiElement)substituted, (SearchScope)referencesSearchScope, (boolean)false).findAll());
        }
        return references;
    }

    @Override
    protected boolean notSameFile(@Nullable VirtualFile file2, @NotNull PsiFile containingFile) {
        PsiFile currentFile;
        if (containingFile == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(4);
        }
        if ((currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) == null) {
            return true;
        }
        InjectedLanguageManager manager2 = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        return manager2.getTopLevelFile((PsiElement)containingFile) != manager2.getTopLevelFile((PsiElement)currentFile);
    }

    @Override
    protected SearchScope getReferencesSearchScope(VirtualFile file2) {
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        return currentFile != null ? new LocalSearchScope((PsiElement)currentFile) : ProjectScope.getProjectScope((Project)this.myProject);
    }

    @Override
    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        PsiElement substituted;
        boolean showChooser = Registry.is((String)"enable.rename.options.inplace", (boolean)true) || super.appendAdditionalElement(refs, stringUsages);
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null) {
            this.appendAdditionalElement(stringUsages, variable, substituted);
            RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(substituted);
            HashMap<PsiElement, String> allRenames = new HashMap<PsiElement, String>();
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            if (currentFile != null) {
                processor2.prepareRenaming(substituted, "", allRenames, (SearchScope)new LocalSearchScope((PsiElement)currentFile));
                for (PsiElement element2 : allRenames.keySet()) {
                    this.appendAdditionalElement(stringUsages, variable, element2);
                }
            }
        }
        return showChooser;
    }

    @Override
    protected boolean shouldCreateSnapshot() {
        return false;
    }

    @Override
    protected String getRefactoringId() {
        return null;
    }

    private void appendAdditionalElement(Collection<? super Pair<PsiElement, TextRange>> stringUsages, PsiNamedElement variable, PsiElement element2) {
        PsiElement identifier;
        if (element2 != variable && element2 instanceof PsiNameIdentifierOwner && !this.notSameFile(null, element2.getContainingFile()) && (identifier = ((PsiNameIdentifierOwner)element2).getNameIdentifier()) != null) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)identifier, (Object)new TextRange(0, identifier.getTextLength())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRefactoringRename(String newName2, StartMarkAction markAction) {
        try {
            PsiNamedElement variable = this.getVariable();
            if (variable != null && !newName2.equals(this.myOldName) && this.isIdentifier(newName2, variable.getLanguage())) {
                PsiElement substituted = this.getSubstituted();
                if (substituted == null) {
                    return;
                }
                Runnable performRunnable = () -> SlowOperations.allowSlowOperations(() -> {
                    if (DumbService.isDumb((Project)this.myProject)) {
                        DumbService.getInstance((Project)this.myProject).showDumbModeNotification(RefactoringBundle.message((String)"refactoring.not.available.indexing"));
                        return;
                    }
                    String commandName2 = RefactoringBundle.message((String)"renaming.0.1.to.2", (Object[])new Object[]{UsageViewUtil.getType((PsiElement)variable), DescriptiveNameUtil.getDescriptiveName((PsiElement)variable), newName2});
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                        this.performRenameInner(substituted, newName2);
                        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    }, commandName2, null);
                });
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    performRunnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(performRunnable, this.myProject.getDisposed());
                }
            }
        }
        finally {
            try {
                ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
            }
            finally {
                FinishMarkAction.finish(this.myProject, this.myEditor, markAction);
            }
        }
    }

    protected void performRenameInner(PsiElement element2, String newName2) {
        RenameProcessor renameProcessor = this.createRenameProcessor(element2, newName2);
        for (AutomaticRenamerFactory factory2 : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
            if (factory2.getOptionName() == null || !factory2.isEnabled() || !factory2.isApplicable(element2)) continue;
            renameProcessor.addRenamerFactory(factory2);
        }
        renameProcessor.run();
    }

    protected RenameProcessor createRenameProcessor(PsiElement element2, String newName2) {
        return new MyRenameProcessor(element2, newName2);
    }

    protected void restoreCaretOffsetAfterRename() {
        if (this.myBeforeRevert != null) {
            if (!this.myEditor.isDisposed()) {
                this.myEditor.getCaretModel().moveToOffset(this.myBeforeRevert.getEndOffset());
            }
            this.myBeforeRevert.dispose();
        }
    }

    @Override
    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            MemberInplaceRenamer.$$$reportNull$$$0(5);
        }
        if (!Registry.is((String)"enable.rename.options.inplace", (boolean)true)) {
            return;
        }
        if (!RenamePsiElementProcessor.forElement((PsiElement)this.myElementToRename).isToSearchInComments((PsiElement)this.myElementToRename)) {
            return;
        }
        String stringToSearch = this.myElementToRename.getName();
        PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (!StringUtil.isEmptyOrSpaces((String)stringToSearch) && currentFile != null) {
            TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myElementToRename, (SearchScope)GlobalSearchScope.fileScope((PsiFile)currentFile), stringToSearch, true, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(psiElement, textRange) -> {
                stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
                return true;
            }));
        }
    }

    @Override
    protected void revertStateOnFinish() {
        Editor editor = InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor);
        if (editor == FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor()) {
            ((EditorImpl)editor).startDumb();
        }
        this.revertState();
    }

    @Override
    protected void navigateToAlreadyStarted(Document oldDocument, int exitCode) {
        super.navigateToAlreadyStarted(oldDocument, exitCode);
        ((EditorImpl)InjectedLanguageEditorUtil.getTopLevelEditor(this.myEditor)).stopDumbLater();
    }

    @Nullable
    public PsiElement getSubstituted() {
        PsiFile psiFile;
        if (this.mySubstituted != null && this.mySubstituted.isValid()) {
            if (this.mySubstituted instanceof PsiNameIdentifierOwner) {
                RangeMarker rangeMarker;
                if (Comparing.strEqual((String)this.myOldName, (String)((PsiNameIdentifierOwner)this.mySubstituted).getName())) {
                    return this.mySubstituted;
                }
                RangeMarker rangeMarker2 = rangeMarker = this.mySubstitutedRange != null ? this.mySubstitutedRange : this.myRenameOffset;
                if (rangeMarker != null) {
                    return PsiTreeUtil.findElementOfClassAtRange((PsiFile)this.mySubstituted.getContainingFile(), (int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset(), PsiNameIdentifierOwner.class);
                }
            }
            return this.mySubstituted;
        }
        if (this.mySubstitutedRange != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            return PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)this.mySubstitutedRange.getStartOffset(), (int)this.mySubstitutedRange.getEndOffset(), PsiNameIdentifierOwner.class);
        }
        return this.getVariable();
    }

    @Override
    public void afterTemplateStart() {
        super.afterTemplateStart();
        if (Registry.is((String)"enable.rename.options.inplace", (boolean)true)) {
            TemplateState templateState = TemplateManagerImpl.getTemplateState(this.myEditor);
            PsiNamedElement variable = this.getVariable();
            if (templateState == null || variable == null) {
                return;
            }
            TextRange variableRange = templateState.getCurrentVariableRange();
            if (variableRange == null) {
                return;
            }
            Runnable restartCallback = () -> {
                TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
                PsiNamedElement var = this.getVariable();
                if (state == null || var == null) {
                    return;
                }
                String insertedName = var.getName();
                Editor editor = state.getEditor();
                state.gotoEnd(true);
                this.createInplaceRenamerToRestart(var, editor, insertedName).performInplaceRefactoring(new LinkedHashSet<String>());
            };
            TemplateInlayUtil.createRenameSettingsInlay(templateState, variableRange.getEndOffset(), variable, restartCallback);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/inplace/MemberInplaceRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "notSameFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectAdditionalElementsToRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MyRenameProcessor
    extends RenameProcessor {
        public MyRenameProcessor(PsiElement element2, String newName2) {
            this(element2, newName2, RenamePsiElementProcessor.forElement(element2));
        }

        public MyRenameProcessor(PsiElement element2, String newName2, RenamePsiElementProcessor elementProcessor) {
            super(MemberInplaceRenamer.this.myProject, element2, newName2, elementProcessor.isToSearchInComments(element2), elementProcessor.isToSearchForTextOccurrences(element2) && TextOccurrencesUtil.isSearchTextOccurrencesEnabled(element2));
        }

        @Override
        @Nullable
        protected String getRefactoringId() {
            return "refactoring.inplace.rename";
        }

        @Override
        public void doRun() {
            try {
                super.doRun();
            }
            finally {
                MemberInplaceRenamer.this.restoreCaretOffsetAfterRename();
            }
        }
    }
}

