/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.InplaceRefactoringContinuation;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.RenameKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/refactoring/rename/inplace/InplaceRenameContinuation;", "Lcom/intellij/refactoring/InplaceRefactoringContinuation;", "targetPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "(Lcom/intellij/model/Pointer;)V", "getRefactoringKey", "", "isInvokedOnASegment", "", "templateState", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "offset", "", "resumeRefactoring", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
public final class InplaceRenameContinuation
implements InplaceRefactoringContinuation {
    private final Pointer<? extends RenameTarget> targetPointer;

    @Override
    @NotNull
    public Object getRefactoringKey() {
        return RenameElementAction.class;
    }

    @Override
    public boolean resumeRefactoring(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TemplateState templateState = TemplateManagerImpl.getTemplateState(editor);
        if (templateState == null) {
            return false;
        }
        TemplateState templateState2 = templateState;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        if (!this.isInvokedOnASegment(templateState2, caretModel.getOffset())) {
            return false;
        }
        RenameTarget renameTarget = (RenameTarget)this.targetPointer.dereference();
        if (renameTarget == null) {
            return false;
        }
        RenameTarget target2 = renameTarget;
        Object object = templateState2.getVariableValue("PrimaryVariable");
        if (object == null || (object = object.getText()) == null) {
            return false;
        }
        Object newName2 = object;
        templateState2.gotoEnd(true);
        RenameKt.showDialogAndRename(project, target2, (String)newName2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInvokedOnASegment(TemplateState templateState, int offset) {
        int n = 0;
        int n2 = templateState.getSegmentsCount();
        while (n < n2) {
            void i2;
            TextRange segmentRange = templateState.getSegmentRange((int)i2);
            if (segmentRange.containsOffset(offset)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public InplaceRenameContinuation(@NotNull Pointer<? extends RenameTarget> targetPointer) {
        Intrinsics.checkNotNullParameter(targetPointer, (String)"targetPointer");
        this.targetPointer = targetPointer;
    }
}

