/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.model.Pointer;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.SearchWordQueryBuilder;
import com.intellij.model.search.TextOccurrence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.rename.api.ModifiableRenameUsage;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageFileUpdaters;
import com.intellij.refactoring.rename.api.ReplaceTextTarget;
import com.intellij.refactoring.rename.api.ReplaceTextTargetContext;
import com.intellij.refactoring.rename.impl.DefaultRenameUsageSearchParameters;
import com.intellij.refactoring.rename.impl.RenameOptions;
import com.intellij.refactoring.rename.impl.SearchKt;
import com.intellij.refactoring.rename.impl.TextRenameUsage;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.util.Query;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002j\u0002`\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a6\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a(\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aM\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00012\u0006\u0010 \u001a\u00020!2'\u0010\"\u001a#\u0012\u0013\u0012\u00110!\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0006\u0012\u0004\u0018\u00010!0#j\u0002`'H\u0002\u00a8\u0006("}, d2={"buildQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "Lcom/intellij/refactoring/rename/impl/UsagePointer;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "options", "Lcom/intellij/refactoring/rename/impl/RenameOptions;", "buildTextResultsQueries", "", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "context", "Lcom/intellij/refactoring/rename/api/ReplaceTextTargetContext;", "buildUsageQuery", "hasReferences", "", "occurrence", "Lcom/intellij/model/search/TextOccurrence;", "hasResolvableReferences", "inComment", "inString", "searchRenameUsages", "walkUp", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "", "mapToUsages", "searchString", "", "textReplacement", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "newName", "Lcom/intellij/refactoring/rename/api/TextReplacement;", "intellij.platform.lang.impl"})
public final class SearchKt {
    @NotNull
    public static final Query<Pointer<? extends RenameUsage>> buildQuery(@NotNull Project project, @NotNull RenameTarget target2, @NotNull RenameOptions options2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Query query2 = SearchKt.buildUsageQuery(project, target2, options2).mapping((Function)buildQuery.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"buildUsageQuery(project,\u2026   it.createPointer()\n  }");
        return query2;
    }

    @NotNull
    public static final Query<? extends RenameUsage> buildUsageQuery(@NotNull Project project, @NotNull RenameTarget target2, @NotNull RenameOptions options2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList queries = new ArrayList();
        Collection collection = queries;
        Object object = SearchKt.searchRenameUsages(project, target2, options2.getSearchScope());
        boolean bl = false;
        collection.add(object);
        if (Intrinsics.areEqual((Object)options2.getRenameTextOccurrences(), (Object)true)) {
            collection = queries;
            object = SearchKt.buildTextResultsQueries(project, target2, options2.getSearchScope(), ReplaceTextTargetContext.IN_PLAIN_TEXT);
            bl = false;
            CollectionsKt.addAll((Collection)collection, object);
        }
        if (Intrinsics.areEqual((Object)options2.getRenameCommentsStringsOccurrences(), (Object)true)) {
            collection = queries;
            object = SearchKt.buildTextResultsQueries(project, target2, options2.getSearchScope(), ReplaceTextTargetContext.IN_COMMENTS_AND_STRINGS);
            bl = false;
            CollectionsKt.addAll((Collection)collection, object);
        }
        Query query2 = SearchService.getInstance().merge((List)queries);
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"SearchService.getInstance().merge(queries)");
        return query2;
    }

    private static final Query<? extends RenameUsage> searchRenameUsages(Project project, RenameTarget target2, SearchScope searchScope2) {
        Query query2 = SearchService.getInstance().searchParameters((SearchParameters)new DefaultRenameUsageSearchParameters(project, target2, searchScope2));
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"SearchService.getInstanc\u2026 target, searchScope)\n  )");
        return query2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Query<? extends RenameUsage>> buildTextResultsQueries(Project project, RenameTarget target2, SearchScope searchScope2, ReplaceTextTargetContext context) {
        Collection<ReplaceTextTarget> replaceTextTargets = target2.textTargets(context);
        ArrayList result2 = new ArrayList(replaceTextTargets.size());
        for (ReplaceTextTarget replaceTextTarget : replaceTextTargets) {
            boolean bl;
            Query<? extends RenameUsage> query2;
            SearchWordQueryBuilder queryBuilder;
            Collection collection;
            String searchString;
            SearchScope searchScope3;
            void searchRequest;
            Function1<String, String> textReplacement;
            block6: {
                block5: {
                    SearchRequest searchRequest2 = replaceTextTarget.component1();
                    textReplacement = replaceTextTarget.component2();
                    searchScope3 = searchRequest.getSearchScope();
                    if (searchScope3 == null) break block5;
                    SearchScope searchScope4 = searchScope3;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    SearchScope p1 = searchScope4;
                    boolean bl4 = false;
                    searchScope3 = searchScope2.intersectWith(p1);
                    if (searchScope3 != null) break block6;
                }
                searchScope3 = searchScope2;
            }
            SearchScope effectiveSearchScope = searchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)searchRequest.getSearchString(), (String)"searchRequest.searchString");
            Intrinsics.checkNotNullExpressionValue((Object)SearchService.getInstance().searchWord(project, searchString).inScope(effectiveSearchScope).includeInjections(), (String)"SearchService.getInstanc\u2026     .includeInjections()");
            if (context == ReplaceTextTargetContext.IN_PLAIN_TEXT) {
                collection = result2;
                Query query3 = queryBuilder.inContexts(SearchContext.IN_PLAIN_TEXT, new SearchContext[0]).buildLeafOccurrenceQuery().filtering((Predicate)buildTextResultsQueries.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)query3, (String)"queryBuilder\n        .in\u2026ng { !hasReferences(it) }");
                query2 = SearchKt.mapToUsages((Query<? extends TextOccurrence>)query3, searchString, textReplacement);
                bl = false;
                collection.add(query2);
                continue;
            }
            collection = result2;
            Query query4 = queryBuilder.inContexts(SearchContext.IN_COMMENTS, new SearchContext[0]).buildLeafOccurrenceQuery().filtering((Predicate)buildTextResultsQueries.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"queryBuilder\n        .in\u2026) && !hasReferences(it) }");
            query2 = SearchKt.mapToUsages((Query<? extends TextOccurrence>)query4, searchString, textReplacement);
            bl = false;
            collection.add(query2);
            collection = result2;
            Query query5 = queryBuilder.inContexts(SearchContext.IN_STRINGS, new SearchContext[0]).buildLeafOccurrenceQuery().filtering((Predicate)buildTextResultsQueries.3.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)query5, (String)"queryBuilder\n        .in\u2026esolvableReferences(it) }");
            query2 = SearchKt.mapToUsages((Query<? extends TextOccurrence>)query5, searchString, textReplacement);
            bl = false;
            collection.add(query2);
        }
        return result2;
    }

    private static final boolean inComment(TextOccurrence occurrence) {
        Iterator<Pair<PsiElement, Integer>> iterator2 = SearchKt.walkUp(occurrence);
        boolean bl = false;
        Iterator<Pair<PsiElement, Integer>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Pair<PsiElement, Integer> pair = iterator3.next();
            PsiElement element2 = (PsiElement)pair.component1();
            if (!CommentUtilCore.isCommentTextElement(element2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean inString(TextOccurrence occurrence) {
        Iterator<Pair<PsiElement, Integer>> iterator2 = SearchKt.walkUp(occurrence);
        boolean bl = false;
        Iterator<Pair<PsiElement, Integer>> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Pair<PsiElement, Integer> pair = iterator3.next();
            PsiElement element2 = (PsiElement)pair.component1();
            if (!TextOccurrencesUtilBase.isStringLiteralElement(element2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReferences(TextOccurrence occurrence) {
        PsiElement psiElement = SearchKt.walkUp(occurrence);
        boolean bl = false;
        PsiElement psiElement2 = psiElement;
        while (psiElement2.hasNext()) {
            void element2;
            Pair<PsiElement, Integer> pair = psiElement2.next();
            psiElement = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            if (!ReferencesKt.hasReferencesInElement((PsiElement)element2, offsetInElement)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasResolvableReferences(TextOccurrence occurrence) {
        PsiElement psiElement = SearchKt.walkUp(occurrence);
        boolean bl = false;
        PsiElement psiElement2 = psiElement;
        while (psiElement2.hasNext()) {
            void element2;
            Pair<PsiElement, Integer> pair = psiElement2.next();
            psiElement = (PsiElement)pair.component1();
            int offsetInElement = ((Number)pair.component2()).intValue();
            for (PsiSymbolReference reference2 : ReferencesKt.allReferencesInElement((PsiElement)element2, offsetInElement)) {
                Collection collection;
                Intrinsics.checkNotNullExpressionValue((Object)reference2.resolveReference(), (String)"reference.resolveReference()");
                boolean bl2 = false;
                if (!(!collection.isEmpty())) continue;
                return true;
            }
        }
        return false;
    }

    private static final Iterator<Pair<PsiElement, Integer>> walkUp(TextOccurrence occurrence) {
        PsiElement psiElement = occurrence.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"occurrence.element");
        return PsiTreeUtilKt.walkUp((PsiElement)psiElement, (int)occurrence.getOffsetInElement());
    }

    private static final Query<? extends RenameUsage> mapToUsages(Query<? extends TextOccurrence> $this$mapToUsages, String searchString, Function1<? super String, String> textReplacement) {
        ModifiableRenameUsage.FileUpdater fileUpdater = RenameUsageFileUpdaters.fileRangeUpdater(textReplacement);
        Query query2 = $this$mapToUsages.mapping((Function)new Function<TextOccurrence, TextRenameUsage>(searchString, fileUpdater){
            final /* synthetic */ String $searchString;
            final /* synthetic */ ModifiableRenameUsage.FileUpdater $fileUpdater;

            public final TextRenameUsage apply(@NotNull TextOccurrence occurrence) {
                Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
                TextRange textRange = TextRange.from((int)occurrence.getOffsetInElement(), (int)this.$searchString.length());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(occurrenc\u2026ent, searchString.length)");
                TextRange rangeInElement = textRange;
                PsiElement psiElement = occurrence.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"occurrence.element");
                return new TextRenameUsage(PsiUsage.Companion.textUsage(psiElement, rangeInElement), this.$fileUpdater);
            }
            {
                this.$searchString = string;
                this.$fileUpdater = fileUpdater;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"mapping { occurrence: Te\u2026lement), fileUpdater)\n  }");
        return query2;
    }

    public static final /* synthetic */ boolean access$hasReferences(TextOccurrence occurrence) {
        return SearchKt.hasReferences(occurrence);
    }

    public static final /* synthetic */ boolean access$inComment(TextOccurrence occurrence) {
        return SearchKt.inComment(occurrence);
    }

    public static final /* synthetic */ boolean access$inString(TextOccurrence occurrence) {
        return SearchKt.inString(occurrence);
    }

    public static final /* synthetic */ boolean access$hasResolvableReferences(TextOccurrence occurrence) {
        return SearchKt.hasResolvableReferences(occurrence);
    }
}

