/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011Ba\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0010R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates;", "", "filesToAdd", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "", "filesToMove", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToRemove", "documentModifications", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "doUpdate", "", "preview", "", "Companion", "intellij.platform.lang.impl"})
public final class FileUpdates {
    private final List<Pair<Path, CharSequence>> filesToAdd;
    private final List<Pair<VirtualFile, Path>> filesToMove;
    private final List<VirtualFile> filesToRemove;
    private final List<Pair<RangeMarker, CharSequence>> documentModifications;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void doUpdate() {
        Path virtualFile;
        VirtualFile document;
        Map byDocument;
        Map $this$groupByTo$iv$iv;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (VirtualFile virtualFile2 : this.filesToRemove) {
            if (!virtualFile2.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to remove. File: " + virtualFile2);
                continue;
            }
            virtualFile2.delete((Object)this);
        }
        Iterable iterable = this.documentModifications;
        boolean $i$f$groupBy = false;
        Iterable iterable2 = iterable;
        Map destination$iv$iv232 = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Pair $dstr$rangeMarker$_u24__u24 = (Pair)element$iv$iv;
            boolean bl = false;
            RangeMarker rangeMarker = (RangeMarker)$dstr$rangeMarker$_u24__u24.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv232;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupByTo$iv$iv = byDocument = destination$iv$iv232;
        boolean destination$iv$iv232 = false;
        Iterator iterator3 = $this$groupByTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry entry;
            Map.Entry $i$f$groupByTo22 = entry = iterator3.next();
            boolean bl = false;
            $this$groupByTo$iv$iv = (Document)$i$f$groupByTo22.getKey();
            $i$f$groupByTo22 = entry;
            bl = false;
            List modifications = (List)$i$f$groupByTo22.getValue();
            DocumentUtil.executeInBulk((Document)document, true, new Runnable(modifications, (Document)document){
                final /* synthetic */ List $modifications;
                final /* synthetic */ Document $document;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    for (Pair pair : this.$modifications) {
                        void rangeMarker;
                        RangeMarker rangeMarker2 = (RangeMarker)pair.component1();
                        CharSequence replacement = (CharSequence)pair.component2();
                        if (!rangeMarker.isValid()) {
                            FileUpdates.Companion.getLOG$intellij_platform_lang_impl().warn("Cannot apply rename patch: invalid range marker. Document: " + this.$document + ", marker: " + rangeMarker);
                            continue;
                        }
                        this.$document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), replacement);
                        rangeMarker.dispose();
                    }
                }
                {
                    this.$modifications = list2;
                    this.$document = document;
                }
            });
        }
        for (Pair pair : this.filesToMove) {
            VirtualFile parentFile;
            Path parentPath;
            document = (VirtualFile)pair.component1();
            Path path = (Path)pair.component2();
            if (!virtualFile.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to move. File: " + virtualFile);
                continue;
            }
            if (path.getParent() == null) {
                continue;
            }
            if (VfsUtil.findFile((Path)parentPath, (boolean)false) == null) {
                continue;
            }
            virtualFile.move(this, parentFile);
            String newFileName = ((Object)path.getFileName()).toString();
            if (!(Intrinsics.areEqual((Object)virtualFile.getName(), (Object)newFileName) ^ true)) continue;
            virtualFile.rename(this, newFileName);
        }
        for (Pair pair : this.filesToAdd) {
            void path;
            virtualFile = (Path)pair.component1();
            CharSequence content2 = (CharSequence)pair.component2();
            PathKt.write$default((Path)path, (CharSequence)content2, null, (boolean)false, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, CharSequence> preview() {
        Object $this$getOrPut$iv232;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Iterable $this$groupBy$iv = this.documentModifications;
        boolean bl = false;
        Map.Entry entry22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Pair $dstr$rangeMarker$_u24__u24 = (Pair)element$iv$iv;
            boolean bl2 = false;
            RangeMarker rangeMarker = (RangeMarker)$dstr$rangeMarker$_u24__u24.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map byDocument = destination$iv$iv;
        HashMap documentOperations = new HashMap(byDocument.size());
        destination$iv$iv = byDocument;
        $i$f$groupByTo = false;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            Object object;
            void document;
            void $this$mapNotNullTo$iv$iv;
            Object object2 = entry;
            boolean element$iv$iv = false;
            destination$iv$iv = (Document)object2.getKey();
            object2 = entry;
            element$iv$iv = false;
            List modifications = (List)object2.getValue();
            Object $this$mapNotNull$iv = modifications;
            boolean $i$f$mapNotNull = false;
            Iterable bl2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            value$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (value$iv$iv$iv.hasNext()) {
                StringOperation stringOperation;
                void rangeMarker;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = value$iv$iv$iv.next();
                boolean bl3 = false;
                Pair $dstr$rangeMarker$replacement = (Pair)element$iv$iv2;
                boolean bl4 = false;
                RangeMarker rangeMarker2 = (RangeMarker)$dstr$rangeMarker$replacement.component1();
                CharSequence replacement = (CharSequence)$dstr$rangeMarker$replacement.component2();
                if (UtilsKt.getRange((RangeMarker)rangeMarker) != null) {
                    TextRange textRange;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    TextRange range2 = textRange;
                    boolean bl7 = false;
                    stringOperation = StringOperation.replace((TextRange)range2, (CharSequence)replacement);
                } else {
                    stringOperation = null;
                }
                if (stringOperation == null) continue;
                StringOperation stringOperation2 = stringOperation;
                boolean bl8 = false;
                boolean bl9 = false;
                StringOperation it$iv$iv = stringOperation2;
                boolean bl10 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List operations = (List)destination$iv$iv2;
            if (document instanceof DocumentWindow) {
                void $this$flatMapTo$iv$iv;
                Object object3;
                Document key$iv;
                Collection $this$getOrPut$iv;
                $this$mapNotNull$iv = documentOperations;
                Intrinsics.checkNotNullExpressionValue((Object)((DocumentWindow)document).getDelegate(), (String)"document.delegate");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl11 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                $this$getOrPut$iv = (List)object3;
                Iterable $this$flatMap$iv = operations;
                boolean $i$f$flatMap = false;
                value$iv = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
                    TextRange range3;
                    StringOperation operation2 = (StringOperation)element$iv$iv3;
                    boolean bl12 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)operation2.getRange(), (String)"operation.range");
                    Iterable list$iv$iv = ((DocumentWindow)document).prepareReplaceString(range3.getStartOffset(), range3.getEndOffset(), operation2.getReplacement());
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv3;
                $i$f$flatMap = false;
                CollectionsKt.addAll((Collection)$this$getOrPut$iv, (Iterable)$this$flatMap$iv);
                continue;
            }
            $this$getOrPut$iv232 = documentOperations;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv232.get(document);
            if (value$iv == null) {
                boolean bl13 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv232.put(document, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            $this$getOrPut$iv232 = (List)object;
            boolean bl14 = false;
            CollectionsKt.addAll((Collection)$this$getOrPut$iv232, (Iterable)operations);
        }
        HashMap hashMap = new HashMap(byDocument.size());
        Map modifications = documentOperations;
        boolean operations = false;
        for (Map.Entry entry22 : modifications.entrySet()) {
            void document;
            $this$getOrPut$iv232 = entry22;
            boolean bl3 = false;
            modifications = (Document)$this$getOrPut$iv232.getKey();
            $this$getOrPut$iv232 = entry22;
            bl3 = false;
            List operations2 = (List)$this$getOrPut$iv232.getValue();
            boolean $this$getOrPut$iv232 = !(document instanceof DocumentWindow);
            bl3 = false;
            boolean bl15 = false;
            bl15 = false;
            boolean bl16 = false;
            if (!$this$getOrPut$iv232) {
                boolean bl17 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)document);
            bl15 = false;
            bl16 = false;
            bl16 = false;
            boolean bl18 = false;
            if (virtualFile == null) {
                boolean bl19 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            VirtualFile virtualFile2 = virtualFile;
            Map map2 = hashMap;
            CharSequence charSequence = StringOperation.applyOperations((CharSequence)document.getCharsSequence(), (Collection)operations2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"StringOperation.applyOpe\u2026harsSequence, operations)");
            map2.put(virtualFile2, charSequence);
        }
        return hashMap;
    }

    public FileUpdates(@NotNull List<? extends Pair<? extends Path, ? extends CharSequence>> filesToAdd, @NotNull List<? extends Pair<? extends VirtualFile, ? extends Path>> filesToMove, @NotNull List<? extends VirtualFile> filesToRemove, @NotNull List<? extends Pair<? extends RangeMarker, ? extends CharSequence>> documentModifications) {
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(filesToMove, (String)"filesToMove");
        Intrinsics.checkNotNullParameter(filesToRemove, (String)"filesToRemove");
        Intrinsics.checkNotNullParameter(documentModifications, (String)"documentModifications");
        this.filesToAdd = filesToAdd;
        this.filesToMove = filesToMove;
        this.filesToRemove = filesToRemove;
        this.documentModifications = documentModifications;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileUpdates.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileUpdates::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_lang_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "merge", "Lcom/intellij/refactoring/rename/impl/FileUpdates;", "left", "right", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_lang_impl() {
            return LOG;
        }

        @Nullable
        public final FileUpdates merge(@Nullable FileUpdates left, @Nullable FileUpdates right) {
            return left == null ? right : (right == null ? left : new FileUpdates(CollectionsKt.plus((Collection)left.filesToAdd, (Iterable)right.filesToAdd), CollectionsKt.plus((Collection)left.filesToMove, (Iterable)right.filesToMove), CollectionsKt.plus((Collection)left.filesToRemove, (Iterable)right.filesToRemove), CollectionsKt.plus((Collection)left.documentModifications, (Iterable)right.documentModifications)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

