/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static final String REFACTORING_NAME = "Move";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiReference reference2;
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            element2 = file2;
        }
        if ((reference2 = MoveHandler.findReferenceAtCaret(element2, offset)) != null) {
            PsiElement refElement = reference2.resolve();
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (refElement == null || !delegate2.tryToMove(refElement, project, dataContext, reference2, editor)) continue;
                MoveHandler.logDelegate(project, delegate2, refElement.getLanguage());
                return;
            }
        }
        List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
        while (true) {
            if (element2 == null) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)MoveHandler.getRefactoringName(), null);
                return;
            }
            for (MoveHandlerDelegate delegate2 : candidateHandlers) {
                if (!delegate2.tryToMove(element2, project, dataContext, null, editor)) continue;
                MoveHandler.logDelegate(project, delegate2, element2.isValid() ? element2.getLanguage() : null);
                return;
            }
            element2 = element2.getParent();
        }
    }

    private static void logDelegate(@NotNull Project project, @NotNull MoveHandlerDelegate delegate2, @Nullable Language language) {
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(1);
        }
        if (delegate2 == null) {
            MoveHandler.$$$reportNull$$$0(2);
        }
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(language).addData("handler", delegate2.getClass().getName());
        FUCounterUsageLogger.getInstance().logEvent(project, "move.refactoring", "handler.invoked", data2);
    }

    private static PsiReference findReferenceAtCaret(PsiElement element2, int caretOffset) {
        TextRange range2 = element2.getTextRange();
        if (range2 != null) {
            int relative = caretOffset - range2.getStartOffset();
            return element2.findReferenceAt(relative);
        }
        return null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(4);
        }
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(dataContext) || !delegate2.isValidTarget(targetContainer, elements)) continue;
            delegate2.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
        }
        if (!filesOrDirs.isEmpty()) {
            for (PsiElement element2 : elements) {
                if (element2 instanceof PsiDirectory) {
                    filesOrDirs.add(element2);
                    continue;
                }
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add((PsiElement)containingFile);
            }
            FUCounterUsageLogger.getInstance().logEvent(project, "move.refactoring", "move.files.or.directories");
            MoveFilesOrDirectoriesUtil.doMove(project, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project, elements, targetContainer, dataContext, null);
    }

    public static void doMove(Project project, PsiElement @NotNull [] elements, PsiElement targetContainer, DataContext dataContext, MoveCallback callback2) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(5);
        }
        if (elements.length == 0) {
            return;
        }
        SlowOperations.allowSlowOperations(() -> {
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.canMove(elements, targetContainer, null)) continue;
                MoveHandler.logDelegate(project, delegate2, elements[0].getLanguage());
                delegate2.doMove(project, elements, delegate2.adjustTargetForMove(dataContext, targetContainer), callback2);
                break;
            }
        });
    }

    public static PsiElement @Nullable [] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(sourceElements, targetElement, null)) continue;
            return delegate2.adjustForMove(project, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(PsiElement @NotNull [] elements, PsiElement targetContainer) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(6);
        }
        return MoveHandler.findDelegate(elements, targetContainer, null) != null;
    }

    @Nullable
    private static MoveHandlerDelegate findDelegate(PsiElement @NotNull [] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference2) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(7);
        }
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(elements, targetContainer, reference2)) continue;
            return delegate2;
        }
        return null;
    }

    @Nullable
    @NlsActions.ActionText
    public static String getActionName(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            MoveHandler.$$$reportNull$$$0(8);
        }
        if ((editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR)) != null) {
            MoveHandlerDelegate refDelegate;
            PsiElement refElement;
            PsiReference reference2;
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return null;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement element2 = file2.findElementAt(editor.getCaretModel().getOffset());
            if (element2 == null) {
                element2 = file2;
            }
            if ((reference2 = MoveHandler.findReferenceAtCaret(element2, editor.getCaretModel().getOffset())) != null && (refElement = reference2.resolve()) != null && (refDelegate = MoveHandler.findDelegate(new PsiElement[]{refElement}, null, reference2)) != null) {
                return refDelegate.getActionName(new PsiElement[]{refElement});
            }
            List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
            while (element2 != null) {
                PsiElement[] elementArray = new PsiElement[]{element2};
                for (MoveHandlerDelegate handler2 : candidateHandlers) {
                    if (!handler2.canMove(elementArray, null, reference2)) continue;
                    return handler2.getActionName(elementArray);
                }
                element2 = element2.getParent();
            }
            return null;
        }
        PsiElement[] elements = BaseRefactoringAction.getPsiElementArray(dataContext);
        List delegates = MoveHandlerDelegate.EP_NAME.getExtensionList();
        for (MoveHandlerDelegate delegate2 : delegates) {
            if (!delegate2.canMove(elements, null, null)) continue;
            return delegate2.getActionName(elements);
        }
        return null;
    }

    @NotNull
    private static List<MoveHandlerDelegate> findHandlersForLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            MoveHandler.$$$reportNull$$$0(9);
        }
        List list2 = ContainerUtil.filter((Collection)MoveHandlerDelegate.EP_NAME.getExtensionList(), delegate2 -> delegate2.supportsLanguage(element2.getLanguage()));
        if (list2 == null) {
            MoveHandler.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate2.isValidTarget(psiElement, elements)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        for (MoveHandlerDelegate delegate2 : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.isMoveRedundant(source, target2)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/MoveHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findHandlersForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logDelegate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canMove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findHandlersForLanguage";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

