/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanDialog;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanHandler
implements RefactoringActionHandler {
    public static final String INVERT_BOOLEAN_HELP_ID = "refactoring.invertBoolean";
    private static final Logger LOG = Logger.getInstance(InvertBooleanHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        InvertBooleanDelegate delegate2;
        if (project == null) {
            InvertBooleanHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element2 == null) {
            element2 = file2.findElementAt(editor.getCaretModel().getOffset());
        }
        if ((delegate2 = InvertBooleanHandler.findDelegate(element2, project, editor)) == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)InvertBooleanHandler.getRefactoringName(), (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        PsiElement namedElement = delegate2.adjustElement(element2, project, editor);
        if (namedElement != null && PsiElementRenameHandler.canRename(project, editor, namedElement)) {
            new InvertBooleanDialog(namedElement).show();
        }
    }

    public static InvertBooleanDelegate findDelegate(PsiElement element2, Project project, Editor editor) {
        for (InvertBooleanDelegate delegate2 : InvertBooleanDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.isVisibleOnElement(element2)) continue;
            return delegate2;
        }
        return null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            InvertBooleanHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            InvertBooleanHandler.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(elements.length == 1);
        InvertBooleanDelegate delegate2 = InvertBooleanHandler.findDelegate(elements[0], project, null);
        if (delegate2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)InvertBooleanHandler.getRefactoringName(), (String)INVERT_BOOLEAN_HELP_ID);
            return;
        }
        PsiElement element2 = delegate2.adjustElement(elements[0], project, null);
        if (element2 != null && PsiElementRenameHandler.canRename(project, null, element2)) {
            new InvertBooleanDialog(element2).show();
        }
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"invert.boolean.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/invertBoolean/InvertBooleanHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

