/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class OccurrencesChooser<T> {
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;

    public static <T extends PsiElement> OccurrencesChooser<T> simpleChooser(Editor editor) {
        return new OccurrencesChooser<T>(editor){

            @Override
            protected TextRange getOccurrenceRange(T occurrence) {
                return occurrence.getTextRange();
            }
        };
    }

    public OccurrencesChooser(Editor editor) {
        this.myEditor = editor;
    }

    public void showChooser(T selectedOccurrence, List<T> allOccurrences, Pass<? super ReplaceChoice> callback2) {
        if (allOccurrences.size() == 1) {
            callback2.pass((Object)ReplaceChoice.ALL);
        } else {
            LinkedHashMap<ReplaceChoice, List<T>> occurrencesMap = new LinkedHashMap<ReplaceChoice, List<T>>();
            occurrencesMap.put(ReplaceChoice.NO, Collections.singletonList(selectedOccurrence));
            occurrencesMap.put(ReplaceChoice.ALL, allOccurrences);
            this.showChooser(callback2, occurrencesMap);
        }
    }

    public void showChooser(Pass<? super ReplaceChoice> callback2, Map<ReplaceChoice, List<T>> occurrencesMap) {
        this.showChooser(callback2, occurrencesMap, RefactoringBundle.message((String)"replace.multiple.occurrences.found"));
    }

    public <C extends BaseReplaceChoice> void showChooser(Pass<? super C> callback2, final Map<C, List<T>> occurrencesMap, @Nls String title) {
        if (occurrencesMap.size() == 1) {
            callback2.pass(occurrencesMap.keySet().iterator().next());
            return;
        }
        ArrayList<C> model2 = new ArrayList<C>(occurrencesMap.keySet());
        JBPopupFactory.getInstance().createPopupChooserBuilder(model2).setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value2, index2, isSelected, cellHasFocus);
                BaseReplaceChoice choices = (BaseReplaceChoice)value2;
                if (choices != null) {
                    this.setText(choices.formatDescription(((List)occurrencesMap.get(choices)).size()));
                }
                return rendererComponent;
            }
        }).setItemSelectedCallback(value2 -> {
            if (value2 == null) {
                return;
            }
            this.dropHighlighters();
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            List occurrenceList = (List)occurrencesMap.get(value2);
            for (Object occurrence : occurrenceList) {
                TextRange textRange = this.getOccurrenceRange(occurrence);
                RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
                this.myRangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle(title).setMovable(true).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> callback2.pass(arg_0)).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                OccurrencesChooser.this.dropHighlighters();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/introduce/inplace/OccurrencesChooser$2", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    protected abstract TextRange getOccurrenceRange(T var1);

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    public static enum ReplaceChoice implements BaseReplaceChoice
    {
        NO,
        NO_WRITE,
        ALL;


        @Override
        public boolean isAll() {
            return this != NO;
        }

        @Override
        @Nls
        public String formatDescription(int occurrencesCount) {
            switch (this) {
                case NO: {
                    return RefactoringBundle.message((String)"replace.this.occurrence.only");
                }
                case NO_WRITE: {
                    return RefactoringBundle.message((String)"replace.all.occurrences.but.write");
                }
                case ALL: {
                    return RefactoringBundle.message((String)"replace.all.occurrences", (Object[])new Object[]{occurrencesCount});
                }
            }
            throw new IllegalStateException("Unexpected value: " + this);
        }
    }

    public static interface BaseReplaceChoice {
        public boolean isAll();

        @Nls
        public String formatDescription(int var1);
    }
}

