/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class ExtractMethodHelper {
    public static void processDuplicates(final @NotNull PsiElement callElement, final @NotNull PsiElement generatedMethod, final @NotNull List<PsiElement> scope, final @NotNull SimpleDuplicatesFinder finder, final @NotNull Editor editor, final @NotNull Consumer<? super Pair<SimpleMatch, PsiElement>> replacer) {
        if (callElement == null) {
            ExtractMethodHelper.$$$reportNull$$$0(0);
        }
        if (generatedMethod == null) {
            ExtractMethodHelper.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ExtractMethodHelper.$$$reportNull$$$0(2);
        }
        if (finder == null) {
            ExtractMethodHelper.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ExtractMethodHelper.$$$reportNull$$$0(4);
        }
        if (replacer == null) {
            ExtractMethodHelper.$$$reportNull$$$0(5);
        }
        finder.setReplacement(callElement);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExtractMethodHelper.replaceDuplicates(callElement, editor, replacer, finder.findDuplicates(scope, generatedMethod));
            return;
        }
        Project project = callElement.getProject();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, RefactoringBundle.message((String)"searching.for.duplicates"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.myProject == null || this.myProject.isDisposed()) {
                    return;
                }
                List duplicates = (List)ReadAction.compute(() -> finder.findDuplicates(scope, generatedMethod));
                ApplicationManager.getApplication().invokeLater(() -> ExtractMethodHelper.replaceDuplicates(callElement, editor, (Consumer<? super Pair<SimpleMatch, PsiElement>>)replacer, duplicates));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/ExtractMethodHelper$1", "run"));
            }
        });
    }

    @NotNull
    public static List<SimpleMatch> collectDuplicates(@NotNull SimpleDuplicatesFinder finder, @NotNull List<PsiElement> searchScopes, @NotNull PsiElement generatedMethod) {
        List list2;
        if (finder == null) {
            ExtractMethodHelper.$$$reportNull$$$0(6);
        }
        if (searchScopes == null) {
            ExtractMethodHelper.$$$reportNull$$$0(7);
        }
        if (generatedMethod == null) {
            ExtractMethodHelper.$$$reportNull$$$0(8);
        }
        Project project = generatedMethod.getProject();
        try {
            list2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                return (List)ReadAction.compute(() -> finder.findDuplicates(searchScopes, generatedMethod));
            }, RefactoringBundle.message((String)"searching.for.duplicates"), true, project);
        }
        catch (ProcessCanceledException e) {
            List<SimpleMatch> list3 = Collections.emptyList();
            if (list3 == null) {
                ExtractMethodHelper.$$$reportNull$$$0(10);
            }
            return list3;
        }
        if (list2 == null) {
            ExtractMethodHelper.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public static void replaceDuplicates(@NotNull PsiElement callElement, @NotNull Editor editor, @NotNull Consumer<? super Pair<SimpleMatch, PsiElement>> replacer, @NotNull List<? extends SimpleMatch> duplicates) {
        if (callElement == null) {
            ExtractMethodHelper.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            ExtractMethodHelper.$$$reportNull$$$0(12);
        }
        if (replacer == null) {
            ExtractMethodHelper.$$$reportNull$$$0(13);
        }
        if (duplicates == null) {
            ExtractMethodHelper.$$$reportNull$$$0(14);
        }
        if (!duplicates.isEmpty()) {
            int exitCode;
            String message2 = RefactoringBundle.message((String)"0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.method", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()});
            boolean isUnittest = ApplicationManager.getApplication().isUnitTestMode();
            boolean isPerformanceScript = System.getProperty("testscript.filename") != null;
            Project project = callElement.getProject();
            int n = exitCode = !isUnittest && !isPerformanceScript ? Messages.showYesNoDialog((Project)project, (String)message2, (String)RefactoringBundle.message((String)"refactoring.extract.method.dialog.title"), (Icon)Messages.getInformationIcon()) : 0;
            if (exitCode == 0) {
                boolean replaceAll = false;
                HashMap<SimpleMatch, RangeHighlighter> highlighterMap = new HashMap<SimpleMatch, RangeHighlighter>();
                for (SimpleMatch simpleMatch : duplicates) {
                    if (!simpleMatch.getStartElement().isValid() || !simpleMatch.getEndElement().isValid()) continue;
                    Pair replacement = Pair.create((Object)simpleMatch, (Object)callElement);
                    if (!replaceAll) {
                        ExtractMethodHelper.highlightInEditor(project, simpleMatch, editor, highlighterMap);
                        int promptResult = 3;
                        if (!isUnittest && !isPerformanceScript) {
                            ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"replace.fragment"), project);
                            promptDialog.show();
                            promptResult = promptDialog.getExitCode();
                        }
                        if (promptResult == 2) {
                            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                            RangeHighlighter highlighter = (RangeHighlighter)highlighterMap.get(simpleMatch);
                            if (highlighter == null) continue;
                            highlightManager.removeSegmentHighlighter(editor, highlighter);
                            continue;
                        }
                        if (promptResult == 1) break;
                        if (promptResult == 0) {
                            ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                            continue;
                        }
                        if (promptResult != 3) continue;
                        ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                        replaceAll = true;
                        continue;
                    }
                    ExtractMethodHelper.replaceDuplicate(project, replacer, (Pair<SimpleMatch, PsiElement>)replacement);
                }
            }
        }
    }

    private static void replaceDuplicate(Project project, Consumer<? super Pair<SimpleMatch, PsiElement>> replacer, Pair<SimpleMatch, PsiElement> replacement) {
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> replacer.consume((Object)replacement)), RefactoringBundle.message((String)"extract.method.replace.duplicate.command.name"), null);
    }

    private static void highlightInEditor(@NotNull Project project, @NotNull SimpleMatch match2, @NotNull Editor editor, Map<SimpleMatch, RangeHighlighter> highlighterMap) {
        if (project == null) {
            ExtractMethodHelper.$$$reportNull$$$0(15);
        }
        if (match2 == null) {
            ExtractMethodHelper.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            ExtractMethodHelper.$$$reportNull$$$0(17);
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        int startOffset = match2.getStartElement().getTextRange().getStartOffset();
        int endOffset = match2.getEndElement().getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
        highlighterMap.put(match2, (RangeHighlighter)highlighters.get(0));
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 4: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopes";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodHelper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodHelper";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDuplicates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectDuplicates";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceDuplicates";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

