/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.ide.TwoPaneIdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.copy.CopyHandlerDelegate;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyHandler {
    private CopyHandler() {
    }

    public static boolean canCopy(PsiElement[] elements) {
        return CopyHandler.canCopy(elements, null);
    }

    public static boolean canCopy(PsiElement[] elements, @Nullable Ref<@NlsActions.ActionText String> actionName) {
        if (elements.length > 0) {
            for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate2 instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate2).canCopy(elements, true) : delegate2.canCopy(elements))) continue;
                if (actionName != null) {
                    actionName.set((Object)delegate2.getActionName(elements));
                }
                return true;
            }
        }
        return false;
    }

    public static void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        if (elements.length == 0) {
            return;
        }
        for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canCopy(elements)) continue;
            delegate2.doCopy(elements, defaultTargetDirectory);
            break;
        }
    }

    public static boolean canClone(PsiElement[] elements) {
        if (elements.length > 0) {
            for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!(delegate2 instanceof CopyHandlerDelegateBase ? ((CopyHandlerDelegateBase)delegate2).canCopy(elements, true) : delegate2.canCopy(elements))) continue;
                return !(delegate2 instanceof CopyHandlerDelegateBase) || !((CopyHandlerDelegateBase)delegate2).forbidToClone(elements, true);
            }
        }
        return false;
    }

    public static void doClone(PsiElement element2) {
        PsiElement[] elements = new PsiElement[]{element2};
        for (CopyHandlerDelegate delegate2 : CopyHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate2.canCopy(elements)) continue;
            if (delegate2 instanceof CopyHandlerDelegateBase && ((CopyHandlerDelegateBase)delegate2).forbidToClone(elements, false)) {
                return;
            }
            delegate2.doClone(element2);
            break;
        }
    }

    public static void updateSelectionInActiveProjectView(@NotNull PsiElement newElement, Project project, boolean selectInActivePanel) {
        JComponent component2;
        ToolWindow window;
        Content selectedContent;
        String id2;
        if (newElement == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        if ((id2 = ToolWindowManager.getInstance((Project)project).getActiveToolWindowId()) != null && (selectedContent = (window = ToolWindowManager.getInstance((Project)project).getToolWindow(id2)).getContentManager().getSelectedContent()) != null && (component2 = selectedContent.getComponent()) instanceof TwoPaneIdeView) {
            ((TwoPaneIdeView)((Object)component2)).selectElement(newElement, selectInActivePanel);
            return;
        }
        if ("Project".equals(id2)) {
            ProjectView.getInstance(project).selectPsiElement(newElement, true);
        } else if ("Structure".equals(id2)) {
            VirtualFile virtualFile = newElement.getContainingFile().getVirtualFile();
            FileEditor editor = FileEditorManager.getInstance((Project)newElement.getProject()).getSelectedEditor(virtualFile);
            StructureViewFactoryEx.getInstanceEx(project).getStructureViewWrapper().selectCurrentElement(editor, virtualFile, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/refactoring/copy/CopyHandler", "updateSelectionInActiveProjectView"));
    }
}

