/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ByteArrayInterner;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.stubs.StubStringInterner;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class StubTreeSerializerBase<SerializationState> {
    protected static final ThreadLocal<ObjectStubSerializer<?, ? extends Stub>> ourRootStubSerializer = new ThreadLocal();
    @NotNull
    private final StubStringInterner myStubStringInterner = StubStringInterner.getInstance();

    StubTreeSerializerBase() {
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(0);
        }
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(false);
        StubInputStream inputStream2 = new StubInputStream(stream, (AbstractStringEnumerator)storage2);
        @NotNull SerializationState state = this.readSerializationState(inputStream2);
        storage2.read((DataInput)inputStream2, this.myStubStringInterner::intern);
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream2, storage2, state);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserializeRoot(inputStream2, storage2, state);
            if (deserialize instanceof PsiFileStub) {
                stubs.add((PsiFileStub)deserialize);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(1);
        }
        return stub;
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(2);
        }
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(3);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage2 = new FileLocalStringEnumerator(true);
        @NotNull SerializationState serializationState = this.createSerializationState();
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage2);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage2, serializationState);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage2, serializationState);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        this.saveSerializationState(serializationState, resultStream);
        storage2.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    @NotNull
    protected abstract SerializationState readSerializationState(@NotNull StubInputStream var1) throws IOException;

    @NotNull
    protected abstract SerializationState createSerializationState();

    protected abstract void saveSerializationState(@NotNull SerializationState var1, @NotNull DataOutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream2, FileLocalStringEnumerator storage2, @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(4);
        }
        int serializedId = DataInputOutputUtil.readINT((DataInput)inputStream2);
        ObjectStubSerializer<?, Stub> serializer2 = this.getClassByIdLocal(serializedId, null, state);
        ourRootStubSerializer.set(serializer2);
        try {
            Stub stub = serializer2.deserialize(inputStream2, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList((StubBase)stub, serializer2, inputStream2, storage2, state);
            } else {
                this.deserializeChildren(inputStream2, stub, state);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    protected abstract int writeSerializerId(@NotNull ObjectStubSerializer<Stub, Stub> var1, @NotNull SerializationState var2) throws IOException;

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, @NotNull SerializationState state) throws IOException {
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(5);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(6);
        }
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream, state).serialize(stub, stream);
    }

    @NotNull
    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, @NotNull SerializationState state) throws IOException {
        ObjectStubSerializer serializer2;
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(7);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(8);
        }
        if ((serializer2 = StubSerializationUtil.getSerializer((Stub)stub)) == null) {
            throw new Error("No serializer was returned for " + stub);
        }
        int localId = this.writeSerializerId((ObjectStubSerializer<Stub, Stub>)serializer2, state);
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)localId);
        ObjectStubSerializer objectStubSerializer = serializer2;
        if (objectStubSerializer == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(9);
        }
        return objectStubSerializer;
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, @NotNull SerializationState state) throws IOException {
        if (parent == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(10);
        }
        if (stream == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(11);
        }
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(12);
        }
        List children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children2.size());
        for (Stub child2 : children2) {
            this.serializeSelf(child2, stream, state);
            this.serializeChildren(child2, stream, state);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage2, @NotNull SerializationState state) throws IOException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(13);
        }
        this.serializeSelf(root, out, state);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(stubList, (DataOutput)out, storage2, state);
        } else {
            this.serializeChildren(root, out, state);
        }
    }

    private void deserializeStubList(StubBase<?> root, final ObjectStubSerializer<?, ? extends Stub> rootType, final StubInputStream inputStream2, FileLocalStringEnumerator storage2, final @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(14);
        }
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index2 = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream2);
                int start2 = DataInputOutputUtil.readINT((DataInput)inputStream2);
                allStarts.set(start2);
                this.addStub(parentIndex, index2, start2, (IElementType)StubTreeSerializerBase.this.getClassByIdLocal(serializerId, null, state));
                this.deserializeChildren(index2);
            }

            private void addStub(int parentIndex, int index2, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index2, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i2 = 0; i2 < childrenCount; ++i2) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)rootType);
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream2);
        stubList.setStubData(new LazyStubData(storage2, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(StubList stubList, DataOutput out, AbstractStringEnumerator storage2, @NotNull SerializationState state) throws IOException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(15);
        }
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i2 = 1; i2 < stubList.size(); ++i2) {
            StubBase stub = (StubBase)stubList.get(i2);
            ObjectStubSerializer<Stub, Stub> serializer2 = this.writeSerializerId((Stub)stub, out, state);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubTreeSerializerBase.serializeStub(serializer2, storage2, stub, tempBuffer)));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(stub.id));
        }
        StubTreeSerializerBase.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer2, AbstractStringEnumerator storage2, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage2);
        serializer2.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream2) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream2);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array2 = new byte[length];
        int read = inputStream2.read(array2);
        if (read != array2.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array2;
    }

    private static void writeByteArray(DataOutput out, byte[] array2, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array2, 0, len);
    }

    protected abstract ObjectStubSerializer<?, Stub> getClassByIdLocal(int var1, @Nullable Stub var2, @NotNull SerializationState var3) throws SerializerNotFoundException;

    private void deserializeChildren(StubInputStream stream, Stub parent, @NotNull SerializationState state) throws IOException, SerializerNotFoundException {
        if (state == null) {
            StubTreeSerializerBase.$$$reportNull$$$0(16);
        }
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i2 = 0; i2 < childCount; ++i2) {
            boolean dangling = false;
            int id2 = DataInputOutputUtil.readINT((DataInput)stream);
            if (id2 == 0) {
                dangling = true;
                id2 = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child2 = this.getClassByIdLocal(id2, parent, state).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, child2, state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeSerializerBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeSerializerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "writeSerializerId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserializeRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeSelf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeSerializerId";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serializeRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deserializeStubList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "serializeStubList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deserializeChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

