/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.google.common.hash.HashCode;
import com.intellij.index.PrebuiltIndexProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0014J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/psi/stubs/PrebuiltStubsProviderBase;", "Lcom/intellij/index/PrebuiltIndexProvider;", "Lcom/intellij/psi/stubs/SerializedStubTree;", "Lcom/intellij/psi/stubs/PrebuiltStubsProvider;", "()V", "indexExternalizer", "Lcom/intellij/psi/stubs/SerializedStubTreeDataExternalizer;", "getIndexExternalizer", "()Lcom/intellij/psi/stubs/SerializedStubTreeDataExternalizer;", "indexName", "", "getIndexName", "()Ljava/lang/String;", "mySerializationManager", "Lcom/intellij/psi/stubs/SerializationManagerImpl;", "stubVersion", "", "getStubVersion", "()I", "findStub", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "getIndexVersion", "openIndexStorage", "Lcom/intellij/util/io/PersistentHashMap;", "Lcom/google/common/hash/HashCode;", "indexesRoot", "Ljava/io/File;", "Companion", "intellij.platform.indexing.impl"})
public abstract class PrebuiltStubsProviderBase
extends PrebuiltIndexProvider<SerializedStubTree>
implements PrebuiltStubsProvider {
    private SerializationManagerImpl mySerializationManager;
    @NotNull
    public static final String PREBUILT_INDICES_PATH_PROPERTY = "prebuilt_indices_path";
    @NotNull
    public static final String SDK_STUBS_STORAGE_NAME = "sdk-stubs";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    protected abstract int getStubVersion();

    @Override
    @NotNull
    protected String getIndexName() {
        return SDK_STUBS_STORAGE_NAME;
    }

    @NotNull
    protected SerializedStubTreeDataExternalizer getIndexExternalizer() {
        SerializationManagerImpl serializationManagerImpl = this.mySerializationManager;
        if (serializationManagerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mySerializationManager");
        }
        return new SerializedStubTreeDataExternalizer(serializationManagerImpl, StubForwardIndexExternalizer.createFileLocalExternalizer());
    }

    protected int getIndexVersion() {
        return -1;
    }

    @Override
    @Nullable
    public PersistentHashMap<HashCode, SerializedStubTree> openIndexStorage(@NotNull File indexesRoot) {
        Intrinsics.checkNotNullParameter((Object)indexesRoot, (String)"indexesRoot");
        Path formatFile = indexesRoot.toPath().resolve(this.getIndexName() + ".version");
        List<String> versionFileText = Files.readAllLines(formatFile);
        if (versionFileText.size() != 2) {
            LOG.warn("Invalid version file format: \"" + versionFileText + "\" (file=" + formatFile + ')');
            return null;
        }
        String stubSerializationVersion = versionFileText.get(0);
        int currentSerializationVersion = StringUtilRt.parseInt((String)stubSerializationVersion, (int)0);
        int expected = this.getIndexVersion();
        if (expected != -1 && currentSerializationVersion != expected) {
            LOG.error("Stub serialization version mismatch: " + expected + ", current version is " + currentSerializationVersion);
            return null;
        }
        String prebuiltIndexVersion = versionFileText.get(1);
        if (StringUtilRt.parseInt((String)prebuiltIndexVersion, (int)0) != this.getStubVersion()) {
            LOG.error("Prebuilt stubs version mismatch: " + prebuiltIndexVersion + ", current version is " + this.getStubVersion());
            return null;
        }
        this.mySerializationManager = new SerializationManagerImpl(new File(indexesRoot, this.getIndexName() + ".names").toPath(), true);
        Disposable disposable2 = (Disposable)ApplicationManager.getApplication();
        SerializationManagerImpl serializationManagerImpl = this.mySerializationManager;
        if (serializationManagerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mySerializationManager");
        }
        Intrinsics.checkNotNull((Object)serializationManagerImpl);
        Disposer.register((Disposable)disposable2, (Disposable)serializationManagerImpl);
        return super.openIndexStorage(indexesRoot);
    }

    @Override
    @Nullable
    public SerializedStubTree findStub(@NotNull FileContent fileContent) {
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        try {
            return (SerializedStubTree)this.get(fileContent);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            this.dispose();
            LOG.error("Can't get prebuilt stub tree from " + this.getClass().getName(), (Throwable)e);
            return null;
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PrebuiltStubsProviderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/psi/stubs/PrebuiltStubsProviderBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREBUILT_INDICES_PATH_PROPERTY", "", "SDK_STUBS_STORAGE_NAME", "intellij.platform.indexing.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

