/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.PlaceInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class LeafPatcher
extends RecursiveTreeElementWalkingVisitor {
    private static final Logger LOG = Logger.getInstance(LeafPatcher.class);
    private int shredNo;
    private String hostText;
    private LiteralTextEscaper<?> currentTextEscaper;
    private TextRange rangeInHost;
    private final Map<LeafElement, String> newTexts;
    @NotNull
    private final List<? extends PlaceInfo> myPlaceInfos;
    private final StringBuilder catLeafs;
    private final StringBuilder tempLeafBuffer;
    static final Key<String> UNESCAPED_TEXT = Key.create((String)"INJECTED_UNESCAPED_TEXT");

    LeafPatcher(@NotNull List<? extends PlaceInfo> placeInfos, int approxTextLength) {
        if (placeInfos == null) {
            LeafPatcher.$$$reportNull$$$0(0);
        }
        this.newTexts = new HashMap<LeafElement, String>();
        this.tempLeafBuffer = new StringBuilder();
        this.myPlaceInfos = placeInfos;
        this.catLeafs = new StringBuilder(approxTextLength);
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        String leafText = leaf instanceof ForeignLeafPsiElement ? "" : leaf.getText();
        this.catLeafs.append(leafText);
        TextRange leafRange = leaf.getTextRange();
        StringBuilder leafEncodedText = this.constructTextFromHostPSI(leafRange.getStartOffset(), leafRange.getEndOffset());
        if (!Comparing.equal((CharSequence)leafText, (CharSequence)leafEncodedText)) {
            this.newTexts.put(leaf, leafEncodedText.toString());
            LeafPatcher.storeUnescapedTextFor(leaf, leafText);
        }
    }

    private StringBuilder constructTextFromHostPSI(int startOffset, int endOffset) {
        boolean firstTimer = false;
        PlaceInfo currentPlace = this.myPlaceInfos.get(this.shredNo);
        if (this.hostText == null) {
            this.hostText = currentPlace.myHostText;
            this.rangeInHost = currentPlace.getRelevantRangeInsideHost();
            this.currentTextEscaper = currentPlace.myEscaper;
            firstTimer = true;
        }
        StringBuilder text2 = this.tempLeafBuffer;
        text2.setLength(0);
        while (startOffset < endOffset) {
            ProperTextRange shredRange = currentPlace.rangeInDecodedPSI;
            String prefix = currentPlace.prefix;
            if (startOffset >= shredRange.getEndOffset()) {
                currentPlace = this.myPlaceInfos.get(++this.shredNo);
                this.hostText = currentPlace.myHostText;
                this.currentTextEscaper = currentPlace.myEscaper;
                this.rangeInHost = currentPlace.getRelevantRangeInsideHost();
                firstTimer = true;
                continue;
            }
            assert (startOffset >= shredRange.getStartOffset());
            if (startOffset - shredRange.getStartOffset() < prefix.length()) {
                TextRange rangeInPrefix = new TextRange(startOffset - shredRange.getStartOffset(), Math.min(prefix.length(), endOffset - shredRange.getStartOffset()));
                text2.append(prefix, rangeInPrefix.getStartOffset(), rangeInPrefix.getEndOffset());
                startOffset += rangeInPrefix.getLength();
                continue;
            }
            String suffix = currentPlace.suffix;
            if (startOffset < shredRange.getEndOffset() - suffix.length()) {
                int startOffsetInHost = this.currentTextEscaper.getOffsetInHost(startOffset - shredRange.getStartOffset() - prefix.length(), this.rangeInHost);
                int endOffsetCut = Math.min(endOffset, shredRange.getEndOffset() - suffix.length());
                int endOffsetInHost = this.currentTextEscaper.getOffsetInHost(endOffsetCut - shredRange.getStartOffset() - prefix.length(), this.rangeInHost);
                if (endOffsetInHost != -1) {
                    if (firstTimer) {
                        text2.append(this.hostText, this.rangeInHost.getStartOffset(), startOffsetInHost);
                    }
                    text2.append(this.hostText, startOffsetInHost, endOffsetInHost);
                    startOffset = endOffsetCut;
                    continue;
                }
                LOG.error("Text escaper " + this.currentTextEscaper + " (" + this.currentTextEscaper.getClass() + ") returned -1 in 'getOffsetInHost(" + (endOffsetCut - shredRange.getStartOffset() - prefix.length()) + ", new TextRange" + this.rangeInHost + ")' for " + currentPlace.host.getClass(), new Attachment[]{new Attachment("host", StringUtil.first((String)currentPlace.host.getText(), (int)100, (boolean)true))});
                continue;
            }
            TextRange rangeInSuffix = new TextRange(suffix.length() - shredRange.getEndOffset() + startOffset, Math.min(suffix.length(), endOffset + suffix.length() - shredRange.getEndOffset()));
            text2.append(suffix, rangeInSuffix.getStartOffset(), rangeInSuffix.getEndOffset());
            startOffset += rangeInSuffix.getLength();
        }
        return text2;
    }

    private static void storeUnescapedTextFor(@NotNull LeafElement leaf, @NotNull String leafText) {
        PsiElement psi;
        if (leaf == null) {
            LeafPatcher.$$$reportNull$$$0(1);
        }
        if (leafText == null) {
            LeafPatcher.$$$reportNull$$$0(2);
        }
        if ((psi = leaf.getPsi()) != null) {
            psi.putCopyableUserData(UNESCAPED_TEXT, (Object)leafText);
        }
    }

    void patch(@NotNull ASTNode parsedNode, @NotNull List<? extends PlaceInfo> placeInfos) {
        if (parsedNode == null) {
            LeafPatcher.$$$reportNull$$$0(3);
        }
        if (placeInfos == null) {
            LeafPatcher.$$$reportNull$$$0(4);
        }
        ((TreeElement)parsedNode).acceptTree(this);
        assert (((TreeElement)parsedNode).textMatches(this.catLeafs)) : "Malformed PSI structure: leaf texts do not add up to the whole file text.\nFile text (from tree)  :'" + parsedNode.getText() + "'\nFile text (from PSI)   :'" + parsedNode.getPsi().getText() + "'\nLeaf texts concatenated:'" + this.catLeafs + "';\nFile root: " + parsedNode + "\nLanguage: " + parsedNode.getPsi().getLanguage() + "\nHost file: " + placeInfos.get((int)0).host.getContainingFile().getVirtualFile();
        DebugUtil.performPsiModification("injection leaf patching", () -> {
            for (Map.Entry<LeafElement, String> entry : this.newTexts.entrySet()) {
                LeafElement leaf = entry.getKey();
                String newText = entry.getValue();
                leaf.rawReplaceWithText(newText);
            }
        });
        TreeUtil.clearCaches((TreeElement)parsedNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/LeafPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "storeUnescapedTextFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "patch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

