/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.injected.DocumentWindowImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.impl.source.tree.injected.LeafPatcher;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.VirtualFileWindowImpl;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2021.3")
public class InjectedLanguageUtilBase {
    public static final Key<IElementType> INJECTED_FRAGMENT_TYPE = Key.create((String)"INJECTED_FRAGMENT_TYPE");
    private static final Key<List<TokenInfo>> HIGHLIGHT_TOKENS = Key.create((String)"HIGHLIGHT_TOKENS");
    private static final Key<Getter<InjectionResult>> INJECTED_PSI = Key.create((String)"INJECTED_PSI");
    private static final Key<InjectionResult> INJECTION_HOLDER_BACK_REFERENCE = Key.create((String)"INJECTION_HOLDER_BACK_REFERENCE");
    private static final Key<List<DocumentWindow>> INJECTED_DOCS_KEY = Key.create((String)"INJECTED_DOCS_KEY");

    @NotNull
    static PsiElement loadTree(@NotNull PsiElement host, @NotNull PsiFile containingFile) {
        PsiElement context;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(1);
        }
        if (containingFile instanceof DummyHolder && (context = containingFile.getContext()) != null) {
            PsiFile topFile = context.getContainingFile();
            topFile.getNode();
            TextRange textRange = host.getTextRange().shiftRight(context.getTextRange().getStartOffset());
            PsiElement inLoadedTree = PsiTreeUtil.findElementOfClassAtRange((PsiFile)topFile, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), host.getClass());
            if (inLoadedTree != null) {
                host = inLoadedTree;
            }
        }
        PsiElement psiElement = host;
        if (psiElement == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public static List<TokenInfo> getHighlightTokens(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(3);
        }
        return (List)file2.getUserData(HIGHLIGHT_TOKENS);
    }

    public static String getUnescapedText(@NotNull PsiFile file2, final @Nullable PsiElement startElement, final @Nullable PsiElement endElement) {
        InjectedLanguageManager manager2;
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(4);
        }
        if ((manager2 = InjectedLanguageManager.getInstance((Project)file2.getProject())).getInjectionHost((PsiElement)file2) == null) {
            return file2.getText().substring(startElement == null ? 0 : startElement.getTextRange().getStartOffset(), endElement == null ? file2.getTextLength() : endElement.getTextRange().getStartOffset());
        }
        final StringBuilder sb = new StringBuilder();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            Boolean myState;
            {
                this.myState = startElement == null ? Boolean.TRUE : null;
            }

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 == startElement) {
                    this.myState = Boolean.TRUE;
                }
                if (element2 == endElement) {
                    this.myState = Boolean.FALSE;
                }
                if (Boolean.FALSE == this.myState) {
                    return;
                }
                if (Boolean.TRUE == this.myState && element2.getFirstChild() == null) {
                    sb.append(InjectedLanguageUtilBase.getUnescapedLeafText(element2, false));
                } else {
                    super.visitElement(element2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase$1", "visitElement"));
            }
        });
        return sb.toString();
    }

    static void setHighlightTokens(@NotNull PsiFile file2, @NotNull List<TokenInfo> tokens) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(5);
        }
        if (tokens == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(6);
        }
        file2.putUserData(HIGHLIGHT_TOKENS, tokens);
    }

    public static Place getShreds(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = injectedFile.getViewProvider();
        return InjectedLanguageUtilBase.getShreds(viewProvider);
    }

    public static Place getShreds(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(8);
        }
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            return null;
        }
        InjectedFileViewProvider myFileViewProvider = (InjectedFileViewProvider)viewProvider;
        return InjectedLanguageUtilBase.getShreds(myFileViewProvider.getDocument());
    }

    @NotNull
    private static Place getShreds(@NotNull DocumentWindow document) {
        if (document == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(9);
        }
        Place place = ((DocumentWindowImpl)document).getShreds();
        if (place == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(10);
        }
        return place;
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(11);
        }
        if (visitor == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(12);
        }
        PsiFile containingFile = host.getContainingFile();
        PsiUtilCore.ensureValid((PsiElement)containingFile);
        return InjectedLanguageUtilBase.enumerate(host, containingFile, true, visitor);
    }

    @Deprecated
    public static boolean enumerate(@NotNull PsiElement host, @NotNull PsiFile containingFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiDocumentManager documentManager;
        Document document;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(14);
        }
        if (visitor == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(15);
        }
        if (!containingFile.isPhysical() && containingFile.getOriginalFile() == containingFile && ModelBranch.getPsiBranch((PsiElement)containingFile) == null) {
            PsiLanguageInjectionHost context = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (context == null) {
                return false;
            }
            PsiFile file2 = context.getContainingFile();
            if (file2 == null || !file2.isPhysical() && file2.getOriginalFile() == file2) {
                return false;
            }
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider) {
            return false;
        }
        PsiElement inTree = InjectedLanguageUtilBase.loadTree(host, containingFile);
        if (inTree != host) {
            host = inTree;
            containingFile = host.getContainingFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)containingFile.getProject())).getDocument(containingFile)) == null || documentManager.isCommitted(document)) {
            InjectedLanguageUtilBase.probeElementsUp(host, containingFile, probeUp, visitor);
        }
        return true;
    }

    static boolean mightHaveInjectedFragmentAtCaret(@NotNull Project project, @NotNull Document hostDocument, int hostOffset) {
        PsiFile hostPsiFile;
        if (project == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(16);
        }
        if (hostDocument == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(17);
        }
        if ((hostPsiFile = PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(hostDocument)) == null || !hostPsiFile.isValid()) {
            return false;
        }
        List documents = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(hostPsiFile, TextRange.create((int)hostOffset, (int)hostOffset));
        for (DocumentWindow document : documents) {
            if (!document.isValid() || document.getHostRange(hostOffset) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiFile findInjectedPsiNoCommit(@NotNull PsiFile host, int offset) {
        PsiElement injected;
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(18);
        }
        return (injected = InjectedLanguageManager.getInstance((Project)host.getProject()).findInjectedElementAt(host, offset)) == null ? null : injected.getContainingFile();
    }

    public static PsiElement findElementAtNoCommit(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(19);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        Trinity<PsiElement, PsiElement, Language> result2 = null;
        if (!(viewProvider instanceof InjectedFileViewProvider)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file2.getProject());
            result2 = InjectedLanguageUtilBase.tryOffset(file2, offset, documentManager);
            PsiElement injected = (PsiElement)result2.first;
            if (injected != null) {
                return injected;
            }
        }
        Language baseLanguage = viewProvider.getBaseLanguage();
        if (result2 != null && baseLanguage == result2.third) {
            return (PsiElement)result2.second;
        }
        return viewProvider.findElementAt(offset, baseLanguage);
    }

    private static void probeElementsUp(@NotNull PsiElement element2, @NotNull PsiFile hostPsiFile, boolean probeUp, @NotNull PsiLanguageInjectionHost.InjectedPsiVisitor visitor) {
        PsiElement current2;
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(20);
        }
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(21);
        }
        if (visitor == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(22);
        }
        if ((element2 = InjectedLanguageUtilBase.skipNonInjectablePsi(element2, probeUp)) == null) {
            return;
        }
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(hostPsiFile.getProject());
        InjectionResult result2 = null;
        for (current2 = element2; current2 != null && current2 != hostPsiFile && !(current2 instanceof PsiDirectory); current2 = current2.getParent()) {
            ProgressManager.checkCanceled();
            if ("EL".equals(current2.getLanguage().getID())) break;
            result2 = (InjectionResult)SoftReference.deref((Getter)((Getter)current2.getUserData(INJECTED_PSI)));
            if (result2 == null || !result2.isModCountUpToDate() || !result2.isValid()) {
                result2 = injectedManager.processInPlaceInjectorsFor(hostPsiFile, current2);
                InjectedLanguageUtilBase.preventResultFromGCWhileInjectedPsiIsReachable(result2);
            }
            if (result2 == null) continue;
            if (result2.files != null) {
                for (PsiFile psiFile : result2.files) {
                    boolean intersects;
                    Place place = InjectedLanguageUtilBase.getShreds(psiFile);
                    if (!place.isValid() || !(intersects = InjectedLanguageUtilBase.intersects(element2, place))) continue;
                    visitor.visit(psiFile, (List)((Object)place));
                }
            }
            if (result2.references == null || !(visitor instanceof InjectedReferenceVisitor)) break;
            InjectedReferenceVisitor refVisitor = (InjectedReferenceVisitor)visitor;
            for (Pair<ReferenceInjector, Place> pair : result2.references) {
                boolean intersects;
                Place place = (Place)((Object)pair.getSecond());
                if (!place.isValid() || !(intersects = InjectedLanguageUtilBase.intersects(element2, place))) continue;
                ReferenceInjector injector = (ReferenceInjector)pair.getFirst();
                refVisitor.visitInjectedReference(injector, (List<? extends PsiLanguageInjectionHost.Shred>)((Object)place));
            }
            break;
        }
        if (element2 != current2 && (probeUp || result2 != null)) {
            InjectedLanguageUtilBase.cacheResults(element2, current2, hostPsiFile, result2);
        }
    }

    private static void cacheResults(@NotNull PsiElement from2, @Nullable PsiElement upUntil, @NotNull PsiFile hostFile, @Nullable InjectionResult result2) {
        if (from2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(23);
        }
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(24);
        }
        InjectionResult cachedRef = result2 == null || result2.isEmpty() ? InjectedLanguageUtilBase.getEmptyInjectionResult(hostFile) : new SoftReference((Object)result2);
        for (PsiElement e = from2; e != upUntil && e != null; e = e.getParent()) {
            ProgressManager.checkCanceled();
            e.putUserData(INJECTED_PSI, (Object)cachedRef);
        }
    }

    private static void preventResultFromGCWhileInjectedPsiIsReachable(@Nullable InjectionResult result2) {
        if (result2 != null && result2.files != null) {
            for (PsiFile psiFile : result2.files) {
                psiFile.getViewProvider().putUserData(INJECTION_HOLDER_BACK_REFERENCE, (Object)result2);
            }
        }
    }

    @NotNull
    private static InjectionResult getEmptyInjectionResult(@NotNull PsiFile host) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(25);
        }
        InjectionResult injectionResult = (InjectionResult)CachedValuesManager.getCachedValue((PsiElement)host, () -> CachedValueProvider.Result.createSingleDependency((Object)new InjectionResult(host, null, null), (Object)PsiModificationTracker.MODIFICATION_COUNT));
        if (injectionResult == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(26);
        }
        return injectionResult;
    }

    public static boolean isInjectable(@NotNull PsiElement element2, boolean probeUp) {
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(27);
        }
        return InjectedLanguageUtilBase.stopLookingForInjection(element2) || element2.getFirstChild() != null || probeUp;
    }

    @Nullable
    private static PsiElement skipNonInjectablePsi(@NotNull PsiElement element2, boolean probeUp) {
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(28);
        }
        if (!InjectedLanguageUtilBase.stopLookingForInjection(element2) && element2.getFirstChild() == null) {
            if (!probeUp) {
                return null;
            }
            for (element2 = element2.getParent(); element2 != null && !InjectedLanguageUtilBase.stopLookingForInjection(element2) && element2.getFirstChild() == element2.getLastChild(); element2 = element2.getParent()) {
            }
        }
        return element2;
    }

    private static boolean stopLookingForInjection(@NotNull PsiElement element2) {
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(29);
        }
        return element2 instanceof PsiFileSystemItem || element2 instanceof PsiLanguageInjectionHost;
    }

    private static boolean intersects(@NotNull PsiElement hostElement, @NotNull Place place) {
        if (hostElement == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(30);
        }
        if (place == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(31);
        }
        TextRange hostElementRange = hostElement.getTextRange();
        boolean intersects = false;
        Iterator iterator2 = place.iterator();
        while (iterator2.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator2.next();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null || !shredHost.getTextRange().intersects(hostElementRange)) continue;
            intersects = true;
            break;
        }
        return intersects;
    }

    static PsiElement findInjectedElementNoCommit(@NotNull PsiFile hostFile, int offset) {
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(32);
        }
        if (hostFile instanceof PsiCompiledElement) {
            return null;
        }
        Project project = hostFile.getProject();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(hostFile)) {
            return null;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Trinity<PsiElement, PsiElement, Language> result2 = InjectedLanguageUtilBase.tryOffset(hostFile, offset, documentManager);
        return (PsiElement)result2.first;
    }

    @NotNull
    private static Trinity<PsiElement, PsiElement, Language> tryOffset(@NotNull PsiFile hostFile, int offset, @NotNull PsiDocumentManager documentManager) {
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(33);
        }
        if (documentManager == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(34);
        }
        FileViewProvider provider2 = hostFile.getViewProvider();
        Language leafLanguage = null;
        PsiElement leafElement = null;
        for (Language language : provider2.getLanguages()) {
            PsiElement injected;
            PsiElement leftElement;
            PsiElement element2 = provider2.findElementAt(offset, language);
            if (element2 != null) {
                PsiElement injected2;
                if (leafLanguage == null) {
                    leafLanguage = language;
                    leafElement = element2;
                }
                if ((injected2 = InjectedLanguageUtilBase.findInside(element2, hostFile, offset, documentManager)) != null) {
                    Trinity trinity = Trinity.create((Object)injected2, (Object)element2, (Object)language);
                    if (trinity == null) {
                        InjectedLanguageUtilBase.$$$reportNull$$$0(35);
                    }
                    return trinity;
                }
            }
            if (offset == 0 || element2 != null && element2.getTextRange().getStartOffset() != offset || (leftElement = provider2.findElementAt(offset - 1, language)) == null || leftElement.getTextRange().getEndOffset() != offset || (injected = InjectedLanguageUtilBase.findInside(leftElement, hostFile, offset, documentManager)) == null) continue;
            Trinity trinity = Trinity.create((Object)injected, (Object)element2, (Object)language);
            if (trinity == null) {
                InjectedLanguageUtilBase.$$$reportNull$$$0(36);
            }
            return trinity;
        }
        Trinity trinity = Trinity.create(null, leafElement, leafLanguage);
        if (trinity == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(37);
        }
        return trinity;
    }

    private static PsiElement findInside(@NotNull PsiElement element2, @NotNull PsiFile hostFile, int hostOffset, @NotNull PsiDocumentManager documentManager) {
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(38);
        }
        if (hostFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(39);
        }
        if (documentManager == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(40);
        }
        Ref out = new Ref();
        InjectedLanguageUtilBase.enumerate(element2, hostFile, true, (injectedPsi, places) -> {
            for (PsiLanguageInjectionHost.Shred place : places) {
                TextRange hostRange = place.getHost().getTextRange();
                if (!hostRange.cutOut(place.getRangeInsideHost()).grown(1).contains(hostOffset)) continue;
                DocumentWindowImpl document = (DocumentWindowImpl)documentManager.getCachedDocument(injectedPsi);
                if (document == null) {
                    return;
                }
                int injectedOffset = document.hostToInjected(hostOffset);
                PsiElement injElement = injectedPsi.findElementAt(injectedOffset);
                out.set(injElement == null ? injectedPsi : injElement);
            }
        });
        return (PsiElement)out.get();
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ConcurrentList<DocumentWindow> getCachedInjectedDocuments(@NotNull PsiFile hostPsiFile) {
        List injected;
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(41);
        }
        if ((injected = (List)hostPsiFile.getUserData(INJECTED_DOCS_KEY)) == null) {
            injected = (List)((UserDataHolderEx)hostPsiFile).putUserDataIfAbsent(INJECTED_DOCS_KEY, (Object)ContainerUtil.createConcurrentList());
        }
        ConcurrentList concurrentList = (ConcurrentList)injected;
        if (concurrentList == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(42);
        }
        return concurrentList;
    }

    @NotNull
    static List<DocumentWindow> getCachedInjectedDocumentsInRange(@NotNull PsiFile hostPsiFile, @NotNull TextRange range2) {
        if (hostPsiFile == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(43);
        }
        if (range2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(44);
        }
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtilBase.getCachedInjectedDocuments(hostPsiFile);
        List list2 = ContainerUtil.filter(injected, inj -> Arrays.stream(inj.getHostRanges()).anyMatch(arg_0 -> ((TextRange)range2).intersects(arg_0)));
        if (list2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(45);
        }
        return list2;
    }

    static void clearCachedInjectedFragmentsForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(46);
        }
        file2.putUserData(INJECTED_DOCS_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches(@NotNull Project project, @NotNull DocumentWindow documentWindow) {
        if (project == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(47);
        }
        if (documentWindow == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(48);
        }
        if (project.isDisposed()) {
            return;
        }
        VirtualFileWindowImpl virtualFile = (VirtualFileWindowImpl)Objects.requireNonNull(FileDocumentManager.getInstance().getFile((Document)documentWindow));
        PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx(project);
        DebugUtil.performPsiModification("injected clearCaches", () -> psiManagerEx.getFileManager().setViewProvider((VirtualFile)virtualFile, null));
        VirtualFile delegate2 = virtualFile.getDelegate();
        if (!delegate2.isValid()) {
            return;
        }
        FileViewProvider viewProvider = psiManagerEx.getFileManager().findCachedViewProvider(delegate2);
        if (viewProvider == null) {
            return;
        }
        for (PsiFile hostFile : ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles()) {
            Object object = InjectedLanguageManagerImpl.ourInjectionPsiLock;
            synchronized (object) {
                ConcurrentList<DocumentWindow> cachedInjectedDocuments = InjectedLanguageUtilBase.getCachedInjectedDocuments(hostFile);
                for (int i2 = cachedInjectedDocuments.size() - 1; i2 >= 0; --i2) {
                    DocumentWindow cachedInjectedDocument = (DocumentWindow)cachedInjectedDocuments.get(i2);
                    if (cachedInjectedDocument != documentWindow) continue;
                    cachedInjectedDocuments.remove(i2);
                }
            }
        }
    }

    @Deprecated
    public static PsiFile getTopLevelFile(@NotNull PsiElement element2) {
        PsiLanguageInjectionHost host;
        PsiFile containingFile;
        if (element2 == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(49);
        }
        if ((containingFile = element2.getContainingFile()) == null) {
            return null;
        }
        if (containingFile.getViewProvider() instanceof InjectedFileViewProvider && (host = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile)) != null) {
            containingFile = host.getContainingFile();
        }
        return containingFile;
    }

    @Nullable
    public static String getUnescapedLeafText(PsiElement element2, boolean strict) {
        String unescaped = (String)element2.getCopyableUserData(LeafPatcher.UNESCAPED_TEXT);
        if (unescaped != null) {
            return unescaped;
        }
        if (!strict && element2.getFirstChild() == null) {
            return element2.getText();
        }
        return null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable PsiElement psi) {
        if (psi == null) {
            return null;
        }
        PsiFile containingFile = psi.getContainingFile().getOriginalFile();
        PsiElement fileContext = containingFile.getContext();
        if (fileContext instanceof PsiLanguageInjectionHost) {
            return (PsiLanguageInjectionHost)fileContext;
        }
        Place shreds = InjectedLanguageUtilBase.getShreds(containingFile.getViewProvider());
        if (shreds == null) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            if (virtualFile instanceof VirtualFileWindow) {
                shreds = InjectedLanguageUtilBase.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow());
            }
        }
        return shreds != null ? (PsiLanguageInjectionHost)shreds.getHostPointer().getElement() : null;
    }

    @Nullable
    public static PsiLanguageInjectionHost findInjectionHost(@Nullable VirtualFile virtualFile) {
        return virtualFile instanceof VirtualFileWindow ? (PsiLanguageInjectionHost)InjectedLanguageUtilBase.getShreds(((VirtualFileWindow)virtualFile).getDocumentWindow()).getHostPointer().getElement() : null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static boolean hasInjections(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            InjectedLanguageUtilBase.$$$reportNull$$$0(50);
        }
        if (!host.isPhysical()) {
            return false;
        }
        Ref result2 = Ref.create((Object)false);
        InjectedLanguageUtilBase.enumerate((PsiElement)host, (injectedPsi, places) -> result2.set((Object)true));
        return (Boolean)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 10: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostDocument";
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPsiFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 24: 
            case 32: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyInjectionResult";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "tryOffset";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocuments";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedInjectedDocumentsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTree";
                break;
            }
            case 2: 
            case 10: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTokens";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnescapedText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightTokens";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShreds";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mightHaveInjectedFragmentAtCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedPsiNoCommit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtNoCommit";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "probeElementsUp";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cacheResults";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyInjectionResult";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInjectable";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "skipNonInjectablePsi";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "stopLookingForInjection";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findInjectedElementNoCommit";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tryOffset";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findInside";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocuments";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCachedInjectedDocumentsInRange";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "clearCachedInjectedFragmentsForFile";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "clearCaches";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "hasInjections";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 26: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TokenInfo {
        @NotNull
        public final IElementType type;
        @NotNull
        public final ProperTextRange rangeInsideInjectionHost;
        public final int shredIndex;
        @Deprecated
        public final TextAttributes attributes;
        public final TextAttributesKey @NotNull [] textAttributesKeys;

        public TokenInfo(@NotNull IElementType type, @NotNull ProperTextRange rangeInsideInjectionHost, int shredIndex, @NotNull TextAttributes attributes, TextAttributesKey @NotNull [] textAttributesKeys) {
            if (type == null) {
                TokenInfo.$$$reportNull$$$0(0);
            }
            if (rangeInsideInjectionHost == null) {
                TokenInfo.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                TokenInfo.$$$reportNull$$$0(2);
            }
            if (textAttributesKeys == null) {
                TokenInfo.$$$reportNull$$$0(3);
            }
            this.type = type;
            this.rangeInsideInjectionHost = rangeInsideInjectionHost;
            this.shredIndex = shredIndex;
            this.attributes = attributes;
            this.textAttributesKeys = textAttributesKeys;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInsideInjectionHost";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textAttributesKeys";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/tree/injected/InjectedLanguageUtilBase$TokenInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

