/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance(CompositeElement.class);
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final AtomicReferenceFieldUpdater<CompositeElement, PsiElement> myWrapperUpdater = AtomicReferenceFieldUpdater.newUpdater(CompositeElement.class, PsiElement.class, "myWrapper");
    private static final boolean ASSERT_THREADING = true;

    public CompositeElement(@NotNull IElementType type) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (TreeElement child2 = this.rawFirstChild(); child2 != null; child2 = child2.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child2.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            CompositeElement.$$$reportNull$$$0(1);
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
            CompositeElement.assertThreading((PsiFile)psi);
        }
    }

    @Override
    public void clearCaches() {
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private static void assertThreading(@NotNull PsiFile file2) {
        boolean ok2;
        if (file2 == null) {
            CompositeElement.$$$reportNull$$$0(2);
        }
        boolean bl = ok2 = ApplicationManager.getApplication().isWriteAccessAllowed() || CompositeElement.isNonPhysicalOrInjected(file2);
        if (!ok2) {
            LOG.error("Threading assertion. " + CompositeElement.getThreadingDiagnostics(file2));
        }
    }

    @NonNls
    private static String getThreadingDiagnostics(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(3);
        }
        return "psiFile: " + psiFile + "; psiFile.getViewProvider(): " + psiFile.getViewProvider() + "; psiFile.isPhysical(): " + psiFile.isPhysical() + "; nonPhysicalOrInjected: " + CompositeElement.isNonPhysicalOrInjected(psiFile);
    }

    private static boolean isNonPhysicalOrInjected(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(4);
        }
        return psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(@NotNull TreeElementVisitor visitor) {
        if (visitor == null) {
            CompositeElement.$$$reportNull$$$0(5);
        }
        visitor.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset) {
        TreeElement element2 = this;
        if (element2.getTreeParent() == null && offset >= element2.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child2 = ((TreeElement)element2).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element2).getLastChildNode();
            int elementTextLength = element2.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset;
            if (!fwd) {
                child2 = lastChild;
                offset = elementTextLength - offset;
            }
            while (child2 != null) {
                int textLength = child2.getTextLength();
                if (textLength > offset || !fwd && textLength >= offset) {
                    if (child2 instanceof LeafElement) {
                        if (child2 instanceof ForeignLeafPsiElement) {
                            child2 = fwd ? child2.getTreeNext() : child2.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child2;
                    }
                    offset = fwd ? offset : textLength - offset;
                    element2 = child2;
                    continue block0;
                }
                offset -= textLength;
                child2 = fwd ? child2.getTreeNext() : child2.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull IElementType type) {
        ASTNode node;
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(6);
        }
        return (node = this.findChildByType(type)) == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(@NotNull TokenSet types) {
        ASTNode node;
        if (types == null) {
            CompositeElement.$$$reportNull$$$0(7);
        }
        return (node = this.findChildByType(types)) == null ? null : node.getPsi();
    }

    public ASTNode findChildByType(@NotNull IElementType type) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(8);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (TreeElement element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (element2.getElementType() != type) continue;
            return element2;
        }
        return null;
    }

    public ASTNode findChildByType(@NotNull IElementType type, ASTNode anchor2) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(9);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, type);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            CompositeElement.$$$reportNull$$$0(10);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        for (TreeElement element2 = this.getFirstChildNode(); element2 != null; element2 = element2.getTreeNext()) {
            if (!types.contains(element2.getElementType())) continue;
            return element2;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor2) {
        if (typesSet == null) {
            CompositeElement.$$$reportNull$$$0(11);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, typesSet);
    }

    @NotNull
    public String getText() {
        return new String(this.textToCharArray());
    }

    @NotNull
    public CharSequence getChars() {
        String string = this.getText();
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    public char @NotNull [] textToCharArray() {
        int endOffset;
        this.assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            @NonNls String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            @NonNls String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(13);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text2) {
        PsiElement psi;
        @NonNls String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + CompositeElement.isNonPhysicalOrInjected(SharedImplUtil.getContainingFile(this));
        msg = msg + ";\n buffer=" + text2;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text2, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file2;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file2 = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file2;
                msg = msg + ";\n psi.file.tl=" + file2.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file2.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file2.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                PsiElement fileLeaf = file2.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    public boolean textContains(char c) {
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (!child2.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start2) {
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(14);
        }
        final int[] curOffset = new int[]{start2};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite2) {
                if (composite2 instanceof LazyParseableElement && !((LazyParseableElement)composite2).isParsed()) {
                    this.matchText(composite2);
                } else {
                    super.visitComposite(composite2);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element2 = this.findChildByRole(role);
        if (element2 == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element2);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (this.getChildRole(child2) != role) continue;
            return child2;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child2) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(15);
        }
        LOG.assertTrue(child2.getTreeParent() == this, (Object)child2);
        return 0;
    }

    protected final int getChildRole(@NotNull ASTNode child2, int roleCandidate) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(16);
        }
        if (this.findChildByRole(roleCandidate) == child2) {
            return roleCandidate;
        }
        return 0;
    }

    public ASTNode @NotNull [] getChildren(@Nullable TokenSet filter) {
        int count = this.countChildren(filter);
        if (count == 0) {
            if (EMPTY_ARRAY == null) {
                CompositeElement.$$$reportNull$$$0(17);
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (filter != null && !filter.contains(child2.getElementType())) continue;
            result2[count++] = child2;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(18);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@Nullable TokenSet filter, @NotNull ArrayFactory<? extends T> constructor) {
        if (constructor == null) {
            CompositeElement.$$$reportNull$$$0(19);
        }
        this.assertReadAccessAllowed();
        int count = this.countChildren(filter);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(20);
            }
            return result2;
        }
        int idx = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null && idx < count; child2 = child2.getTreeNext()) {
            if (filter != null && !filter.contains(child2.getElementType())) continue;
            PsiElement element2 = child2.getPsi();
            LOG.assertTrue(element2 != null, (Object)child2);
            result2[idx++] = element2;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(21);
        }
        return result2;
    }

    public <T extends PsiElement> T @NotNull [] getChildrenAsPsiElements(@NotNull IElementType type, @NotNull ArrayFactory<? extends T> constructor) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(22);
        }
        if (constructor == null) {
            CompositeElement.$$$reportNull$$$0(23);
        }
        this.assertReadAccessAllowed();
        int count = this.countChildren(type);
        PsiElement[] result2 = (PsiElement[])constructor.create(count);
        if (count == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(24);
            }
            return result2;
        }
        int idx = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null && idx < count; child2 = child2.getTreeNext()) {
            if (type != child2.getElementType()) continue;
            PsiElement element2 = child2.getPsi();
            LOG.assertTrue(element2 != null, (Object)child2);
            result2[idx++] = element2;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(25);
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter) {
        int count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (filter != null && !filter.contains(child2.getElementType())) continue;
            ++count;
        }
        return count;
    }

    private int countChildren(@NotNull IElementType type) {
        if (type == null) {
            CompositeElement.$$$reportNull$$$0(26);
        }
        int count = 0;
        for (TreeElement child2 = this.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (type != child2.getElementType()) continue;
            ++count;
        }
        return count;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, @Nullable ASTNode anchor2, @Nullable Boolean before) {
        Object anchorBefore = anchor2 == null ? (before == null || before != false ? null : this.getFirstChildNode()) : (before != false ? anchor2 : anchor2.getTreeNext());
        return (TreeElement)CodeEditUtil.addChildren(this, first, last, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child2) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(27);
        }
        CodeEditUtil.removeChild(this, child2);
    }

    public void replaceChildInternal(@NotNull ASTNode child2, @NotNull TreeElement newElement) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(28);
        }
        if (newElement == null) {
            CompositeElement.$$$reportNull$$$0(29);
        }
        CodeEditUtil.replaceChild(this, child2, newElement);
    }

    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        this.assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child2 = this.firstChild; child2 != null; child2 = child2.getTreeNext()) {
                hc += child2.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start2) {
        TreeElement child2;
        if (start2 == null) {
            CompositeElement.$$$reportNull$$$0(30);
        }
        TreeElement cur = start2;
        while (cur.getCachedLength() < 0 && (child2 = cur.getFirstChildNode()) != null) {
            cur = child2;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            CompositeElement.$$$reportNull$$$0(31);
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child2 = cur.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                    length += child2.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent = cur.getTreeParent();
        if (parent == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid((PsiElement)psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    public void addChild(@NotNull ASTNode child2, @Nullable ASTNode anchorBefore) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(32);
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, (Object)"anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child2);
        TreeElement last = ((TreeElement)child2).getTreeNext();
        TreeElement first = (TreeElement)child2;
        CompositeElement.removeChildrenInner(first, last);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            if (anchorBefore != null) {
                CompositeElement.insertBefore((TreeChangeEventImpl)destinationTreeChange, (TreeElement)anchorBefore, first);
            } else {
                CompositeElement.add((TreeChangeEventImpl)destinationTreeChange, this, first);
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, @NotNull CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            CompositeElement.$$$reportNull$$$0(33);
        }
        if (leafText == null) {
            CompositeElement.$$$reportNull$$$0(34);
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child2) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(35);
        }
        this.addChild(child2, null);
    }

    public void removeChild(@NotNull ASTNode child2) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(36);
        }
        CompositeElement.removeChildInner((TreeElement)child2);
    }

    public void removeRange(@NotNull ASTNode first, ASTNode firstWhichStayInTree) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(37);
        }
        CompositeElement.removeChildrenInner((TreeElement)first, (TreeElement)firstWhichStayInTree);
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(38);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(39);
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
            CompositeElement.replace((TreeChangeEventImpl)destinationTreeChange, oldChild1, newChild1);
            CompositeElement.repairRemovedElement(this, oldChild1);
        }, this);
    }

    public void replaceAllChildrenToChildrenOf(@NotNull ASTNode anotherParent) {
        if (anotherParent == null) {
            CompositeElement.$$$reportNull$$$0(40);
        }
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(event -> CompositeElement.remove((TreeChangeEventImpl)event, (TreeElement)anotherParent.getFirstChildNode(), null), (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                TreeElement first = this.getFirstChildNode();
                TreeChangeEventImpl event = (TreeChangeEventImpl)destinationTreeChange;
                CompositeElement parent = this.getTreeParent();
                if (parent != null) {
                    event.addElementaryChange(parent);
                }
                CompositeElement.remove(event, first, null);
                CompositeElement.add(event, this, (TreeElement)firstChild);
                if (parent != null) {
                    CompositeElement.repairRemovedElement(this, first);
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child2 = this.getFirstChildNode();
        if (child2 != null) {
            this.removeRange(child2, null);
        }
    }

    public void addChildren(@NotNull ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        if (firstChild == null) {
            CompositeElement.$$$reportNull$$$0(41);
        }
        ASTNode f = firstChild;
        while (f != lastChild) {
            ASTNode next = f.getTreeNext();
            this.addChild(f, anchorBefore);
            f = next;
        }
    }

    @Nullable
    final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper2 = this.myWrapper;
        if (wrapper2 != null) {
            return wrapper2;
        }
        wrapper2 = this.createPsiNoLock();
        return myWrapperUpdater.compareAndSet(this, null, wrapper2) ? wrapper2 : Objects.requireNonNull(this.myWrapper);
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompositeElement.$$$reportNull$$$0(42);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement((ASTNode)this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        PsiElement prev2;
        if (psi == null) {
            CompositeElement.$$$reportNull$$$0(43);
        }
        if ((prev2 = this.myWrapper) != null && prev2 != psi) {
            DebugUtil.onInvalidated(prev2);
        }
        this.myWrapper = psi;
    }

    void clearPsi() {
        this.myWrapper = null;
    }

    @Override
    public final void applyInsertOnReparse(@NotNull ASTNode newChild, ASTNode anchor2) {
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(44);
        }
        TreeElement newTreeElement = (TreeElement)newChild;
        newTreeElement.rawRemove();
        if (anchor2 != null) {
            TreeElement anchorTreeElement = (TreeElement)anchor2;
            anchorTreeElement.rawInsertAfterMe(newTreeElement);
        } else {
            TreeElement firstChildNode = this.getFirstChildNode();
            if (firstChildNode != null) {
                firstChildNode.rawInsertBeforeMe(newTreeElement);
            } else {
                this.rawAddChildren(newTreeElement);
            }
        }
        newTreeElement.clearCaches();
        this.subtreeChanged();
    }

    @Override
    public final void applyDeleteOnReparse(@NotNull ASTNode oldChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(45);
        }
        ((TreeElement)oldChild).rawRemove();
        this.subtreeChanged();
    }

    @Override
    public final void applyReplaceFileOnReparse(@NotNull PsiFile psiFile, @NotNull FileASTNode newNode) {
        ASTNode firstChildNode;
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(46);
        }
        if (newNode == null) {
            CompositeElement.$$$reportNull$$$0(47);
        }
        if (this.getFirstChildNode() != null) {
            this.rawRemoveAllChildren();
        }
        if ((firstChildNode = newNode.getFirstChildNode()) != null) {
            this.rawAddChildren((TreeElement)firstChildNode);
        }
        ((PsiFileImpl)psiFile).calcTreeElement().setCharTable(newNode.getCharTable());
        this.subtreeChanged();
    }

    public final void rawAddChildren(@NotNull TreeElement first) {
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(48);
        }
        this.rawAddChildrenWithoutNotifications(first);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        TreeElement last;
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(49);
        }
        if ((last = this.getLastChildNode()) == null) {
            TreeElement chainLast = CompositeElement.rawSetParents(first, this);
            this.setFirstChildNode(first);
            this.setLastChildNode(chainLast);
        } else {
            last.rawInsertAfterMeWithoutNotifications(first);
        }
        DebugUtil.checkTreeStructure(this);
    }

    @NotNull
    static TreeElement rawSetParents(@NotNull TreeElement child2, @NotNull CompositeElement parent) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(50);
        }
        if (parent == null) {
            CompositeElement.$$$reportNull$$$0(51);
        }
        child2.rawRemoveUpToWithoutNotifications(null, false);
        while (true) {
            child2.setTreeParent(parent);
            TreeElement treeNext = child2.getTreeNext();
            if (treeNext == null) {
                TreeElement treeElement = child2;
                if (treeElement == null) {
                    CompositeElement.$$$reportNull$$$0(52);
                }
                return treeElement;
            }
            child2 = treeNext;
        }
    }

    public void rawRemoveAllChildren() {
        TreeElement first = this.getFirstChildNode();
        if (first != null) {
            first.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(@NotNull CompositeElement oldParent, TreeElement oldChild) {
        if (oldParent == null) {
            CompositeElement.$$$reportNull$$$0(53);
        }
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull CompositeElement parent, @NotNull TreeElement first) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(54);
        }
        if (parent == null) {
            CompositeElement.$$$reportNull$$$0(55);
        }
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(56);
        }
        destinationTreeChange.addElementaryChange(parent);
        parent.rawAddChildren(first);
    }

    private static void remove(@NotNull TreeChangeEventImpl destinationTreeChange, TreeElement first, TreeElement last) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(57);
        }
        if (first != null) {
            destinationTreeChange.addElementaryChange(first.getTreeParent());
            first.rawRemoveUpTo(last);
        }
    }

    private static void insertBefore(@NotNull TreeChangeEventImpl destinationTreeChange, @NotNull TreeElement anchorBefore, @NotNull TreeElement first) {
        if (destinationTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(58);
        }
        if (anchorBefore == null) {
            CompositeElement.$$$reportNull$$$0(59);
        }
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(60);
        }
        destinationTreeChange.addElementaryChange(anchorBefore.getTreeParent());
        anchorBefore.rawInsertBeforeMe(first);
    }

    private static void replace(@NotNull TreeChangeEventImpl sourceTreeChange, @NotNull TreeElement oldChild, @NotNull TreeElement newChild) {
        if (sourceTreeChange == null) {
            CompositeElement.$$$reportNull$$$0(61);
        }
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(62);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(63);
        }
        sourceTreeChange.addElementaryChange(oldChild.getTreeParent());
        oldChild.rawReplaceWithList(newChild);
    }

    private static void removeChildInner(@NotNull TreeElement child2) {
        if (child2 == null) {
            CompositeElement.$$$reportNull$$$0(64);
        }
        CompositeElement.removeChildrenInner(child2, child2.getTreeNext());
    }

    private static void removeChildrenInner(@NotNull TreeElement first, TreeElement last) {
        FileElement fileElement;
        if (first == null) {
            CompositeElement.$$$reportNull$$$0(65);
        }
        if ((fileElement = TreeUtil.getFileElement(first)) != null) {
            ChangeUtil.prepareAndRunChangeAction(destinationTreeChange -> {
                CompositeElement.remove((TreeChangeEventImpl)destinationTreeChange, first, last);
                CompositeElement.repairRemovedElement(fileElement, first);
            }, first.getTreeParent());
        } else {
            first.rawRemoveUpTo(last);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 37: 
            case 48: 
            case 49: 
            case 56: 
            case 60: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 38: 
            case 45: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 39: 
            case 44: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherParent";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParent";
                break;
            }
            case 54: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationTreeChange";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTreeChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiElements";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "drillDown";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "rawSetParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 52: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertThreading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadingDiagnostics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonPhysicalOrInjected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptTree";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiChildByType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 19: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiElements";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "drillDown";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "replaceAllChildrenToChildrenOf";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "applyInsertOnReparse";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "applyDeleteOnReparse";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "applyReplaceFileOnReparse";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildren";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "rawSetParents";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "repairRemovedElement";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "insertBefore";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeChildInner";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeChildrenInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 31: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

