/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorFacade;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.FormattingRangesExtender;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.TextRangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFormatterFacade {
    private static final Logger LOG = Logger.getInstance(CodeFormatterFacade.class);
    private final CodeStyleSettings mySettings;
    private final FormatterTagHandler myTagHandler;
    private final int myRightMargin;
    private final boolean myCanChangeWhitespaceOnly;
    private final EditorFacade myEditorFacade;

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language) {
        this(settings, language, false);
    }

    public CodeFormatterFacade(CodeStyleSettings settings, @Nullable Language language, boolean canChangeWhitespaceOnly) {
        this.mySettings = settings;
        this.myTagHandler = new FormatterTagHandler(settings);
        this.myRightMargin = this.mySettings.getRightMargin(language);
        this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
        this.myEditorFacade = EditorFacade.getInstance();
    }

    public ASTNode processElement(ASTNode element2) {
        TextRange range2 = element2.getTextRange();
        return this.processRange(element2, range2.getStartOffset(), range2.getEndOffset());
    }

    public ASTNode processRange(ASTNode element2, int startOffset, int endOffset) {
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element2);
        assert (psiElement != null);
        PsiFile file2 = psiElement.getContainingFile();
        Document document = file2.getViewProvider().getDocument();
        PsiElement elementToFormat = document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2) : psiElement;
        PsiFile fileToFormat = elementToFormat.getContainingFile();
        RangeMarker rangeMarker = null;
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)fileToFormat);
        if (builder2 != null) {
            if (document != null && endOffset < document.getTextLength()) {
                rangeMarker = document.createRangeMarker(startOffset, endOffset);
            }
            TextRange range2 = this.preprocess(element2, TextRange.create((int)startOffset, (int)endOffset));
            if (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                range2 = documentWindow.injectedToHost(range2);
            }
            FormattingModel model2 = CoreFormatterUtil.buildModel(builder2, elementToFormat, range2, this.mySettings, FormattingMode.REFORMAT);
            if (file2.getTextLength() > 0) {
                try {
                    FormatTextRanges ranges = new FormatTextRanges(range2, true);
                    this.setDisabledRanges(fileToFormat, ranges);
                    FormatterEx.getInstanceEx().format(model2, this.mySettings, this.mySettings.getIndentOptionsByFile(fileToFormat, range2), ranges);
                    this.wrapLongLinesIfNecessary(file2, document, startOffset, endOffset, this.myRightMargin);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (!psiElement.isValid()) {
                if (rangeMarker != null) {
                    PsiElement at = file2.findElementAt(rangeMarker.getStartOffset());
                    PsiElement result2 = PsiTreeUtil.getParentOfType((PsiElement)at, psiElement.getClass(), (boolean)false);
                    assert (result2 != null);
                    rangeMarker.dispose();
                    return result2.getNode();
                }
                assert (false);
            }
        }
        if (rangeMarker != null) {
            rangeMarker.dispose();
        }
        return element2;
    }

    public void processText(@NotNull PsiFile file2, FormatTextRanges ranges, boolean doPostponedFormatting) {
        FormattingModelBuilder builder2;
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(0);
        }
        Project project = file2.getProject();
        Document document = file2.getViewProvider().getDocument();
        List<FormatTextRange> textRanges = ranges.getRanges();
        if (document instanceof DocumentWindow) {
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            DocumentWindow documentWindow = (DocumentWindow)document;
            for (FormatTextRange formatTextRange : textRanges) {
                formatTextRange.setTextRange(documentWindow.injectedToHost(formatTextRange.getTextRange()));
            }
            document = documentWindow.getDelegate();
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext((PsiElement)file2)) != null && file2.getTextLength() > 0) {
            LOG.assertTrue(document != null);
            ranges.setExtendedRanges(new FormattingRangesExtender(document, file2).getExtendedRanges(ranges.getTextRanges()));
            try {
                ASTNode containingNode = CodeFormatterFacade.findContainingNode(file2, ranges.getBoundRange());
                if (containingNode != null) {
                    for (FormatTextRange range3 : ranges.getRanges()) {
                        TextRange rangeToUse = this.preprocess(containingNode, range3.getTextRange());
                        range3.setTextRange(rangeToUse);
                    }
                }
                if (doPostponedFormatting) {
                    CodeFormatterFacade.invokePostponedFormatting(file2, document, textRanges);
                }
                if (FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get().booleanValue()) {
                    return;
                }
                TextRange textRange = (TextRange)ObjectUtils.notNull((Object)ranges.getBoundRange(), (Object)file2.getTextRange());
                FormattingModel originalModel = CoreFormatterUtil.buildModel(builder2, (PsiElement)file2, textRange, this.mySettings, FormattingMode.REFORMAT);
                DocumentBasedFormattingModel model2 = new DocumentBasedFormattingModel(originalModel, document, project, this.mySettings, file2.getFileType(), file2);
                FormatterEx formatter = FormatterEx.getInstanceEx();
                if (CodeStyleManager.getInstance((Project)project).isSequentialProcessingAllowed()) {
                    formatter.setProgressTask(new FormattingProgressTask(project, file2, document));
                }
                CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptionsByFile(file2, textRanges.size() == 1 ? textRanges.get(0).getTextRange() : null);
                this.setDisabledRanges(file2, ranges);
                formatter.format((FormattingModel)model2, this.mySettings, indentOptions, ranges);
                for (FormatTextRange range4 : textRanges) {
                    TextRange textRange2 = range4.getTextRange();
                    this.wrapLongLinesIfNecessary(file2, document, textRange2.getStartOffset(), textRange2.getEndOffset(), this.myRightMargin);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void setDisabledRanges(@NotNull PsiFile file2, FormatTextRanges ranges) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(1);
        }
        Iterable excludedRangesIterable = TextRangeUtil.excludeRanges((TextRange)file2.getTextRange(), this.myTagHandler.getEnabledRanges((ASTNode)file2.getNode(), file2.getTextRange()));
        ranges.setDisabledRanges((Collection)excludedRangesIterable);
    }

    private static void invokePostponedFormatting(@NotNull PsiFile file2, Document document, List<? extends FormatTextRange> textRanges) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(2);
        }
        RangeMarker[] markers = new RangeMarker[textRanges.size()];
        int i2 = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            TextRange textRange = formatTextRange.getTextRange();
            int start2 = textRange.getStartOffset();
            int end = textRange.getEndOffset();
            if (start2 < 0 || end <= start2 || end > document.getTextLength()) continue;
            markers[i2] = document.createRangeMarker(textRange);
            markers[i2].setGreedyToLeft(true);
            markers[i2].setGreedyToRight(true);
            ++i2;
        }
        PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(file2.getProject());
        FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
        component2.doPostponedFormatting(file2.getViewProvider());
        i2 = 0;
        for (FormatTextRange formatTextRange : textRanges) {
            RangeMarker marker = markers[i2];
            if (marker != null) {
                formatTextRange.setTextRange(TextRange.create((Segment)marker));
                marker.dispose();
            }
            ++i2;
        }
    }

    @Nullable
    static ASTNode findContainingNode(@NotNull PsiFile file2, @Nullable TextRange range2) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(3);
        }
        Language language = file2.getLanguage();
        if (range2 == null) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiElement startElement = viewProvider.findElementAt(range2.getStartOffset(), language);
        PsiElement endElement = viewProvider.findElementAt(range2.getEndOffset() - 1, language);
        PsiElement commonParent = startElement != null && endElement != null ? PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement) : null;
        ASTNode node = null;
        if (commonParent != null) {
            node = commonParent.getNode();
            for (ASTNode parent = node.getTreeParent(); parent != null && parent.getTextRange().equals((Object)commonParent.getTextRange()); parent = parent.getTreeParent()) {
                node = parent;
            }
        }
        if (node == null) {
            node = file2.getNode();
        }
        return node;
    }

    private TextRange preprocess(@NotNull ASTNode node, @NotNull TextRange range2) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(4);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(5);
        }
        TextRange result2 = range2;
        PsiElement psi = node.getPsi();
        if (!psi.isValid()) {
            return result2;
        }
        PsiFile file2 = psi.getContainingFile();
        LinkedHashSet<TextRange> injectedFileRangesSet = new LinkedHashSet<TextRange>();
        if (!psi.getProject().isDefault()) {
            List injectedDocuments = InjectedLanguageManager.getInstance((Project)file2.getProject()).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
            if (!injectedDocuments.isEmpty()) {
                for (DocumentWindow injectedDocument : injectedDocuments) {
                    injectedFileRangesSet.add(TextRange.from((int)injectedDocument.injectedToHost(0), (int)injectedDocument.getTextLength()));
                }
            } else {
                Collection<PsiLanguageInjectionHost> injectionHosts = CodeFormatterFacade.collectInjectionHosts(file2, range2);
                PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
                    for (PsiLanguageInjectionHost.Shred place : places) {
                        Segment rangeMarker = place.getHostRangeMarker();
                        injectedFileRangesSet.add(TextRange.create((int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset()));
                    }
                };
                Iterator iterator2 = injectionHosts.iterator();
                while (iterator2.hasNext()) {
                    PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)iterator2.next();
                    InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)host, visitor);
                }
            }
        }
        if (!injectedFileRangesSet.isEmpty()) {
            ArrayList ranges = new ArrayList(injectedFileRangesSet);
            Collections.reverse(ranges);
            for (TextRange injectedFileRange : ranges) {
                TextRange initialInjectedRange;
                PsiFile injected;
                int startHostOffset = injectedFileRange.getStartOffset();
                int endHostOffset = injectedFileRange.getEndOffset();
                if (startHostOffset < range2.getStartOffset() || endHostOffset > range2.getEndOffset() || (injected = InjectedLanguageUtilBase.findInjectedPsiNoCommit(file2, startHostOffset)) == null) continue;
                TextRange injectedRange = initialInjectedRange = TextRange.create((int)0, (int)injected.getTextLength());
                for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                    if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                    injectedRange = processor2.process((ASTNode)injected.getNode(), injectedRange);
                }
                if ((initialInjectedRange.getStartOffset() <= injectedRange.getStartOffset() || initialInjectedRange.getStartOffset() <= 0) && (initialInjectedRange.getEndOffset() >= injectedRange.getEndOffset() || initialInjectedRange.getEndOffset() >= injected.getTextLength())) continue;
                range2 = TextRange.create((int)(range2.getStartOffset() + injectedRange.getStartOffset() - initialInjectedRange.getStartOffset()), (int)(range2.getEndOffset() + initialInjectedRange.getEndOffset() - injectedRange.getEndOffset()));
            }
        }
        if (!this.mySettings.FORMATTER_TAGS_ENABLED) {
            for (PreFormatProcessor processor3 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor3.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                result2 = processor3.process(node, result2);
            }
        } else {
            result2 = this.preprocessEnabledRanges(node, result2);
        }
        return result2;
    }

    private TextRange preprocessEnabledRanges(@NotNull ASTNode node, @NotNull TextRange range2) {
        if (node == null) {
            CodeFormatterFacade.$$$reportNull$$$0(6);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(7);
        }
        TextRange result2 = TextRange.create((int)range2.getStartOffset(), (int)range2.getEndOffset());
        List<TextRange> enabledRanges = this.myTagHandler.getEnabledRanges(node, result2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PreFormatProcessor processor2 : PreFormatProcessor.EP_NAME.getExtensionList()) {
                if (!processor2.changesWhitespacesOnly() && this.myCanChangeWhitespaceOnly) continue;
                TextRange processedRange = processor2.process(node, enabledRange);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
        result2 = result2.grown(delta);
        return result2;
    }

    @NotNull
    private static Collection<PsiLanguageInjectionHost> collectInjectionHosts(@NotNull PsiFile file2, @NotNull TextRange range2) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(8);
        }
        if (range2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(9);
        }
        Stack<PsiElement> toProcess = new Stack<PsiElement>();
        for (PsiElement e = file2.findElementAt(range2.getStartOffset()); e != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); e = e.getNextSibling()) {
            toProcess.push(e);
        }
        if (toProcess.isEmpty()) {
            Set<PsiLanguageInjectionHost> set2 = Collections.emptySet();
            if (set2 == null) {
                CodeFormatterFacade.$$$reportNull$$$0(10);
            }
            return set2;
        }
        HashSet<PsiLanguageInjectionHost> result2 = null;
        while (!toProcess.isEmpty()) {
            PsiElement e = (PsiElement)toProcess.pop();
            if (e instanceof PsiLanguageInjectionHost) {
                if (result2 == null) {
                    result2 = new HashSet<PsiLanguageInjectionHost>();
                }
                result2.add((PsiLanguageInjectionHost)e);
                continue;
            }
            for (PsiElement child2 = e.getFirstChild(); child2 != null && e.getTextRange().getStartOffset() < range2.getEndOffset(); child2 = child2.getNextSibling()) {
                toProcess.push(child2);
            }
        }
        Set<PsiLanguageInjectionHost> set3 = result2 == null ? Collections.emptySet() : result2;
        if (set3 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(11);
        }
        return set3;
    }

    private void wrapLongLinesIfNecessary(@NotNull PsiFile file2, @Nullable Document document, int startOffset, int endOffset, int rightMargin) {
        if (file2 == null) {
            CodeFormatterFacade.$$$reportNull$$$0(12);
        }
        if (!this.mySettings.getCommonSettings((Language)file2.getLanguage()).WRAP_LONG_LINES || PostprocessReformattingAspect.getInstance(file2.getProject()).isViewProviderLocked(file2.getViewProvider()) || document == null) {
            return;
        }
        FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyle.getSettings((PsiFile)file2));
        List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), new TextRange(startOffset, endOffset));
        this.myEditorFacade.wrapLongLinesIfNecessary(file2, document, startOffset, endOffset, enabledRanges, rightMargin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeFormatterFacade";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInjectionHosts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokePostponedFormatting";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnabledRanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectInjectionHosts";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapLongLinesIfNecessary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

