/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class IdIndexEntriesExternalizer
implements DataExternalizer<Collection<IdIndexEntry>> {
    private static final ThreadLocalCachedIntArray spareBufferLocal = new ThreadLocalCachedIntArray();

    IdIndexEntriesExternalizer() {
    }

    public void save(@NotNull DataOutput out, @NotNull Collection<IdIndexEntry> value2) throws IOException {
        if (out == null) {
            IdIndexEntriesExternalizer.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            IdIndexEntriesExternalizer.$$$reportNull$$$0(1);
        }
        int size = value2.size();
        int[] values = spareBufferLocal.getBuffer(size);
        int ptr = 0;
        for (IdIndexEntry ie : value2) {
            values[ptr++] = ie.getWordHashCode();
        }
        Arrays.sort(values, 0, size);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
        int prev2 = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            DataInputOutputUtil.writeLONG((DataOutput)out, (long)((long)values[i2] - (long)prev2));
            prev2 = values[i2];
        }
    }

    public Collection<IdIndexEntry> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            IdIndexEntriesExternalizer.$$$reportNull$$$0(2);
        }
        int length = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<IdIndexEntry> entries2 = new ArrayList<IdIndexEntry>(length);
        int prev2 = 0;
        while (length-- > 0) {
            int l = (int)(DataInputOutputUtil.readLONG((DataInput)in) + (long)prev2);
            entries2.add(new IdIndexEntry(l));
            prev2 = l;
        }
        return entries2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndexEntriesExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

