/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.id.LexingIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.IndexPattern;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class BaseFilterLexerUtil {
    private static final Key<ScanContent> scanContentKey = Key.create((String)"id.todo.scan.content");
    private static final ScanContent EMPTY = new ScanContent(Collections.emptyMap(), Collections.emptyMap());

    public static ScanContent scanContent(FileContent content2, IdAndToDoScannerBasedOnFilterLexer indexer) {
        ScanContent data2 = (ScanContent)content2.getUserData(scanContentKey);
        if (data2 != null) {
            content2.putUserData(scanContentKey, null);
            return data2;
        }
        boolean needIdIndex = IdTableBuilding.getFileTypeIndexer(content2.getFileType()) instanceof LexingIdIndexer;
        IndexPattern[] todoPatterns = IndexPatternUtil.getIndexPatterns();
        if (!needIdIndex && todoPatterns.length <= 0) {
            return EMPTY;
        }
        boolean needTodo = TodoIndexers.needsTodoIndex((IndexedFile)content2) || content2.getFile() instanceof LightVirtualFile;
        data2 = BaseFilterLexerUtil.doScanContent(content2, indexer, needIdIndex, needTodo, todoPatterns);
        if (needIdIndex && needTodo) {
            content2.putUserData(scanContentKey, (Object)data2);
        }
        return data2;
    }

    @NotNull
    public static ScanContent doScanContent(@NotNull FileContent content2, @NotNull IdAndToDoScannerBasedOnFilterLexer indexer, boolean needIdIndex, boolean needTodo, IndexPattern @NotNull [] todoPatterns) {
        if (content2 == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(0);
        }
        if (indexer == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(1);
        }
        if (todoPatterns == null) {
            BaseFilterLexerUtil.$$$reportNull$$$0(2);
        }
        IdDataConsumer consumer2 = needIdIndex ? new IdDataConsumer() : null;
        OccurrenceConsumer todoOccurrenceConsumer = new OccurrenceConsumer(consumer2, needTodo);
        Lexer filterLexer = indexer.createLexer(todoOccurrenceConsumer);
        filterLexer.start(content2.getContentAsText());
        while (filterLexer.getTokenType() != null) {
            filterLexer.advance();
        }
        Map<TodoIndexEntry, Integer> todoMap = null;
        if (needTodo) {
            for (IndexPattern indexPattern : todoPatterns) {
                int count = todoOccurrenceConsumer.getOccurrenceCount(indexPattern);
                if (count <= 0) continue;
                if (todoMap == null) {
                    todoMap = new HashMap<TodoIndexEntry, Integer>();
                }
                todoMap.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
            }
        }
        return new ScanContent(consumer2 != null ? consumer2.getResult() : Collections.emptyMap(), todoMap != null ? todoMap : Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "content";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "indexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "todoPatterns";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/cache/impl/BaseFilterLexerUtil";
        objectArray[2] = "doScanContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ScanContent {
        public final Map<IdIndexEntry, Integer> idMap;
        public final Map<TodoIndexEntry, Integer> todoMap;

        public ScanContent(Map<IdIndexEntry, Integer> _idMap, Map<TodoIndexEntry, Integer> _todoMap) {
            this.idMap = _idMap;
            this.todoMap = _todoMap;
        }
    }
}

