/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.stream.Stream;

public class AndFilter
implements ElementFilter {
    private final ElementFilter[] myFilters;

    public AndFilter(ElementFilter filter1, ElementFilter filter2) {
        this.myFilters = new ElementFilter[]{filter1, filter2};
    }

    public AndFilter(ElementFilter ... filters) {
        this.myFilters = filters;
    }

    public boolean isAcceptable(Object element2, PsiElement context) {
        return Stream.of(this.myFilters).allMatch(filter -> filter.isAcceptable(element2, context));
    }

    public boolean isClassAcceptable(Class elementClass) {
        return Stream.of(this.myFilters).allMatch(filter -> filter.isClassAcceptable(elementClass));
    }

    public String toString() {
        return '(' + StringUtil.join((Object[])this.myFilters, ElementFilter::toString, (String)" & ") + ')';
    }
}

